# Copyright (C) 2004-2005 Laurent Sansonetti

File.open('alexandria', 'w') do |file|
    file.print <<EOF
#!/path/to/ruby -Ku
#
# This file is automatically generated by the installer.
# Do not edit by hands.

require 'gettext'
require 'alexandria'

begin
    Alexandria.main
rescue => e
    $stderr.puts <<EOS
-----------------------
Alexandria just crashed
-----------------------
Timestamp: \#{Time.now}
Message: \#{e.message}
Backtrace:
\#{e.backtrace.join("\\n")}
Release: \#{Alexandria::VERSION}
Uname -a: \#{`uname -a`.chomp}
--
Please report this dump to '\#{Alexandria::LIST}' with some additional
information, such as the description of the crash and the steps to reproduce it
(if it's possible).
EOS
    exit 1
end
EOF
end
