// ---------------------------------------------------------------------------
// - Libaodb.cpp                                                             -
// - aleph:odb library - declaration & implementation                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Meta.hpp"
#include "Libaodb.hpp"
#include "Function.hpp"
#include "Odbcalls.hpp"
#include "Collection.hpp"

namespace aleph {
  // initialize the the library

  Object* init_aleph_odb (Interp* interp, Vector* argv) {
    // make sure we are not called from something crazy
    if (interp == nilp) return nilp;
    
    // create the aleph:sys nameset
    Nameset* eth = interp->mknset ("aleph", interp->getgset ());
    Nameset* odb = interp->mknset ("odb",   eth);
    
    // bind all classes in the aleph:net nameset
    odb->symcst ("Cell",          new Meta (Cell::mknew));
    odb->symcst ("Table",         new Meta (Table::mknew));
    odb->symcst ("Record",        new Meta (Record::mknew));
    odb->symcst ("Collection",    new Meta (Collection::mknew));
    
    // bind the standard functions
    odb->symcst ("read",          new Function (odb_read));

    // not used but needed
    return nilp;
  }
}

extern "C" {
  aleph::Object* dli_aleph_odb (aleph::Interp* interp, aleph::Vector* argv) {
    return init_aleph_odb (interp, argv);
  }
}
