# ---------------------------------------------------------------------------
# - t_7005.als                                                              -
# - aleph:net library test module                                           -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2003 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   multicast test module
# @author amaury darsch

# get the library
interp:library "aleph-sys"
interp:library "aleph-net"

try {
  # create a multicast class
  const s (aleph:net:Multicast "224.0.0.10")
  # write and read from this socket
  s:write "hello world"
  trans   dg (s:accept)
  assert  11 (dg:get-buffer-length)
  assert "hello world" (dg:readln)
  # close and exit
  s:close
} (aleph:sys:exit 1)
