// ---------------------------------------------------------------------------
// - Resume.hpp                                                              -
// - aleph cross debugger - resume exception class definition                -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_RESUME_HPP
#define  ALEPH_RESUME_HPP

#ifndef  ALEPH_OBJECT_HPP
#include "Object.hpp"
#endif

namespace aleph {

  /// The Resume class is the object used to tell the debugger to resume
  /// the execution after a breakpoint. It is an error to throw this object
  /// from the top level debugger loop.
  /// @author amaury darsch

  class Resume : public Object {
  public:
    /// @resume the class name
    String repr (void) const;

  private:
    // make the assignment operator private
    Resume& operator = (const Resume&);
  };
}

#endif
