#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
from mod_python import util, apache
from albatross.cgiapp import RequestFields, FileField


class Request(RequestFields):

    def __init__(self, req):
        self.__req = req
        RequestFields.__init__(self, util.FieldStorage(self.__req))
        self.__status = 200

    def get_uri(self):
        return self.__req.uri

    def get_path_info(self):
        return self.__req.path_info

    def get_servername(self):
        try:
            return self.__req.hostname                          # mod_python 3
        except AttributeError:
            return self.__req.connection.server.server_hostname # mod_python 2

    def get_header(self, name):
        if self.__req.headers_in.has_key(name):
            return self.__req.headers_in[name]

    def write_header(self, name, value):
        if name.lower() == 'content-type':
            self.__req.content_type = value
        else:
            self.__req.headers_out[name] = value

    def end_headers(self):
        self.__req.send_http_header()

    def redirect(self, loc):
        self.write_header('Location', loc)
        return apache.HTTP_MOVED_PERMANENTLY

    def write_content(self, data):
        self.__req.write(data)

    def set_status(self, status):
        self.__status = status

    def status(self):
        if self.__status == 200:
            return 0
        return self.__status
