
#include <stdio.h>
#include <windows.h>
#include "iphlp.h"
#include "wlancap.h"

typedef struct Buffer_t {
	int data[12];
} Buffer;

void dump(unsigned char *pkt, int len) {
   int i = 0;
   int j = 0;
   for (i = 0; i < len; i += 16) {
      for (j = 0; j < 16; j++) {
         if (i + j >= len) {
            fprintf(stderr, "   "); 
         }
         else {
            fprintf(stderr, "%2.2x ", pkt[i + j]); 
         }
      }
      fprintf(stderr, "  "); 
      for (j = 0; j < 16; j++) {
         if (i + j >= len) break;
         if (isprint(pkt[i + j])) {
            fprintf(stderr, "%c", pkt[i + j]); 
         }
         else {
            fprintf(stderr, "."); 
         }
      }
      fprintf(stderr, "\n"); 
   }
   fprintf(stderr, "\n----------------------------------------------------------------\n\n"); 
}

void *myCallback(WlanPacket *ptr, unsigned int val1, int val2, __int64 tStamp, int val3, void *userPtr) {
   dump(ptr->data, val1 - 4);
	return (void*) 1;
}

typedef DWORD (__stdcall *MYFUNC)(PIP_ADAPTER_INFO, ULONG*);

char *listAdapters() {
   static MYFUNC getInfo = NULL;
   PIP_ADAPTER_INFO i, pAdapterInfo = NULL;
   ULONG len = 0;
   DWORD rval = 0;
   static char result[MAX_ADAPTER_NAME_LENGTH + 10] = "\\Device\\";
   fprintf(stderr, "Inside listAdapters\n");

   if (getInfo == NULL) {
      HINSTANCE iphlpapi = LoadLibrary("iphlpapi");
      if (iphlpapi == NULL) {
         fprintf(stderr, "couldn't load iphlpapi.dll\n");
         return NULL;
      }
      getInfo = (MYFUNC) GetProcAddress(iphlpapi, "GetAdaptersInfo");
      if (getInfo == NULL) {
         fprintf(stderr, "couldn't GetProcAddress for GetAdaptersInfo\n");
         return NULL;
      }
      //FreeLibrary(iphlpapi);
   }

   if (((getInfo)(pAdapterInfo, &len)) == ERROR_BUFFER_OVERFLOW) {
      fprintf(stderr, "Successful GetAdaptersInfo, doing malloc\n");
      pAdapterInfo = (PIP_ADAPTER_INFO) malloc(len);
      if (pAdapterInfo == NULL) {
         fprintf(stderr, "malloc failed, len = %d\n", len);
         return NULL;
      }
   }
   else {  //failed, since we expected ERROR_BUFFER_OVERFLOW
      fprintf(stderr, "Failed GetAdaptersInfo1\n");
      return NULL;
   }

   if ((getInfo)(pAdapterInfo, &len) == ERROR_BUFFER_OVERFLOW) {
      fprintf(stderr, "Failed GetAdaptersInfo2, %X or %d\n", rval, rval);
      return NULL;
   }
   for (i = pAdapterInfo; i; i = i->Next) {
      printf("AdapterName %s\n", i->AdapterName);
      strcpy(result + 8, i->AdapterName);
      printf("Description %s\n", i->Description);
   }
   return result;}

int main() {

	HANDLE hAdapter = 0;
	Context *pContext;
   LONG result;
   char *adapterName = NULL;
   adapterName = listAdapters();
//	char adapterName[] = "\\Device\\{6CB9D388-3838-4282-9B9D-54A90338FC8A}";

	if (adapterName) {
	   printf("using adapter: %s\n", adapterName);
   	hAdapter = WincapOpenAdapter(adapterName);
   	pContext = WincapCreateContext(hAdapter, myCallback, 0xFA000, SCAN, NULL);
      result = WincapStart(pContext);
      result = WincapGetLastError();
   	while (1) {
   		Sleep(INFINITE);
   	}
   }
}
