/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <signal.h>
#ifndef WIN32
#include <sys/time.h>
#else
#include <windows.h>
#endif

#include "interface.h"
#include "support.h"

int resetMAC();
#ifndef WIN32
void changeChannel(int);
#else
VOID CALLBACK changeChannel(HWND, UINT, UINT, DWORD);
#endif
void loadOpts();

#include "RC4.h"

int
main (int argc, char *argv[])
{
  //this will be the channel scanning interval, currently 0.2 sec
#ifndef WIN32
  struct itimerval tval;
  struct timeval interval = {0, 200000};
#endif

  GtkWidget *AirSnortWindow;

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  setupIdentity();
  loadOpts();

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  AirSnortWindow = create_AirSnortWindow ();
  gtk_widget_show (AirSnortWindow);

  //this sets up the kchannel scanning stuff
#ifndef WIN32
  signal(SIGALRM, changeChannel);
  tval.it_interval = interval;
  tval.it_value = interval;
  setitimer(ITIMER_REAL, &tval, NULL);
#else
  SetTimer(NULL, 0, 200, changeChannel); //200 ms timer = 0.2 sec
#endif

  gtk_main ();
  resetMAC();
  return 0;
}

