/**********************************************************************
 ** main function: the main function that starts out the program
 **
 **
 **********************************************************************/

#ifndef CONVMAIN_C
#define CONVMAIN_C
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "convconfig.h"
#include "convmain.h"
#include "../../include/strings.h"
#include "aberpdirt.h"
#include "modules.h"
#include "generator.h"

int main(int argc, char *argv[])
{
   int     i;
   int     has_read = 0;
   int     has_write = 0;
   Strings read_filename;
   Strings write_filename;
   Strings pseudo_filename;
   Strings holder;
   Strings format;
   FILE    *read_file;
   FILE    *write_file;
   char    user_input[10];
   int     pseudo_only = 0;
   int     start_pseudo = 0;
   int     prompt = 0;
   char    *str_ptr;
   Generator *the_gen;
   int     results;

   /* Show program info */
   printf("\033[1;37mZone file converter - "
          "(c) 1999, 2000 George Noel ("CONV_VERSION")\033[40m\033[0m\n");

   for (i=1; i < argc; i++)
   {
      /* if we have an option here */
      if (argv[i][0] == '-')
      {

	 /* if they are specifying a format */
         if (!strcasecmp("format", &argv[i][1]))
	 {
            i++;
            if ((i >= argc) || (argv[i][0] == '-'))
	    {
               show_formats();
               exit(0);
            }
            
            format = &argv[i][0];
         }
         else if (!strcasecmp("all", &argv[i][1]))
	 {
            printf("Ignoring defunct parameter -all\n");
	 }
	 else if (!strcasecmp("pseudo", &argv[i][1]))
	 {
	    pseudo_only = 1;
	 }
	 else if (!strcasecmp("prompt", &argv[i][1]))
	 {
	    prompt = 1;
	 }
         else
	 {
            printf("Invalid option %s.\n", argv[i]);
            show_usage(argv[0]);
            exit(0);
         }
      }
      else
      {
         if (!has_read)
	 {
            read_filename = argv[i];
            has_read = 1;
         }
         else if (!has_write)
	 {
            write_filename = argv[i];
            has_write = 1;
         }
         else
	 {
            show_usage(argv[0]);
            exit(0);
         }
      }   
   }

   if ((read_filename.str_show() == NULL) || 
       (write_filename.str_show() == NULL))
   {
      printf("You must state read and write filenames.\n");
      show_usage(argv[0]);
      exit(0);
   }

   // First we open the read file they specified
   if ((read_file = fopen(read_filename.str_show(), "r")) == NULL)
   {
      printf("Error opening read file '%s', it may not exist.\n", 
                                     read_filename.str_show());
      exit(0);
   }

   // Now we check if this is a pseudo-data file
   str_ptr = read_filename.str_show();
   while ((str_ptr) && (*str_ptr) && (*str_ptr != '.'))
     str_ptr++;

   if ((*str_ptr) && *(str_ptr+1))
   {
     if (!strcmp((str_ptr+1), "aime"))
       start_pseudo = 1;
   }

   // Next, we open the pseudo-data file to write to
   if (pseudo_only)
   {
     if (start_pseudo)
     {
       printf("The file is already in pseudo-data format.\n");
       exit(0);
     }
     pseudo_filename = write_filename.str_show();
   }
   else
   {
      holder = write_filename.str_show();
      str_ptr = holder.str_show();
      while ((str_ptr) && (*str_ptr) && (*str_ptr != '.'))
	str_ptr++;
      if (*str_ptr)
	*str_ptr == '\0';
      pseudo_filename = holder.str_show();
      pseudo_filename.str_cat(".aime");
   }

   if (prompt)
   {
      if ((write_file = fopen(pseudo_filename.str_show(), "r")) != NULL)
      {
         printf("The pseudo-data file '%s' already exists, overwrite? (y/n) ", 
                                     pseudo_filename.str_show());
         fgets(user_input, 10, stdin);
         if (user_input[0] != 'y')
         {
            printf("Okily dokily, not overwriting.\n");
  	    fclose(read_file);
	    fclose(write_file);
            exit(0);
         }      
      }
      if (write_file != NULL)
         fclose(write_file);
   }

   if (convert_file(read_file, pseudo_filename.str_show(), format.str_show(),  
                                                read_filename.str_show()) <= 0)
   {
      printf("Conversion terminated creating pseudo-data file.\n");
      fclose(read_file);
      exit(0);
   }

   fclose(read_file);

   // If they only want a pseudo-data file, we are done so exit
   if (pseudo_only)
      exit(1);

   // Now open the pseudo-data file for reading
   if ((read_file = fopen(pseudo_filename.str_show(), "r")) == NULL)
   {
      printf("Error opening pseudo-data file '%s'.\n", 
                                     pseudo_filename.str_show());
      exit(0);
   }

   if (prompt)
   {
     if ((write_file = fopen(write_filename.str_show(), "r")) != NULL)
     {
       printf("The file '%s' already exists, overwrite? (y/n) ", 
                                     write_filename.str_show());
       fgets(user_input, 10, stdin);
       if (user_input[0] != 'y')
       {
         printf("Okily dokily, not overwriting.\n");
	 fclose(read_file);
	 fclose(write_file);
         exit(0);
       }
     }      
     if (write_file != NULL)
        fclose(write_file);

   }

   // Now open the data file for writing to
   if ((write_file = fopen(write_filename.str_show(), "w+")) == NULL)
   {
      printf("Error opening aime data write file '%s'.\n", 
                                     write_filename.str_show());
      exit(0);      
   }

   the_gen = new Generator(write_file, 
                                has_large_header(read_filename.str_show()));

   while ((results = the_gen->generate_element(read_file)) > 0);

   if (results == -1)
   {
      if (start_pseudo)
         printf("Failed trying to generate AIME data file.");
      else
	 printf("Pseudo-data file successfully Generated, "
		"but failed trying to generate AIME data file.");
      fclose(write_file);
      exit(0);
   }
   
   printf("Conversion successfully completed.\n");

   if (read_file != NULL)
      fclose(read_file);
   if (write_file != NULL)
      fclose(write_file);
   exit(1);
}


void show_usage(char *executeable)
{
   printf("\nUsage: %s [-format <format>] [<flags>] "
                                "<filename> <new_filename>\n\n" 
       "       -format  : Format of file to convert.\n"
       "       -all     : now defunct\n"
       "       -prompt  : Prompt for overwriting files\n"
       "       -pseudo  : Convert only to pseudo-format\n\n", executeable);
}


void show_formats()
{
   int i = 0;

   printf("\nCurrent supported formats are: \n");
   while (mod_list[i].module_name != NULL)
   {
      printf("\t%s\n", mod_list[i].module_name);
      i++;
   }
   printf("\n\n");
}


int has_large_header(char *filename)
{
   char *filename_ptr;
   char *last_slash = NULL;

   filename_ptr = filename;
   while ((filename_ptr) && (*filename_ptr) && (*filename_ptr != '.'))
   {
     if (*filename_ptr == '/')
       last_slash = filename_ptr;
     filename_ptr++;
   }

   if (last_slash == NULL)
     last_slash = filename;
   else
     last_slash++;

   *filename_ptr = '\0';

   if ((!strcasecmp(last_slash, "abilities")) ||
       (!strcasecmp(last_slash, "actions")) ||
       (!strcasecmp(last_slash, "races")) ||
       (!strcasecmp(last_slash, "levels")) ||
       (!strcasecmp(last_slash, "quests")) ||
       (!strcasecmp(last_slash, "masks")) || 
       (!strcasecmp(last_slash, "chatlines")))
      return 0;

   return 1;
}



#endif

























