#ifndef _SPECIAL_FUNC_H
#define _SPECIAL_FUNC_H

#include "specials.h"
#include "code.h"
#include "individual.h"
#include "linkedlist.h"
#include "config.h"

/****************************
 * communications functions
 ****************************/


params *send_actor(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *send_all_room(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *send_all_room_except(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *send_room_except_dual(LinkedList<params> *the_params, Specials *the_special,
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);
params *send_obj_room(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *send_to_room(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *send_to(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);
params *send_holder(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *tell_ind(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);
params *send_all_except(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);
params *send_all(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);

/****************************************
 * flow control functions
 ****************************************/

params *goto_spec(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *goto_if_eq(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *goto_if_neq(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *goto_if_less(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *ret_inv_crit(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *force_termination(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *force_failure(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *force_success(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);

/****************************************
 * comparison functions
 ****************************************/


params *is_string_eq(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);

/****************************
 * functions for all objects
 ****************************/

params *set(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *get(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *set_brief(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *set_examine(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *destroy_this_obj(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *get_parent_name(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);
params *is_individual(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *clone_object(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *spec_add_status(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *remove_status(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *has_status(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *move_object(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *object_exists(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *attach_special(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *detach_special(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);


/****************************
 * item functions
 ****************************/

params *is_itemflag_set(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *set_itemflag(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment,
                                                               int *results);
params *clr_itemflag(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *light_all_room(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);


/****************************
 * individual functions
 ****************************/

params *ambush_individual(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *damage_individual(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *damage_all_room(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *fight_player(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *is_indflag_set(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *set_indflag(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment,
                                                               int *results);
params *clr_indflag(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment,
                                                               int *results);
params *ind_holds(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment,
                                                               int *results);
params *ind_wears(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment,
                                                               int *results);
params *is_a_corpse(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment,
                                                               int *results);



/****************************
 * player functions
 ****************************/


params *trans_actor(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *add_ability(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *remove_ability(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *has_ability(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *boot_off(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *award_quest(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *advance_experience(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);
params *push_prompt(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);
params *pop_prompt(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);
params *start_busy(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *end_busy(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);


/****************************
 * functions for mergers
 ****************************/

params *decrement_number_of(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);
params *increment_number_of(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);
params *get_number_of(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);


/****************************
 * functions for doors
 ****************************/

params *set_door_state(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);
params *get_door_state(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);


/****************************
 * functions for locations
 ****************************/

params *get_loc_by_dir(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);
params *display_loc(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);
params *display_objects(LinkedList<params> *the_params, Specials *the_special, 
   Individual *the_user, in_params *player_params, special_env *environment, 
                                                             int *results);



/**********************************
 * Functions to read and manipulate
 * specials attributes
 **********************************/

params *decrement_counter(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *increment_counter(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *get_counter(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *set_counter(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *set_param(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *set_store_int(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *get_store_int(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *get_target_str(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);


/**********************************
 * Functions to manipulate a number
 * and return a new value
 **********************************/

params *increment_number(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *decrement_number(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);


/**********************************
 * Functions to get and use a
 * random number
 **********************************/

params *get_random(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *select_rand_param(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);


/**********************************
 * Miscellaneous Functions
 **********************************/

params *test_for_success(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *exit_tutorial(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);
params *apply_special_loc(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);


/************************************
 * Functions to manage an assignment
 ************************************/

params *assign(LinkedList<params> *the_params, Specials *the_special, 
     Individual *the_user, in_params *player_params, special_env *environment, 
                                                               int *results);

#endif



