#ifndef _SHOP_H
#define _SHOP_H

#include "mudtypes.h"
#include "strings.h"
#include "builder.h"
#include "player.h"
#include "money.h"
#include "location.h"

class Mobile;

enum exchange_type { Buy, Sell, Dual };

struct shop_item {
   Strings       itemname;
   Strings       alias;
   int           value;
   exchange_type the_type;       
   Strings       description;
   int           num_of;
   shop_item     *next_item;
};

struct buy_request {
   Strings     playername;
   shop_item   *item;
   int         num_of;
   buy_request *next_request;
};


class Shop {
public:

   Shop();
   ~Shop();

   char  *get_name();
   int   set_name(char *the_name);
   char  *get_currency();
   int   set_currency(char *the_name);
   int   add_shop_item(char *the_name, char *alias, int value);
   int   del_shop_item(char *alias);
   int   rename_shop_item(char *alias, char *newalias);
   int   write_shop(FILE *the_file);
   void  display_shop(Builder *the_builder);
   int   set_itemname(char *the_alias, char *the_itemname);
   int   set_value(char *the_alias, int the_value);
   int   set_type(char *the_alias, exchange_type the_value);
   int   set_num_of(char *the_alias, int the_value);
   int   display_wares(Player *the_player);
   int   display_will_buy(Player *the_plr);
   Money *get_currency_ptr(void);
   int   add_request(Player *the_player, char *alias, int num_of);
   int   remove_request(char *the_name);
   int   update_requests(Location *the_loc);
   int   get_request_cost(Player *the_player);
   int   complete_transaction(Player *the_player, Mobile *the_mobile, 
                                                      Money *the_money);
   int   complete_sell(Player *the_player, Mobile *the_mobile, 
                                                      MudObject *the_obj);
   char  *get_desc(char *the_alias);
   int   set_desc(char *the_alias, char *the_desc);
   int   bldr_set_desc(char *the_alias, Builder *the_builder);
   int   get_mem_size();
   int   get_mem_size_dynamic();

private:

   shop_item   *get_shop_item(char *the_alias);

   Strings     name;
   Strings     currency;
   shop_item   *buy_list;
   buy_request *request_list;
};

#endif
