#ifndef _ROPE_H
#define _ROPE_H

#include "strings.h"
#include "moveable.h"
#include "builder.h"

class Rope : public Moveable
{
public:

   Rope(char *the_name, char *the_area);
   virtual ~Rope();

   virtual void write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   int      set_rope_len(int the_len);
   int      get_rope_len();

   int      copy_rope(Rope *copy_from);
   Rope     *operator = (Rope *copy_from);
   int      read_rope_attrib(FILE *read_file, ErrLog *error_log);
   void     set_tied();
   void     set_untied();
   virtual  int get_mem_size();
   virtual  int get_mem_size_dynamic();
   
   void     set_other_loc(MudObject *new_loc);
   MudObject *get_other_loc();

 private:

   Rope();

   int       length;
   MudObject *other_loc;
};



#endif

