#ifndef EDITOR_H_NEW
#define EDITOR_H_NEW

#include <stdio.h>
#include "config.h"
#include "mudtypes.h"
#include "strings.h"

class Player;
class Builder;
class MudObject;
class Connection;

int editor_command_handler(MudObject *theobject, char *the_input);
int editor_input_handler(MudObject *theobject, char *the_input);

#define EDITOR_ADD_LAST   (-1)
#define EDITOR_ADD_FIRST  (-2)
#define EDITOR_ADD_APPEND (-3)
#define EDITOR_ADD_INSERT (-4)
#define EDITOR_NO_TARGET  (-5)

#define EDITOR_HEADER     "&+B[&+WLoading Editor&+B]&*\n"
#define EDITOR_PROMPT     "&+b:&* "
#define EDITOR_CONNLOST   -1
#define EDITOR_QUIT       0
#define EDITOR_ABORT      1

enum CmdMode  { Edit, Command };		
enum EditMode { Insert, Append, Overwrite };

struct Edit_Line {
	Strings   the_line;
	struct    Edit_Line *next_line;
};

class Editor {
public:
	Editor();
	Editor(char *startstring);
	Editor(FILE *startfile);
	~Editor();

	int start_editor(MudObject *the_user);
   int start_editor(MudObject *the_user, Strings *targetstr);
   int start_editor(MudObject *the_User, Strings *tostr, int rem_newline);

   int start_editor(MudObject *the_user, FILE *fp);
   int stop_editor(bool    aborting);

   int reset_editor();
   int load_string(char *startstring);
   int load_file(FILE *thefile);

   bool    get_linemarker_flag();
   void    set_linemarker_flag(bool    flval);

   void set_cmdmode(CmdMode newmode);
   void set_editmode(EditMode newmode);
   CmdMode get_cmdmode();
   EditMode get_editmode();

   Edit_Line *get_curline();
   void 		 set_curline(Edit_Line *theline);
      
   void goto_line(int linenr);
   void show_help(Connection *the_conn);
   void show_context(Connection *the_conn);
   void print_linemarker(Connection *the_connection);
   int  delete_from_line(Edit_Line *startline, int nroflines);
   int  replace_with(char *thestr, char *withstring, bool    global);
   int write_context();
   int format_context();
   int add_line(int where, Edit_Line *theline);

   int check_for_bad();
   void set_simple_mode();
   bool    is_simple_mode();


private:

   int delete_line(int linenr);
   int delete_line(Edit_Line *the_line);

   int write_context(Strings *tostr);
   int write_context(FILE *tofile);
   Strings *get_context();

   Edit_Line *edit_buffer;
   Edit_Line *cur_line;

   FILE      *targetfile;
   Strings   *targetstr;
   bool      eolmarkers;

   Strings   last_command;
   CmdMode   cur_cmdmode;
   EditMode  cur_editmode;
   bool      linemarker;

   bool      remove_newline;
   bool      simple_mode;
};

#endif

