#ifndef _DOORFLAGS_H_
#define _DOORFLAGS_H_

#define DOORFLAG_ROPETIE       0  // Is a door for ropes
#define DOORFLAG_TIEINSIDE     1  // The rope can be tied to the door inside
#define DOORFLAG_TIEOUTSIDE    2  // The rope can be tied to the door outside
#define DOORFLAG_UNTIEINSIDE   3  // Rope can be untied from the door inside
#define DOORFLAG_UNTIEOUTSIDE  4  // Rope can be untied from the door outside
#define DOORFLAG_SPECIALDOOR   5  // Door that can't be opened by normal 
                                  // means, only via a special
#define DOORFLAG_HIDDENDOOR    6  // Door does not show up on exits or
                                  // look when closed 
#define DOORFLAG_OUTSIDEINVIS  7  // is the outside door invisible?
#define DOORFLAG_HIDEEXITOUT   8  // Outside of door does not show up in exit 
                                  // list when closed
#define DOORFLAG_HIDEEXITIN    9  // Inside of door does not show up in exit 
                                  // list when closed
          

#ifdef DOOR_C

char *doorflagnames[] = {"RopeTie", "TieInside", "TieOutside", "UntieInside",
       "UntieOutside", "SpecialDoor", "HiddenDoor",  "OutsideInvis", "HideExitOut", 
       "HideExitIn", NULL};

#else

extern char *doorflagnames[];
extern int doorflagfrozen[];


#endif
#endif




