#ifndef _ACTION_H
#define _ACTION_H

#include "entity.h"

class Player;
class Builder;
class Flags;

class Action : public Entity {
 public:

   Action();
   virtual ~Action();
   Action(char *action_name);

   int set_actor(char *the_string);
   char *get_actor();

   int set_crowd(char *the_string);
   char *get_crowd();

   int set_target(char *the_string);
   char *get_target();

   int set_sender(char *the_string);
   char *get_sender();

   int set_bystander(char *the_string);
   char *get_bystander();

   int load_action(FILE *the_file, ErrLog *error_log, int is_builder);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   void write_object(FILE *the_file, int is_builder);
   int is_modified();
   void set_modified(int the_num);
   int execute_action(Parse *the_parsed, Player *the_player);

   Flags *get_actflags();
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();


 private:

   int modified;

   Strings actor;
   Strings crowd;

   Strings target;
   Strings sender;
   Strings bystander;

   Flags *act_flags;
};

#endif
