#include <Foundation/Foundation.h>
#include "CalendarManager.h"

@interface CalendarManagerProxy:NSObject
@end

@implementation CalendarManagerProxy

- (id) calendarManagerWithDomainNamed:(NSString *)domainName
			 authenticateWithUserName:(NSString *)userName
							 password:(NSString *)password
{
	if ([CalendarUser currentCalendarUser] == nil)
	{
		return [CalendarManager calendarManagerWithDomainNamed:domainName
									  authenticateWithUserName:userName
													  password:password];
	}
	NSLog(@"reject by %@",[[CalendarUser currentCalendarUser] name]);
	return nil;
}

@end


int main(int argc, char **argv)
{
	NSAutoreleasePool *pool;
	pool = [NSAutoreleasePool new];
	NSConnection *theConnection;
	int i;

	NSMutableArray *domains;

	domains = [NSMutableArray array];

	NSLog(@"Starting Agendum...");

	i = argc - 1;
	while (i)
	{
		NSString *name = [NSString stringWithCString:argv[i]];
		id domain;

		domain = [[CalendarDomain alloc] initWithDomainName:name];

		[domains addObject:AUTORELEASE(domain)];
		i--;
	}

	/* if no domain, create "localhost" */
	if ([[CalendarDomain allCalendarDomainNames] count] == 0)
	{
		[domains addObject:AUTORELEASE([[CalendarDomain alloc] initWithDomainName:@"localhost"])];
	}

	theConnection = [NSConnection defaultConnection];


//	[theConnection setIndependentConversationQueueing:YES];
//	[theConnection enableMultipleThreads];

	[theConnection setRootObject:[CalendarManagerProxy new]];
	if ([theConnection registerName:@"Agendum"]) {
		NSLog(@"Agendum has successfully started.");
		[theConnection runInNewThread];

		[[NSRunLoop currentRunLoop] run];

		exit(0);
	}
	NSLog(@"Thou shalt not register server service.");
	NSLog(@"Another server may be running.");

	exit(1);

}
