@interface Tint : NSView
{
	NSRect rect;
	float radius;
	NSAttributedString *str;
	NSPoint point;
}

- (void) setRect:(NSRect)r;
@end

@implementation Tint

- (void) dealloc
{
	RELEASE(str);
	[super dealloc];
}

- (void) setStr:(id)s
		  point:(NSPoint)p
{
	ASSIGN(str,s);
	point = p;
}

- (void) setRect:(NSRect)r
		  radius:(float)rad
{
	rect = r;
	radius = rad;
}

- (void) drawRect:(NSRect)r
{
	PSnewpath();
	PSmoveto(NSMinX(rect),NSMinY(rect));
	PSrcurveto(
			-radius, 0,
			-radius ,radius,
			-radius, radius);

	PSrlineto(0, NSHeight(rect) - (radius * 2));
	PSrcurveto(
			0,radius,
			radius,radius,
			radius,radius);

	PSrlineto(NSWidth(rect), 0);
	PSrcurveto(
			radius,0,
			radius,-radius,
			radius,-radius);

	PSrlineto(0, -NSHeight(rect) + (radius * 2));
	PSrcurveto(
			0,-radius,
			-radius,-radius,

			-radius,-radius);

	PSclosepath();

	[[NSColor blueColor] set];

	{
		float pat[] = {3,3};
//		PSsetalpha(0.3);
		PSsetlinewidth(1);
		PSsetdash(pat,2,0);
	}

	PSstroke();

	/*
	[[NSColor whiteColor] set];
	NSSize sz = [str size];
	PSsetalpha(0.8);
	PSrectfill(point.x + 2,point.y + 2,sz.width -4 ,sz.height -4);
	*/
	
	[str drawAtPoint:point];

}

- (NSView *)hitTest:(NSPoint)aPoint
{
	return nil;
}

@end
