/*******************************************************************************
 *  PROJECT: Agave
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2006 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/
#ifndef __LOG_STREAM_H
#define __LOG_STREAM_H

#include <iostream>
#include <string>
#include "gcs-color.h"

using std::endl;

// could print out the name of the function if we wanted to, but it takes up a
// lot of screen space...
//#define HERE__      __ASSERT_FUNCTION << gcs::logging::separator << __FILE__ << gcs::logging::separator << __LINE__ << gcs::logging::separator
#define HERE__      __FILE__ << ::gcs::logging::separator << __LINE__ << ::gcs::logging::separator
#define DOMAIN__    gcs::logging::log_stream.domain() << ::gcs::logging::separator
#define LOG_STREAM  gcs::logging::log_stream << DOMAIN__ << HERE__
#define LOG(str)    LOG_STREAM << str << endl;

namespace gcs
{
    extern bool agave_debug;

    namespace logging
    {
        extern const char* separator;
        typedef std::ostream& (*manipulator_t)(std::ostream&);

        class LogStream
        {
            public:
                LogStream();
                LogStream& operator<<(int i);
                LogStream& operator<<(const char* str);
                LogStream& operator<<(const std::string& str);
                LogStream& operator<<(ColorPtr c);
                LogStream& operator<<(manipulator_t manip);
                void set_stream(std::ostream& strm);
                const char* domain() const { return m_domain; }

            private:
                template <class T>
                LogStream& pass_through(T var);

                std::ostream* m_stream;
                const char* m_domain;
        };

        template <class T>
        LogStream& LogStream::pass_through(T var)
        {
            if (m_stream && agave_debug)
                (*m_stream) << var;
            return *this;
        }

        extern LogStream log_stream;

    } // namespace logging

} // namespace gcs


#endif // __LOG_STREAM_H
