/*******************************************************************************
 *  PROJECT: Agave
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2006 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/
#include <iostream>
#include "log-stream.h"

namespace gcs
{
    bool agave_debug = false;

    namespace logging
    {
        const char* separator = "::";

        LogStream::LogStream() :
            m_stream(&std::cout),
            m_domain("AGAVE")
        {
        }

        LogStream& LogStream::operator<<(int i)
        {
            return pass_through(i);
        }

        LogStream& LogStream::operator<< (const char* str)
        {
            return pass_through(str);
        }

        LogStream& LogStream::operator<<(const std::string& str)
        {
            return pass_through(str);
        }

        LogStream& LogStream::operator<<(manipulator_t manip)
        {
            return pass_through(manip);
        }


        void LogStream::set_stream(std::ostream& strm)
        {
            m_stream = &strm;
        }

        LogStream& LogStream::operator<<(ColorPtr c)
        {
            return pass_through(c);
        }

        // global stream variable
        LogStream log_stream;

    } // namespace logging

} // namespace gcs

