# ----------------------------------------------------------------------------
# - afnix-gcc-2                                                              -
# - afnix compiler configuration - gcc 2 configuration                       -
# ----------------------------------------------------------------------------
# - This program is  free software;  you can  redistribute it and/or  modify -
# - it provided that this copyright notice is kept intact.                   -
# -                                                                          -
# - This  program  is  distributed in the hope  that it  will be useful, but -
# - without  any   warranty;  without  even   the   implied    warranty   of -
# - merchantability  or fitness for a particular purpose. In not event shall -
# - the copyright holder be  liable for  any direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.      -
# ----------------------------------------------------------------------------
# - copyright (c) 1999-2011 amaury darsch                                    -
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - compiler and linker section                                              -
# ----------------------------------------------------------------------------

CC              = g++
LD              = gcc
LK		= gcc
AR              = ar
STDCCFLAGS      = -Wall -Werror -MMD -fno-builtin
STACCFLAGS	=
DYNCCFLAGS	= -fPIC
PLTCCFLAGS      =
DEBUGFLAGS      = -g
OPTCCFLAGS      = -O2
PFLCCFLAGS      = -g -pg
COVCCFLAGS      = -g -fprofile-arcs -ftest-coverage
CPPCCFLAGS      = -nostdinc -nostdinc++
CXXCCFLAGS      = 
STDDEFINES      = -D_REENTRANT
DBGDEFINES      = -DDEBUG
OPTDEFINES      =
STDINCLUDE      =
AFXCPPTYPE	= GNU
AFXCPPTYPE	= 2

# ----------------------------------------------------------------------------
# - compiler dependant libraries                                             -
# ----------------------------------------------------------------------------

AFXCPPLIBS	=

# adjust for darwin platform
ifeq ($(PLATNAME),darwin)
$(error "unsupported platorm with gcc 2")
endif

# ----------------------------------------------------------------------------
# - platform dependant linking flags                                         -
# ----------------------------------------------------------------------------

# adjust for linux platform
ifeq ($(PLATNAME),linux)
ARFLAGS		= rc
LDFLAGS		= -shared
ifeq ($(LKMODE),soname)
LDFLAGS	       += -Wl,-soname,$(SOMIN)
endif
endif

# adjust for solaris platform
ifeq ($(PLATNAME),solaris)
ARFLAGS		= rc
LDFLAGS		= -shared
ifeq ($(LKMODE),soname)
LDFLAGS	       += -Wl,-h,$(SOMIN)
endif
ifeq ($(LKTYPE),static)
STACCFLAGS	= -fPIC
endif
endif

# adjust for freebsd platform
ifeq ($(PLATNAME),freebsd)
ARFLAGS		= rc
LDFLAGS		= -shared
ifeq ($(LKMODE),soname)
LDFLAGS	       += -Wl,-soname,$(SOMIN)
endif
endif

# ----------------------------------------------------------------------------
# - platform dependant final executable flags                                -
# ----------------------------------------------------------------------------

LKFLAGS		=

# adjust linker flags for freebsd
ifeq ($(PLATNAME),freebsd)
LKFLAGS      	= -pthread
endif

# ----------------------------------------------------------------------------
# - platform dependant compilation flags                                     -
# ----------------------------------------------------------------------------

# adjust platform flag for static or dynamic
ifeq ($(LKTYPE),dynamic)
PLTCCFLAGS     += $(DYNCCFLAGS)
endif
ifeq ($(LKTYPE),static)
PLTCCFLAGS     += $(STACCFLAGS)
endif

# adjust sparc processor
ifeq ($(PROCNAME)-$(PROCTYPE),sparc-ultra)
PLTCCFLAGS     += -mcpu=ultrasparc -mtune=ultrasparc
endif
