// ---------------------------------------------------------------------------
// - XsmDocument.hpp                                                         -
// - afnix:xml module - xsm document class definition                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_XSMDOCUMENT_HPP
#define  AFNIX_XSMDOCUMENT_HPP

#ifndef  AFNIX_XSOINFO_HPP
#include "XsoInfo.hpp"
#endif

#ifndef  AFNIX_XSMNODE_HPP
#include "XsmNode.hpp"
#endif

namespace afnix {

  /// The XsmDocument class is the document class that maintains a
  /// xsm document along with its associated list of nodes and other useful
  /// information. Generally the class is constructed with a file name or
  /// a name and an input stream that is used for parsing the input data. 
  /// When the input stream has been parsed, the nodes are stored in a vector
  /// which can be access by index.
  /// @author amaury darsch

  class XsmDocument : public Nameable {
  private:
    /// the document name
    String   d_name;
    /// the node tree
    Vector*  p_tree;

  public:
    /// create a default document
    XsmDocument (void);

    /// create an document by name
    /// @param name the document file name
    XsmDocument (const String& name);

    /// create an document by name and stream
    /// @param name the document name
    /// @param is   the input stream to parse
    XsmDocument (const String& name, Input* is);

    /// destroy this document
    ~XsmDocument (void);

    /// @return the class name
    String repr (void) const;

   /// make this document a shared object
    void mksho (void);

    /// @return the document name
    String getname (void) const;

    /// set the document name
    /// @param name the name to set
    void setname (const String& name);

    /// @return the number of nodes
    long length (void) const;

    /// @return a node by index
    XsmNode* getnode (const long index) const;

    /// @return an info object by index
    XsoInfo* getinfo (const long index) const;

    /// @return an info object by index and case flag
    XsoInfo* getinfo (const long index, const bool lwcf) const;

    /// @return an info vector by name
    Vector* getivec (const String& name) const;

    /// @return an info vector by name and case flag
    Vector* getivec (const String& name, const bool lwcf) const;

    /// @return a vector of words
    Vector* getwords (void) const;

  private:
    // make the copy constructor private
    XsmDocument (const XsmDocument& that);
    // make the assignment operator private
    XsmDocument& operator = (const XsmDocument&);

  public:
    /// create an object in a generic way
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;

    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);
  };
}

#endif
