// ---------------------------------------------------------------------------
// - Predwam.hpp                                                             -
// - afnix:wam service - predicates declaration                              -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_PREDWAM_HPP
#define  AFNIX_PREDWAM_HPP

#ifndef  AFNIX_OBJECT_HPP
#include "Object.hpp"
#endif
 
namespace afnix {

  /// this file contains the predicates associated with the afnix
  /// wam application management (wam) service.
  /// @author amaury darsch

  /// the http reply object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_htprp (Runnable* robj, Nameset* nset, Cons* args);

  /// the cookie object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_cookp (Runnable* robj, Nameset* nset, Cons* args);

  /// the session object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_sessp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml root object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_rootp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml html object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_htmlp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml head object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_headp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml body object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_bodyp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml th object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_thp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml td object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_tdp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml tr object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_trp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml col object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_colp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml cgr object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_cgrp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml caption object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_captp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml table element object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_telemp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml table head object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_theadp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml table body object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_tbodyp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml table foot object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_tfootp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml table object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_tablep (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml title object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_titlep (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml meta object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_metap (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml style object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_stylep (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml img object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_imgp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml div object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_divp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml ref object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_refp (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml para object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_parap (Runnable* robj, Nameset* nset, Cons* args);

  /// the xhtml hr object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* wam_hrp (Runnable* robj, Nameset* nset, Cons* args);
}

#endif
