// ---------------------------------------------------------------------------
// - Libwam.cpp                                                              -
// - afnix:wam service - declaration & implementation                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Meta.hpp"
#include "Cookie.hpp"
#include "Libwam.hpp"
#include "Session.hpp"
#include "Predwam.hpp"
#include "XhtmlHr.hpp"
#include "XhtmlTh.hpp"
#include "XhtmlTd.hpp"
#include "XhtmlTr.hpp"
#include "XhtmlCol.hpp"
#include "XhtmlCgr.hpp"
#include "XhtmlImg.hpp"
#include "XhtmlDiv.hpp"
#include "XhtmlRef.hpp"
#include "Function.hpp"
#include "XhtmlMeta.hpp"
#include "XhtmlRoot.hpp"
#include "XhtmlPara.hpp"
#include "HttpReply.hpp"
#include "XhtmlThead.hpp"
#include "XhtmlTbody.hpp"
#include "XhtmlTfoot.hpp"
#include "XhtmlTable.hpp"
#include "XhtmlTitle.hpp"
#include "XhtmlStyle.hpp"
#include "XhtmlCaption.hpp"

namespace afnix {

  // initialize the afnix:wam module

  Object* init_afnix_wam (Interp* interp, Vector* argv) {
    // make sure we are not called from something crazy
    if (interp == nilp) return nilp;

    // create the afnix:wam nameset
    Nameset* aset = interp->mknset ("afnix");
    Nameset* gset = aset->mknset   ("wam");

    // bind all symbols in the afnix:wam nameset
    gset->symcst ("XhtmlHr",         new Meta (XhtmlHr::mknew));
    gset->symcst ("XhtmlTh",         new Meta (XhtmlTh::mknew));
    gset->symcst ("XhtmlTd",         new Meta (XhtmlTd::mknew));
    gset->symcst ("XhtmlTr",         new Meta (XhtmlTr::mknew));
    gset->symcst ("XhtmlCol",        new Meta (XhtmlCol::mknew));
    gset->symcst ("XhtmlCgr",        new Meta (XhtmlCgr::mknew));
    gset->symcst ("XhtmlImg",        new Meta (XhtmlImg::mknew));
    gset->symcst ("XhtmlDiv",        new Meta (XhtmlDiv::mknew));
    gset->symcst ("XhtmlRef",        new Meta (XhtmlRef::mknew));
    gset->symcst ("XhtmlMeta",       new Meta (XhtmlMeta::mknew));
    gset->symcst ("XhtmlRoot",       new Meta (XhtmlRoot::mknew));
    gset->symcst ("XhtmlHtml",       new Meta (XhtmlHtml::mknew));
    gset->symcst ("XhtmlHead",       new Meta (XhtmlHead::mknew));
    gset->symcst ("XhtmlBody",       new Meta (XhtmlBody::mknew));
    gset->symcst ("XhtmlPara",       new Meta (XhtmlPara::mknew));
    gset->symcst ("XhtmlThead",      new Meta (XhtmlThead::mknew));
    gset->symcst ("XhtmlTbody",      new Meta (XhtmlTbody::mknew));
    gset->symcst ("XhtmlTfoot",      new Meta (XhtmlTfoot::mknew));
    gset->symcst ("XhtmlTable",      new Meta (XhtmlTable::mknew));
    gset->symcst ("XhtmlTitle",      new Meta (XhtmlTitle::mknew));
    gset->symcst ("XhtmlStyle",      new Meta (XhtmlStyle::mknew));
    gset->symcst ("XhtmlCaption",    new Meta (XhtmlCaption::mknew));

    gset->symcst ("Cookie",          new Meta (Cookie::mknew));
    gset->symcst ("Session",         new Meta (Session::mknew));
    gset->symcst ("HttpReply",       new Meta (HttpReply::mknew));

    // bind the predicates
    gset->symcst ("xhtml-hr-p",      new Function (wam_hrp));
    gset->symcst ("xhtml-th-p",      new Function (wam_thp));
    gset->symcst ("xhtml-td-p",      new Function (wam_tdp));
    gset->symcst ("xhtml-tr-p",      new Function (wam_trp));
    gset->symcst ("xhtml-col-p",     new Function (wam_colp));
    gset->symcst ("xhtml-cgr-p",     new Function (wam_cgrp));
    gset->symcst ("xhtml-img-p",     new Function (wam_imgp));
    gset->symcst ("xhtml-div-p",     new Function (wam_divp));
    gset->symcst ("xhtml-ref-p",     new Function (wam_refp));
    gset->symcst ("xhtml-root-p",    new Function (wam_rootp));
    gset->symcst ("xhtml-html-p",    new Function (wam_htmlp));
    gset->symcst ("xhtml-head-p",    new Function (wam_headp));
    gset->symcst ("xhtml-body-p",    new Function (wam_bodyp));
    gset->symcst ("xhtml-para-p",    new Function (wam_parap));
    gset->symcst ("xhtml-telem-p",   new Function (wam_telemp));
    gset->symcst ("xhtml-thead-p",   new Function (wam_theadp));
    gset->symcst ("xhtml-tbody-p",   new Function (wam_tbodyp));
    gset->symcst ("xhtml-tfoot-p",   new Function (wam_tfootp));
    gset->symcst ("xhtml-table-p",   new Function (wam_tablep));
    gset->symcst ("xhtml-title-p",   new Function (wam_titlep));
    gset->symcst ("xhtml-caption-p", new Function (wam_captp));

    gset->symcst ("cookie-p",        new Function (wam_cookp));
    gset->symcst ("session-p",       new Function (wam_sessp));
    gset->symcst ("http-reply-p",    new Function (wam_htprp));
    
    // not used but needed
    return nilp;
  }
}

extern "C" {
  afnix::Object* dli_afnix_wam (afnix::Interp* interp, afnix::Vector* argv) {
    return init_afnix_wam (interp, argv);
  }
}
