# ---------------------------------------------------------------------------
# - XML0001.als                                                             -
# - afnix:xml module test unit                                              -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   tag node test unit
# @author amaury darsch

# get the module
interp:library "afnix-xml"

# create a tag node
const  node (afnix:xml:XmlTag "afnix")
assert true (afnix:xml:node-p node)
assert true (afnix:xml:tag-p  node)

# check the name
assert "afnix"(node:get-name)

# set and check the name
const name "hello"
node:set-name name
assert name (node:get-name)

# check the attributes
assert 0 (node:attribute-length)

# add a new attribute
node:add-attribute (Property "afnix" "programming language")
assert 1 (node:attribute-length)

# set a new attribute
node:add-attribute (Property "hello" "world")
assert 2 (node:attribute-length)

# check attribute as a property
const attr (node:get-attribute 1)
assert "hello" (attr:get-name)
assert "world" (attr:get-value)
