// ---------------------------------------------------------------------------
// - XmlStream.hpp                                                           -
// - afnix:xml module - xml input stream class definition                    -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_XMLSTREAM_HPP
#define  AFNIX_XMLSTREAM_HPP

#ifndef  AFNIX_INPUT_HPP
#include "Input.hpp"
#endif

#ifndef  AFNIX_XMLBUFFER_HPP
#include "XmlBuffer.hpp"
#endif

namespace afnix {

  /// The XmlStream class is a simple class that operates with an input
  /// stream and that process special xml inputs such like the character
  /// reference inlining.
  /// @author amaury darsch

  class XmlStream {
  private:
    /// the input stream
    Input* p_is;
    /// the line number
    long   d_lnum;
    /// the xml buffer
    XmlBuffer d_xbuf;

  public:
    /// create a new xml stream by input stream
    /// @param is the input stream to bind
    XmlStream (Input* is);

    /// destroy this xml stream
    ~XmlStream (void);

    /// @return the current line number
    long getlnum (void) const;

    /// set the input steam encoding mode
    /// @param mode the coding mode to set
    void setemod (const String& mode);

    /// @return true if the stream is valid
    bool valid (void) const;

    /// @return the next available unicode character
    t_quad rduc (void);

    /// pushback a unicode character in this stream
    /// @param c the unicode character to pushback
    void pushback (const t_quad c);

  private:
    // make the copy constuctor private
    XmlStream (const XmlStream&);
    // make the assignment operator private
    XmlStream& operator = (const XmlStream&);    
  };
}

#endif
