// ---------------------------------------------------------------------------
// - Predtxt.hpp                                                             -
// - afnix:txt module - predicates declaration                               -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_PREDTXT_HPP
#define  AFNIX_PREDTXT_HPP

#ifndef  AFNIX_OBJECT_HPP
#include "Object.hpp"
#endif
 
namespace afnix {
  
  /// this file contains the predicates associated with the afnix:txt
  /// standard module.
  /// @author amaury darsch

  /// the pattern object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_patp    (Runnable* robj, Nameset* nset, Cons* args);

  /// the lexeme object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_lexp    (Runnable* robj, Nameset* nset, Cons* args);

  /// the lterate object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_tlitp   (Runnable* robj, Nameset* nset, Cons* args);

  /// the scanner object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_scanp   (Runnable* robj, Nameset* nset, Cons* args);

  /// the hasher object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_hashp   (Runnable* robj, Nameset* nset, Cons* args);

  /// the key object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_keyp    (Runnable* robj, Nameset* nset, Cons* args);

  /// the MD5 hasher object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_md5p    (Runnable* robj, Nameset* nset, Cons* args);

  /// the SHA-1 hasher object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_sha1p   (Runnable* robj, Nameset* nset, Cons* args);

  /// the SHA-256 hasher object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_sha256p (Runnable* robj, Nameset* nset, Cons* args);

  /// the SHA-384 hasher object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_sha384p (Runnable* robj, Nameset* nset, Cons* args);

  /// the SHA-512 hasher  object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_sha512p (Runnable* robj, Nameset* nset, Cons* args);

  /// the aes cipher object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_aesp    (Runnable* robj, Nameset* nset, Cons* args);

  /// the cipher object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_cifrp   (Runnable* robj, Nameset* nset, Cons* args);

  /// the input cipher object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_icfrp   (Runnable* robj, Nameset* nset, Cons* args);
}


#endif
