// ---------------------------------------------------------------------------
// - Libtxt.cpp                                                              -
// - afnix:txt module - declaration & implementation                         -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Aes.hpp"
#include "Md5.hpp"
#include "Sha1.hpp"
#include "Meta.hpp"
#include "Sort.hpp"
#include "Sha256.hpp"
#include "Sha384.hpp"
#include "Sha512.hpp"
#include "Libtxt.hpp"
#include "Predtxt.hpp"
#include "Scanner.hpp"
#include "Literate.hpp"
#include "Function.hpp"
#include "InputCipher.hpp"

namespace afnix {

  // initialize the afnix:txt module

  Object* init_afnix_txt (Interp* interp, Vector* argv) {
    // make sure we are not called from something crazy
    if (interp == nilp) return nilp;
    
    // create the afnix:sys nameset
    Nameset* aset = interp->mknset ("afnix");
    Nameset* nset = aset->mknset   ("txt");
    
    // bind all classes in the afnix:txt nameset 
    nset->symcst ("Aes",            new Meta (Aes::mknew));
    nset->symcst ("Md5",            new Meta (Md5::mknew));
    nset->symcst ("Key",            new Meta (Key::meval, Key::mknew));
    nset->symcst ("Sha1",           new Meta (Sha1::mknew));
    nset->symcst ("Sha256",         new Meta (Sha256::mknew));
    nset->symcst ("Sha384",         new Meta (Sha384::mknew));
    nset->symcst ("Sha512",         new Meta (Sha512::mknew));
    nset->symcst ("Lexeme",         new Meta (Lexeme::mknew));
    nset->symcst ("Pattern",        new Meta (Pattern::meval, Pattern::mknew));
    nset->symcst ("Scanner",        new Meta (Scanner::mknew));
    nset->symcst ("Literate",       new Meta (Literate::mknew));
    nset->symcst ("InputCipher",    new Meta (InputCipher::meval,
					      InputCipher::mknew));
   
    // bind the special functions
    nset->symcst ("sort-ascent",    new Function (txt_qsort_lth));
    nset->symcst ("sort-descent",   new Function (txt_qsort_gth));
    nset->symcst ("sort-lexical",   new Function (txt_qsort_lex));

    // bind all predicates in the afnix:txt nameset
    nset->symcst ("aes-p",          new Function (txt_aesp));
    nset->symcst ("key-p",          new Function (txt_keyp));
    nset->symcst ("md5-p",          new Function (txt_md5p));
    nset->symcst ("sha1-p",         new Function (txt_sha1p));
    nset->symcst ("sha256-p",       new Function (txt_sha256p));
    nset->symcst ("sha384-p",       new Function (txt_sha384p));
    nset->symcst ("sha512-p",       new Function (txt_sha512p));
    nset->symcst ("hasher-p",       new Function (txt_hashp));
    nset->symcst ("lexeme-p",       new Function (txt_lexp));
    nset->symcst ("pattern-p",      new Function (txt_patp));
    nset->symcst ("scanner-p",      new Function (txt_scanp));
    nset->symcst ("literate-p",     new Function (txt_tlitp));
    nset->symcst ("cipher-p",       new Function (txt_cifrp));
    nset->symcst ("input-cipher-p", new Function (txt_icfrp));
    
    // not used but needed
    return nilp;
  }
}

extern "C" {
  afnix::Object* dli_afnix_txt (afnix::Interp* interp, afnix::Vector* argv) {
    return init_afnix_txt (interp, argv);
  }
}
