// ---------------------------------------------------------------------------
// - Mime.hpp                                                                -
// - afnix:nwg module - mime base class definition                           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_MIME_HPP
#define  AFNIX_MIME_HPP

#ifndef  AFNIX_OUTPUT_HPP
#include "Output.hpp"
#endif

#ifndef  AFNIX_BUFFER_HPP
#include "Buffer.hpp"
#endif

namespace afnix {

  /// The Mime class is an abstract  class used for the definition of mime
  /// document. The class defines the getmime method that returns the
  /// document mime type.
  /// @author amaury darsch

  class Mime : public virtual Object {
  protected:
    /// the mime value
    String d_mime;

  public:
    /// create a default mime object
    Mime (void);

    /// create a mime object by type
    /// @param type the mime type to set
    Mime (const String& mime);

    /// @return the class name
    String repr (void) const;

    /// @return the document mime type
    virtual String getmime (void) const;

    /// write a document into a buffer
    /// @param buf the buffer to write
    virtual void write (Buffer& buf) const =0;

    /// write a document into an output stream
    /// @param os the output stream to write
    virtual void write (Output& os) const =0;

  private:
    // make the copy constructor private
    Mime (const Mime&);
    // make the assignment operator private
    Mime& operator = (const Mime&);

  public:
    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;
    
    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);
  };
}

#endif
