// ---------------------------------------------------------------------------
// - t_cucd.cpp                                                              -
// - unicode database (ucd) library - ucd tester                             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cucd.hpp"

namespace afnix {

  // this procedure check a plane
  static bool ucd_check_plane (const long index) {
    // get the plane size and data
    const long   psize = c_ucdpsize (index);
    const ucd_s* plane = c_ucdplane (index);
    // compute start and end
    t_quad psi = (((t_quad) index) << 16) & 0xFFFF0000;
    t_quad pei = psi + 0x0000FFFF;
    // check plane
    if ((psize == 0) && (plane != nilp)) return false;
    if ((psize != 0) && (plane == nilp)) return false;
    for (long i = 0; i < psize; i++) {
      if (plane[i].d_code < psi) return false;
      if (plane[i].d_code > pei) return false;
    }
    return true;
  }

  // this procedure check a plane code point
  static bool ucd_check_point (const long index) {
    for (long i = 0; i < 65536; i++) {
      t_quad code = (t_quad) ((index << 16) + i);
      const ucd_s* ucd = c_getucd (code);
      if (ucd == nilp) continue;
      if (ucd->d_code != code) return false;
    }
    return true;
  }
};

int main (int, char**) {
  using namespace afnix;

  // get the planes and check
  for (long i = 0; i < 15; i++) {
    if (ucd_check_plane (i) == false) return 1;
    if (ucd_check_point (i) == false) return 1;
  }

  // done
  return 0;
}
