// ---------------------------------------------------------------------------
// - t_sha1.cpp                                                              -
// - afnix cryptography - sha1 class tester module                           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Sha1.hpp"

int main (int, char**) {
  using namespace afnix;

  // create a SHA-1 message digest
  Sha1 md;
  if (md.getname () != "SHA-1") return 1;

  // check digest as specified in FIPS PUB 180-2
  String digest = md.compute ("abc");
  if (digest != "A9993E364706816ABA3E25717850C26C9CD0D89D") return 1;

  // the afnix test as usual
  digest = md.compute ("afnix");
  if (digest != "FAD1FD98E882B0013DD257DF063BF4A2926EDA17") return 1;
  digest = md.compute ("afnix programming language");
  if (digest != "6DE85A5A09FA93AFBA0513109FABFC1B53B5AD38") return 1;

  // success
  return 0;
}
