// ---------------------------------------------------------------------------
// - P0001.hxx                                                               -
// - unicode database (ucd) library definitions: plane 1                     -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cucd.hpp"

namespace afnix {
  // the plane size
  const long  UCD_PSIZE_0001   = 3419;
  // the plane data
  const ucd_s UCD_PLANE_0001[] = {
    {
      0x00010000,
      "LINEAR B SYLLABLE B008 A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010001,
      "LINEAR B SYLLABLE B038 E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010002,
      "LINEAR B SYLLABLE B028 I",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010003,
      "LINEAR B SYLLABLE B061 O",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010004,
      "LINEAR B SYLLABLE B010 U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010005,
      "LINEAR B SYLLABLE B001 DA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010006,
      "LINEAR B SYLLABLE B045 DE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010007,
      "LINEAR B SYLLABLE B007 DI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010008,
      "LINEAR B SYLLABLE B014 DO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010009,
      "LINEAR B SYLLABLE B051 DU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001000A,
      "LINEAR B SYLLABLE B057 JA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001000B,
      "LINEAR B SYLLABLE B046 JE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001000D,
      "LINEAR B SYLLABLE B036 JO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001000E,
      "LINEAR B SYLLABLE B065 JU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001000F,
      "LINEAR B SYLLABLE B077 KA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010010,
      "LINEAR B SYLLABLE B044 KE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010011,
      "LINEAR B SYLLABLE B067 KI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010012,
      "LINEAR B SYLLABLE B070 KO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010013,
      "LINEAR B SYLLABLE B081 KU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010014,
      "LINEAR B SYLLABLE B080 MA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010015,
      "LINEAR B SYLLABLE B013 ME",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010016,
      "LINEAR B SYLLABLE B073 MI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010017,
      "LINEAR B SYLLABLE B015 MO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010018,
      "LINEAR B SYLLABLE B023 MU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010019,
      "LINEAR B SYLLABLE B006 NA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001001A,
      "LINEAR B SYLLABLE B024 NE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001001B,
      "LINEAR B SYLLABLE B030 NI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001001C,
      "LINEAR B SYLLABLE B052 NO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001001D,
      "LINEAR B SYLLABLE B055 NU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001001E,
      "LINEAR B SYLLABLE B003 PA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001001F,
      "LINEAR B SYLLABLE B072 PE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010020,
      "LINEAR B SYLLABLE B039 PI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010021,
      "LINEAR B SYLLABLE B011 PO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010022,
      "LINEAR B SYLLABLE B050 PU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010023,
      "LINEAR B SYLLABLE B016 QA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010024,
      "LINEAR B SYLLABLE B078 QE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010025,
      "LINEAR B SYLLABLE B021 QI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010026,
      "LINEAR B SYLLABLE B032 QO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010028,
      "LINEAR B SYLLABLE B060 RA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010029,
      "LINEAR B SYLLABLE B027 RE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001002A,
      "LINEAR B SYLLABLE B053 RI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001002B,
      "LINEAR B SYLLABLE B002 RO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001002C,
      "LINEAR B SYLLABLE B026 RU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001002D,
      "LINEAR B SYLLABLE B031 SA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001002E,
      "LINEAR B SYLLABLE B009 SE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001002F,
      "LINEAR B SYLLABLE B041 SI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010030,
      "LINEAR B SYLLABLE B012 SO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010031,
      "LINEAR B SYLLABLE B058 SU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010032,
      "LINEAR B SYLLABLE B059 TA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010033,
      "LINEAR B SYLLABLE B004 TE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010034,
      "LINEAR B SYLLABLE B037 TI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010035,
      "LINEAR B SYLLABLE B005 TO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010036,
      "LINEAR B SYLLABLE B069 TU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010037,
      "LINEAR B SYLLABLE B054 WA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010038,
      "LINEAR B SYLLABLE B075 WE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010039,
      "LINEAR B SYLLABLE B040 WI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001003A,
      "LINEAR B SYLLABLE B042 WO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001003C,
      "LINEAR B SYLLABLE B017 ZA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001003D,
      "LINEAR B SYLLABLE B074 ZE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001003F,
      "LINEAR B SYLLABLE B020 ZO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010040,
      "LINEAR B SYLLABLE B025 A2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010041,
      "LINEAR B SYLLABLE B043 A3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010042,
      "LINEAR B SYLLABLE B085 AU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010043,
      "LINEAR B SYLLABLE B071 DWE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010044,
      "LINEAR B SYLLABLE B090 DWO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010045,
      "LINEAR B SYLLABLE B048 NWA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010046,
      "LINEAR B SYLLABLE B029 PU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010047,
      "LINEAR B SYLLABLE B062 PTE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010048,
      "LINEAR B SYLLABLE B076 RA2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010049,
      "LINEAR B SYLLABLE B033 RA3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001004A,
      "LINEAR B SYLLABLE B068 RO2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001004B,
      "LINEAR B SYLLABLE B066 TA2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001004C,
      "LINEAR B SYLLABLE B087 TWE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001004D,
      "LINEAR B SYLLABLE B091 TWO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010050,
      "LINEAR B SYMBOL B018",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010051,
      "LINEAR B SYMBOL B019",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010052,
      "LINEAR B SYMBOL B022",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010053,
      "LINEAR B SYMBOL B034",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010054,
      "LINEAR B SYMBOL B047",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010055,
      "LINEAR B SYMBOL B049",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010056,
      "LINEAR B SYMBOL B056",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010057,
      "LINEAR B SYMBOL B063",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010058,
      "LINEAR B SYMBOL B064",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010059,
      "LINEAR B SYMBOL B079",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001005A,
      "LINEAR B SYMBOL B082",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001005B,
      "LINEAR B SYMBOL B083",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001005C,
      "LINEAR B SYMBOL B086",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001005D,
      "LINEAR B SYMBOL B089",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010080,
      "LINEAR B IDEOGRAM B100 MAN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010081,
      "LINEAR B IDEOGRAM B102 WOMAN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010082,
      "LINEAR B IDEOGRAM B104 DEER",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010083,
      "LINEAR B IDEOGRAM B105 EQUID",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010084,
      "LINEAR B IDEOGRAM B105F MARE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010085,
      "LINEAR B IDEOGRAM B105M STALLION",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010086,
      "LINEAR B IDEOGRAM B106F EWE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010087,
      "LINEAR B IDEOGRAM B106M RAM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010088,
      "LINEAR B IDEOGRAM B107F SHE-GOAT",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010089,
      "LINEAR B IDEOGRAM B107M HE-GOAT",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001008A,
      "LINEAR B IDEOGRAM B108F SOW",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001008B,
      "LINEAR B IDEOGRAM B108M BOAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001008C,
      "LINEAR B IDEOGRAM B109F COW",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001008D,
      "LINEAR B IDEOGRAM B109M BULL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001008E,
      "LINEAR B IDEOGRAM B120 WHEAT",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001008F,
      "LINEAR B IDEOGRAM B121 BARLEY",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010090,
      "LINEAR B IDEOGRAM B122 OLIVE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010091,
      "LINEAR B IDEOGRAM B123 SPICE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010092,
      "LINEAR B IDEOGRAM B125 CYPERUS",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010093,
      "LINEAR B MONOGRAM B127 KAPO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010094,
      "LINEAR B MONOGRAM B128 KANAKO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010095,
      "LINEAR B IDEOGRAM B130 OIL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010096,
      "LINEAR B IDEOGRAM B131 WINE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010097,
      "LINEAR B IDEOGRAM B132",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010098,
      "LINEAR B MONOGRAM B133 AREPA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010099,
      "LINEAR B MONOGRAM B135 MERI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001009A,
      "LINEAR B IDEOGRAM B140 BRONZE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001009B,
      "LINEAR B IDEOGRAM B141 GOLD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001009C,
      "LINEAR B IDEOGRAM B142",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001009D,
      "LINEAR B IDEOGRAM B145 WOOL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001009E,
      "LINEAR B IDEOGRAM B146",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001009F,
      "LINEAR B IDEOGRAM B150",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100A0,
      "LINEAR B IDEOGRAM B151 HORN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100A1,
      "LINEAR B IDEOGRAM B152",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100A2,
      "LINEAR B IDEOGRAM B153",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100A3,
      "LINEAR B IDEOGRAM B154",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100A4,
      "LINEAR B MONOGRAM B156 TURO2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100A5,
      "LINEAR B IDEOGRAM B157",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100A6,
      "LINEAR B IDEOGRAM B158",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100A7,
      "LINEAR B IDEOGRAM B159 CLOTH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100A8,
      "LINEAR B IDEOGRAM B160",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100A9,
      "LINEAR B IDEOGRAM B161",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100AA,
      "LINEAR B IDEOGRAM B162 GARMENT",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100AB,
      "LINEAR B IDEOGRAM B163 ARMOUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100AC,
      "LINEAR B IDEOGRAM B164",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100AD,
      "LINEAR B IDEOGRAM B165",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100AE,
      "LINEAR B IDEOGRAM B166",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100AF,
      "LINEAR B IDEOGRAM B167",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100B0,
      "LINEAR B IDEOGRAM B168",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100B1,
      "LINEAR B IDEOGRAM B169",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100B2,
      "LINEAR B IDEOGRAM B170",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100B3,
      "LINEAR B IDEOGRAM B171",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100B4,
      "LINEAR B IDEOGRAM B172",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100B5,
      "LINEAR B IDEOGRAM B173 MONTH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100B6,
      "LINEAR B IDEOGRAM B174",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100B7,
      "LINEAR B IDEOGRAM B176 TREE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100B8,
      "LINEAR B IDEOGRAM B177",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100B9,
      "LINEAR B IDEOGRAM B178",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100BA,
      "LINEAR B IDEOGRAM B179",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100BB,
      "LINEAR B IDEOGRAM B180",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100BC,
      "LINEAR B IDEOGRAM B181",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100BD,
      "LINEAR B IDEOGRAM B182",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100BE,
      "LINEAR B IDEOGRAM B183",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100BF,
      "LINEAR B IDEOGRAM B184",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100C0,
      "LINEAR B IDEOGRAM B185",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100C1,
      "LINEAR B IDEOGRAM B189",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100C2,
      "LINEAR B IDEOGRAM B190",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100C3,
      "LINEAR B IDEOGRAM B191 HELMET",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100C4,
      "LINEAR B IDEOGRAM B220 FOOTSTOOL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100C5,
      "LINEAR B IDEOGRAM B225 BATHTUB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100C6,
      "LINEAR B IDEOGRAM B230 SPEAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100C7,
      "LINEAR B IDEOGRAM B231 ARROW",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100C8,
      "LINEAR B IDEOGRAM B232",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100C9,
      "LINEAR B IDEOGRAM B233 SWORD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100CA,
      "LINEAR B IDEOGRAM B234",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100CB,
      "LINEAR B IDEOGRAM B236",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100CC,
      "LINEAR B IDEOGRAM B240 WHEELED CHARIOT",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100CD,
      "LINEAR B IDEOGRAM B241 CHARIOT",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100CE,
      "LINEAR B IDEOGRAM B242 CHARIOT FRAME",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100CF,
      "LINEAR B IDEOGRAM B243 WHEEL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100D0,
      "LINEAR B IDEOGRAM B245",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100D1,
      "LINEAR B IDEOGRAM B246",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100D2,
      "LINEAR B MONOGRAM B247 DIPTE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100D3,
      "LINEAR B IDEOGRAM B248",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100D4,
      "LINEAR B IDEOGRAM B249",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100D5,
      "LINEAR B IDEOGRAM B251",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100D6,
      "LINEAR B IDEOGRAM B252",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100D7,
      "LINEAR B IDEOGRAM B253",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100D8,
      "LINEAR B IDEOGRAM B254 DART",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100D9,
      "LINEAR B IDEOGRAM B255",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100DA,
      "LINEAR B IDEOGRAM B256",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100DB,
      "LINEAR B IDEOGRAM B257",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100DC,
      "LINEAR B IDEOGRAM B258",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100DD,
      "LINEAR B IDEOGRAM B259",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100DE,
      "LINEAR B IDEOGRAM VESSEL B155",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100DF,
      "LINEAR B IDEOGRAM VESSEL B200",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100E0,
      "LINEAR B IDEOGRAM VESSEL B201",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100E1,
      "LINEAR B IDEOGRAM VESSEL B202",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100E2,
      "LINEAR B IDEOGRAM VESSEL B203",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100E3,
      "LINEAR B IDEOGRAM VESSEL B204",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100E4,
      "LINEAR B IDEOGRAM VESSEL B205",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100E5,
      "LINEAR B IDEOGRAM VESSEL B206",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100E6,
      "LINEAR B IDEOGRAM VESSEL B207",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100E7,
      "LINEAR B IDEOGRAM VESSEL B208",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100E8,
      "LINEAR B IDEOGRAM VESSEL B209",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100E9,
      "LINEAR B IDEOGRAM VESSEL B210",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100EA,
      "LINEAR B IDEOGRAM VESSEL B211",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100EB,
      "LINEAR B IDEOGRAM VESSEL B212",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100EC,
      "LINEAR B IDEOGRAM VESSEL B213",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100ED,
      "LINEAR B IDEOGRAM VESSEL B214",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100EE,
      "LINEAR B IDEOGRAM VESSEL B215",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100EF,
      "LINEAR B IDEOGRAM VESSEL B216",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100F0,
      "LINEAR B IDEOGRAM VESSEL B217",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100F1,
      "LINEAR B IDEOGRAM VESSEL B218",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100F2,
      "LINEAR B IDEOGRAM VESSEL B219",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100F3,
      "LINEAR B IDEOGRAM VESSEL B221",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100F4,
      "LINEAR B IDEOGRAM VESSEL B222",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100F5,
      "LINEAR B IDEOGRAM VESSEL B226",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100F6,
      "LINEAR B IDEOGRAM VESSEL B227",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100F7,
      "LINEAR B IDEOGRAM VESSEL B228",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100F8,
      "LINEAR B IDEOGRAM VESSEL B229",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100F9,
      "LINEAR B IDEOGRAM VESSEL B250",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000100FA,
      "LINEAR B IDEOGRAM VESSEL B305",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010100,
      "AEGEAN WORD SEPARATOR LINE",
      0x36, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010101,
      "AEGEAN WORD SEPARATOR DOT",
      0x36, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010102,
      "AEGEAN CHECK MARK",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010107,
      "AEGEAN NUMBER ONE",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010108,
      "AEGEAN NUMBER TWO",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010109,
      "AEGEAN NUMBER THREE",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001010A,
      "AEGEAN NUMBER FOUR",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001010B,
      "AEGEAN NUMBER FIVE",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001010C,
      "AEGEAN NUMBER SIX",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001010D,
      "AEGEAN NUMBER SEVEN",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001010E,
      "AEGEAN NUMBER EIGHT",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001010F,
      "AEGEAN NUMBER NINE",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010110,
      "AEGEAN NUMBER TEN",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010111,
      "AEGEAN NUMBER TWENTY",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010112,
      "AEGEAN NUMBER THIRTY",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010113,
      "AEGEAN NUMBER FORTY",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010114,
      "AEGEAN NUMBER FIFTY",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010115,
      "AEGEAN NUMBER SIXTY",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010116,
      "AEGEAN NUMBER SEVENTY",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010117,
      "AEGEAN NUMBER EIGHTY",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010118,
      "AEGEAN NUMBER NINETY",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010119,
      "AEGEAN NUMBER ONE HUNDRED",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001011A,
      "AEGEAN NUMBER TWO HUNDRED",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001011B,
      "AEGEAN NUMBER THREE HUNDRED",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001011C,
      "AEGEAN NUMBER FOUR HUNDRED",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001011D,
      "AEGEAN NUMBER FIVE HUNDRED",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001011E,
      "AEGEAN NUMBER SIX HUNDRED",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001011F,
      "AEGEAN NUMBER SEVEN HUNDRED",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010120,
      "AEGEAN NUMBER EIGHT HUNDRED",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010121,
      "AEGEAN NUMBER NINE HUNDRED",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010122,
      "AEGEAN NUMBER ONE THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010123,
      "AEGEAN NUMBER TWO THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010124,
      "AEGEAN NUMBER THREE THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010125,
      "AEGEAN NUMBER FOUR THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010126,
      "AEGEAN NUMBER FIVE THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010127,
      "AEGEAN NUMBER SIX THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010128,
      "AEGEAN NUMBER SEVEN THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010129,
      "AEGEAN NUMBER EIGHT THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001012A,
      "AEGEAN NUMBER NINE THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001012B,
      "AEGEAN NUMBER TEN THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001012C,
      "AEGEAN NUMBER TWENTY THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001012D,
      "AEGEAN NUMBER THIRTY THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001012E,
      "AEGEAN NUMBER FORTY THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001012F,
      "AEGEAN NUMBER FIFTY THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010130,
      "AEGEAN NUMBER SIXTY THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010131,
      "AEGEAN NUMBER SEVENTY THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010132,
      "AEGEAN NUMBER EIGHTY THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010133,
      "AEGEAN NUMBER NINETY THOUSAND",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010137,
      "AEGEAN WEIGHT BASE UNIT",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010138,
      "AEGEAN WEIGHT FIRST SUBUNIT",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010139,
      "AEGEAN WEIGHT SECOND SUBUNIT",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001013A,
      "AEGEAN WEIGHT THIRD SUBUNIT",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001013B,
      "AEGEAN WEIGHT FOURTH SUBUNIT",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001013C,
      "AEGEAN DRY MEASURE FIRST SUBUNIT",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001013D,
      "AEGEAN LIQUID MEASURE FIRST SUBUNIT",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001013E,
      "AEGEAN MEASURE SECOND SUBUNIT",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001013F,
      "AEGEAN MEASURE THIRD SUBUNIT",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010140,
      "GREEK ACROPHONIC ATTIC ONE QUARTER",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010141,
      "GREEK ACROPHONIC ATTIC ONE HALF",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010142,
      "GREEK ACROPHONIC ATTIC ONE DRACHMA",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010143,
      "GREEK ACROPHONIC ATTIC FIVE",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010144,
      "GREEK ACROPHONIC ATTIC FIFTY",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010145,
      "GREEK ACROPHONIC ATTIC FIVE HUNDRED",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010146,
      "GREEK ACROPHONIC ATTIC FIVE THOUSAND",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010147,
      "GREEK ACROPHONIC ATTIC FIFTY THOUSAND",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010148,
      "GREEK ACROPHONIC ATTIC FIVE TALENTS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010149,
      "GREEK ACROPHONIC ATTIC TEN TALENTS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001014A,
      "GREEK ACROPHONIC ATTIC FIFTY TALENTS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001014B,
      "GREEK ACROPHONIC ATTIC ONE HUNDRED TALENTS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001014C,
      "GREEK ACROPHONIC ATTIC FIVE HUNDRED TALENTS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001014D,
      "GREEK ACROPHONIC ATTIC ONE THOUSAND TALENTS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001014E,
      "GREEK ACROPHONIC ATTIC FIVE THOUSAND TALENTS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001014F,
      "GREEK ACROPHONIC ATTIC FIVE STATERS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010150,
      "GREEK ACROPHONIC ATTIC TEN STATERS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010151,
      "GREEK ACROPHONIC ATTIC FIFTY STATERS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010152,
      "GREEK ACROPHONIC ATTIC ONE HUNDRED STATERS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010153,
      "GREEK ACROPHONIC ATTIC FIVE HUNDRED STATERS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010154,
      "GREEK ACROPHONIC ATTIC ONE THOUSAND STATERS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010155,
      "GREEK ACROPHONIC ATTIC TEN THOUSAND STATERS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010156,
      "GREEK ACROPHONIC ATTIC FIFTY THOUSAND STATERS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010157,
      "GREEK ACROPHONIC ATTIC TEN MNAS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010158,
      "GREEK ACROPHONIC HERAEUM ONE PLETHRON",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010159,
      "GREEK ACROPHONIC THESPIAN ONE",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001015A,
      "GREEK ACROPHONIC HERMIONIAN ONE",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001015B,
      "GREEK ACROPHONIC EPIDAUREAN TWO",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001015C,
      "GREEK ACROPHONIC THESPIAN TWO",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001015D,
      "GREEK ACROPHONIC CYRENAIC TWO DRACHMAS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001015E,
      "GREEK ACROPHONIC EPIDAUREAN TWO DRACHMAS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001015F,
      "GREEK ACROPHONIC TROEZENIAN FIVE",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010160,
      "GREEK ACROPHONIC TROEZENIAN TEN",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010161,
      "GREEK ACROPHONIC TROEZENIAN TEN ALTERNATE FORM",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010162,
      "GREEK ACROPHONIC HERMIONIAN TEN",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010163,
      "GREEK ACROPHONIC MESSENIAN TEN",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010164,
      "GREEK ACROPHONIC THESPIAN TEN",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010165,
      "GREEK ACROPHONIC THESPIAN THIRTY",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010166,
      "GREEK ACROPHONIC TROEZENIAN FIFTY",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010167,
      "GREEK ACROPHONIC TROEZENIAN FIFTY ALTERNATE FORM",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010168,
      "GREEK ACROPHONIC HERMIONIAN FIFTY",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010169,
      "GREEK ACROPHONIC THESPIAN FIFTY",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001016A,
      "GREEK ACROPHONIC THESPIAN ONE HUNDRED",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001016B,
      "GREEK ACROPHONIC THESPIAN THREE HUNDRED",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001016C,
      "GREEK ACROPHONIC EPIDAUREAN FIVE HUNDRED",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001016D,
      "GREEK ACROPHONIC TROEZENIAN FIVE HUNDRED",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001016E,
      "GREEK ACROPHONIC THESPIAN FIVE HUNDRED",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001016F,
      "GREEK ACROPHONIC CARYSTIAN FIVE HUNDRED",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010170,
      "GREEK ACROPHONIC NAXIAN FIVE HUNDRED",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010171,
      "GREEK ACROPHONIC THESPIAN ONE THOUSAND",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010172,
      "GREEK ACROPHONIC THESPIAN FIVE THOUSAND",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010173,
      "GREEK ACROPHONIC DELPHIC FIVE MNAS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010174,
      "GREEK ACROPHONIC STRATIAN FIFTY MNAS",
      0x21, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010175,
      "GREEK ONE HALF SIGN",
      0x22, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010176,
      "GREEK ONE HALF SIGN ALTERNATE FORM",
      0x22, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010177,
      "GREEK TWO THIRDS SIGN",
      0x22, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010178,
      "GREEK THREE QUARTERS SIGN",
      0x22, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010179,
      "GREEK YEAR SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001017A,
      "GREEK TALENT SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001017B,
      "GREEK DRACHMA SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001017C,
      "GREEK OBOL SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001017D,
      "GREEK TWO OBOLS SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001017E,
      "GREEK THREE OBOLS SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001017F,
      "GREEK FOUR OBOLS SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010180,
      "GREEK FIVE OBOLS SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010181,
      "GREEK METRETES SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010182,
      "GREEK KYATHOS BASE SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010183,
      "GREEK LITRA SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010184,
      "GREEK OUNKIA SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010185,
      "GREEK XESTES SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010186,
      "GREEK ARTABE SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010187,
      "GREEK AROURA SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010188,
      "GREEK GRAMMA SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010189,
      "GREEK TRYBLION BASE SIGN",
      0x43, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001018A,
      "GREEK ZERO SIGN",
      0x22, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010300,
      "OLD ITALIC LETTER A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010301,
      "OLD ITALIC LETTER BE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010302,
      "OLD ITALIC LETTER KE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010303,
      "OLD ITALIC LETTER DE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010304,
      "OLD ITALIC LETTER E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010305,
      "OLD ITALIC LETTER VE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010306,
      "OLD ITALIC LETTER ZE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010307,
      "OLD ITALIC LETTER HE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010308,
      "OLD ITALIC LETTER THE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010309,
      "OLD ITALIC LETTER I",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001030A,
      "OLD ITALIC LETTER KA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001030B,
      "OLD ITALIC LETTER EL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001030C,
      "OLD ITALIC LETTER EM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001030D,
      "OLD ITALIC LETTER EN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001030E,
      "OLD ITALIC LETTER ESH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001030F,
      "OLD ITALIC LETTER O",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010310,
      "OLD ITALIC LETTER PE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010311,
      "OLD ITALIC LETTER SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010312,
      "OLD ITALIC LETTER KU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010313,
      "OLD ITALIC LETTER ER",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010314,
      "OLD ITALIC LETTER ES",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010315,
      "OLD ITALIC LETTER TE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010316,
      "OLD ITALIC LETTER U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010317,
      "OLD ITALIC LETTER EKS",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010318,
      "OLD ITALIC LETTER PHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010319,
      "OLD ITALIC LETTER KHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001031A,
      "OLD ITALIC LETTER EF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001031B,
      "OLD ITALIC LETTER ERS",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001031C,
      "OLD ITALIC LETTER CHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001031D,
      "OLD ITALIC LETTER II",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001031E,
      "OLD ITALIC LETTER UU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010320,
      "OLD ITALIC NUMERAL ONE",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010321,
      "OLD ITALIC NUMERAL FIVE",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010322,
      "OLD ITALIC NUMERAL TEN",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010323,
      "OLD ITALIC NUMERAL FIFTY",
      0x22, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010330,
      "GOTHIC LETTER AHSA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010331,
      "GOTHIC LETTER BAIRKAN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010332,
      "GOTHIC LETTER GIBA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010333,
      "GOTHIC LETTER DAGS",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010334,
      "GOTHIC LETTER AIHVUS",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010335,
      "GOTHIC LETTER QAIRTHRA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010336,
      "GOTHIC LETTER IUJA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010337,
      "GOTHIC LETTER HAGL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010338,
      "GOTHIC LETTER THIUTH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010339,
      "GOTHIC LETTER EIS",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001033A,
      "GOTHIC LETTER KUSMA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001033B,
      "GOTHIC LETTER LAGUS",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001033C,
      "GOTHIC LETTER MANNA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001033D,
      "GOTHIC LETTER NAUTHS",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001033E,
      "GOTHIC LETTER JER",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001033F,
      "GOTHIC LETTER URUS",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010340,
      "GOTHIC LETTER PAIRTHRA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010341,
      "GOTHIC LETTER NINETY",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010342,
      "GOTHIC LETTER RAIDA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010343,
      "GOTHIC LETTER SAUIL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010344,
      "GOTHIC LETTER TEIWS",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010345,
      "GOTHIC LETTER WINJA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010346,
      "GOTHIC LETTER FAIHU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010347,
      "GOTHIC LETTER IGGWS",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010348,
      "GOTHIC LETTER HWAIR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010349,
      "GOTHIC LETTER OTHAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001034A,
      "GOTHIC LETTER NINE HUNDRED",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010380,
      "UGARITIC LETTER ALPA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010381,
      "UGARITIC LETTER BETA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010382,
      "UGARITIC LETTER GAMLA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010383,
      "UGARITIC LETTER KHA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010384,
      "UGARITIC LETTER DELTA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010385,
      "UGARITIC LETTER HO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010386,
      "UGARITIC LETTER WO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010387,
      "UGARITIC LETTER ZETA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010388,
      "UGARITIC LETTER HOTA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010389,
      "UGARITIC LETTER TET",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001038A,
      "UGARITIC LETTER YOD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001038B,
      "UGARITIC LETTER KAF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001038C,
      "UGARITIC LETTER SHIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001038D,
      "UGARITIC LETTER LAMDA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001038E,
      "UGARITIC LETTER MEM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001038F,
      "UGARITIC LETTER DHAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010390,
      "UGARITIC LETTER NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010391,
      "UGARITIC LETTER ZU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010392,
      "UGARITIC LETTER SAMKA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010393,
      "UGARITIC LETTER AIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010394,
      "UGARITIC LETTER PU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010395,
      "UGARITIC LETTER SADE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010396,
      "UGARITIC LETTER QOPA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010397,
      "UGARITIC LETTER RASHA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010398,
      "UGARITIC LETTER THANNA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010399,
      "UGARITIC LETTER GHAIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001039A,
      "UGARITIC LETTER TO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001039B,
      "UGARITIC LETTER I",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001039C,
      "UGARITIC LETTER U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001039D,
      "UGARITIC LETTER SSU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001039F,
      "UGARITIC WORD DIVIDER",
      0x36, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103A0,
      "OLD PERSIAN SIGN A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103A1,
      "OLD PERSIAN SIGN I",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103A2,
      "OLD PERSIAN SIGN U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103A3,
      "OLD PERSIAN SIGN KA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103A4,
      "OLD PERSIAN SIGN KU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103A5,
      "OLD PERSIAN SIGN GA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103A6,
      "OLD PERSIAN SIGN GU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103A7,
      "OLD PERSIAN SIGN XA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103A8,
      "OLD PERSIAN SIGN CA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103A9,
      "OLD PERSIAN SIGN JA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103AA,
      "OLD PERSIAN SIGN JI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103AB,
      "OLD PERSIAN SIGN TA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103AC,
      "OLD PERSIAN SIGN TU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103AD,
      "OLD PERSIAN SIGN DA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103AE,
      "OLD PERSIAN SIGN DI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103AF,
      "OLD PERSIAN SIGN DU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103B0,
      "OLD PERSIAN SIGN THA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103B1,
      "OLD PERSIAN SIGN PA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103B2,
      "OLD PERSIAN SIGN BA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103B3,
      "OLD PERSIAN SIGN FA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103B4,
      "OLD PERSIAN SIGN NA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103B5,
      "OLD PERSIAN SIGN NU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103B6,
      "OLD PERSIAN SIGN MA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103B7,
      "OLD PERSIAN SIGN MI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103B8,
      "OLD PERSIAN SIGN MU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103B9,
      "OLD PERSIAN SIGN YA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103BA,
      "OLD PERSIAN SIGN VA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103BB,
      "OLD PERSIAN SIGN VI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103BC,
      "OLD PERSIAN SIGN RA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103BD,
      "OLD PERSIAN SIGN RU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103BE,
      "OLD PERSIAN SIGN LA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103BF,
      "OLD PERSIAN SIGN SA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103C0,
      "OLD PERSIAN SIGN ZA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103C1,
      "OLD PERSIAN SIGN SHA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103C2,
      "OLD PERSIAN SIGN SSA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103C3,
      "OLD PERSIAN SIGN HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103C8,
      "OLD PERSIAN SIGN AURAMAZDAA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103C9,
      "OLD PERSIAN SIGN AURAMAZDAA-2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103CA,
      "OLD PERSIAN SIGN AURAMAZDAAHA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103CB,
      "OLD PERSIAN SIGN XSHAAYATHIYA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103CC,
      "OLD PERSIAN SIGN DAHYAAUSH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103CD,
      "OLD PERSIAN SIGN DAHYAAUSH-2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103CE,
      "OLD PERSIAN SIGN BAGA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103CF,
      "OLD PERSIAN SIGN BUUMISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103D0,
      "OLD PERSIAN WORD DIVIDER",
      0x36, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103D1,
      "OLD PERSIAN NUMBER ONE",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103D2,
      "OLD PERSIAN NUMBER TWO",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103D3,
      "OLD PERSIAN NUMBER TEN",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103D4,
      "OLD PERSIAN NUMBER TWENTY",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000103D5,
      "OLD PERSIAN NUMBER HUNDRED",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010400,
      "DESERET CAPITAL LETTER LONG I",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010428, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010401,
      "DESERET CAPITAL LETTER LONG E",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010429, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010402,
      "DESERET CAPITAL LETTER LONG A",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001042A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010403,
      "DESERET CAPITAL LETTER LONG AH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001042B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010404,
      "DESERET CAPITAL LETTER LONG O",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001042C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010405,
      "DESERET CAPITAL LETTER LONG OO",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001042D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010406,
      "DESERET CAPITAL LETTER SHORT I",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001042E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010407,
      "DESERET CAPITAL LETTER SHORT E",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001042F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010408,
      "DESERET CAPITAL LETTER SHORT A",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010430, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010409,
      "DESERET CAPITAL LETTER SHORT AH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010431, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001040A,
      "DESERET CAPITAL LETTER SHORT O",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010432, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001040B,
      "DESERET CAPITAL LETTER SHORT OO",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010433, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001040C,
      "DESERET CAPITAL LETTER AY",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010434, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001040D,
      "DESERET CAPITAL LETTER OW",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010435, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001040E,
      "DESERET CAPITAL LETTER WU",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010436, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001040F,
      "DESERET CAPITAL LETTER YEE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010437, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010410,
      "DESERET CAPITAL LETTER H",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010438, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010411,
      "DESERET CAPITAL LETTER PEE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010439, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010412,
      "DESERET CAPITAL LETTER BEE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001043A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010413,
      "DESERET CAPITAL LETTER TEE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001043B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010414,
      "DESERET CAPITAL LETTER DEE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001043C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010415,
      "DESERET CAPITAL LETTER CHEE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001043D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010416,
      "DESERET CAPITAL LETTER JEE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001043E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010417,
      "DESERET CAPITAL LETTER KAY",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001043F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010418,
      "DESERET CAPITAL LETTER GAY",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010440, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010419,
      "DESERET CAPITAL LETTER EF",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010441, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001041A,
      "DESERET CAPITAL LETTER VEE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010442, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001041B,
      "DESERET CAPITAL LETTER ETH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010443, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001041C,
      "DESERET CAPITAL LETTER THEE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010444, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001041D,
      "DESERET CAPITAL LETTER ES",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010445, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001041E,
      "DESERET CAPITAL LETTER ZEE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010446, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001041F,
      "DESERET CAPITAL LETTER ESH",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010447, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010420,
      "DESERET CAPITAL LETTER ZHEE",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010448, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010421,
      "DESERET CAPITAL LETTER ER",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010449, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010422,
      "DESERET CAPITAL LETTER EL",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001044A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010423,
      "DESERET CAPITAL LETTER EM",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001044B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010424,
      "DESERET CAPITAL LETTER EN",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001044C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010425,
      "DESERET CAPITAL LETTER ENG",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001044D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010426,
      "DESERET CAPITAL LETTER OI",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001044E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010427,
      "DESERET CAPITAL LETTER EW",
      0x00, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001044F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010428,
      "DESERET SMALL LETTER LONG I",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010400, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010400, 0x00000000, 0x00000000}
    },
    {
      0x00010429,
      "DESERET SMALL LETTER LONG E",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010401, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010401, 0x00000000, 0x00000000}
    },
    {
      0x0001042A,
      "DESERET SMALL LETTER LONG A",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010402, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010402, 0x00000000, 0x00000000}
    },
    {
      0x0001042B,
      "DESERET SMALL LETTER LONG AH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010403, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010403, 0x00000000, 0x00000000}
    },
    {
      0x0001042C,
      "DESERET SMALL LETTER LONG O",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010404, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010404, 0x00000000, 0x00000000}
    },
    {
      0x0001042D,
      "DESERET SMALL LETTER LONG OO",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010405, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010405, 0x00000000, 0x00000000}
    },
    {
      0x0001042E,
      "DESERET SMALL LETTER SHORT I",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010406, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010406, 0x00000000, 0x00000000}
    },
    {
      0x0001042F,
      "DESERET SMALL LETTER SHORT E",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010407, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010407, 0x00000000, 0x00000000}
    },
    {
      0x00010430,
      "DESERET SMALL LETTER SHORT A",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010408, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010408, 0x00000000, 0x00000000}
    },
    {
      0x00010431,
      "DESERET SMALL LETTER SHORT AH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010409, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010409, 0x00000000, 0x00000000}
    },
    {
      0x00010432,
      "DESERET SMALL LETTER SHORT O",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0001040A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001040A, 0x00000000, 0x00000000}
    },
    {
      0x00010433,
      "DESERET SMALL LETTER SHORT OO",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0001040B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001040B, 0x00000000, 0x00000000}
    },
    {
      0x00010434,
      "DESERET SMALL LETTER AY",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0001040C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001040C, 0x00000000, 0x00000000}
    },
    {
      0x00010435,
      "DESERET SMALL LETTER OW",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0001040D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001040D, 0x00000000, 0x00000000}
    },
    {
      0x00010436,
      "DESERET SMALL LETTER WU",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0001040E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001040E, 0x00000000, 0x00000000}
    },
    {
      0x00010437,
      "DESERET SMALL LETTER YEE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0001040F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001040F, 0x00000000, 0x00000000}
    },
    {
      0x00010438,
      "DESERET SMALL LETTER H",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010410, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010410, 0x00000000, 0x00000000}
    },
    {
      0x00010439,
      "DESERET SMALL LETTER PEE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010411, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010411, 0x00000000, 0x00000000}
    },
    {
      0x0001043A,
      "DESERET SMALL LETTER BEE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010412, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010412, 0x00000000, 0x00000000}
    },
    {
      0x0001043B,
      "DESERET SMALL LETTER TEE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010413, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010413, 0x00000000, 0x00000000}
    },
    {
      0x0001043C,
      "DESERET SMALL LETTER DEE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010414, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010414, 0x00000000, 0x00000000}
    },
    {
      0x0001043D,
      "DESERET SMALL LETTER CHEE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010415, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010415, 0x00000000, 0x00000000}
    },
    {
      0x0001043E,
      "DESERET SMALL LETTER JEE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010416, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010416, 0x00000000, 0x00000000}
    },
    {
      0x0001043F,
      "DESERET SMALL LETTER KAY",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010417, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010417, 0x00000000, 0x00000000}
    },
    {
      0x00010440,
      "DESERET SMALL LETTER GAY",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010418, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010418, 0x00000000, 0x00000000}
    },
    {
      0x00010441,
      "DESERET SMALL LETTER EF",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010419, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010419, 0x00000000, 0x00000000}
    },
    {
      0x00010442,
      "DESERET SMALL LETTER VEE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0001041A, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001041A, 0x00000000, 0x00000000}
    },
    {
      0x00010443,
      "DESERET SMALL LETTER ETH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0001041B, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001041B, 0x00000000, 0x00000000}
    },
    {
      0x00010444,
      "DESERET SMALL LETTER THEE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0001041C, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001041C, 0x00000000, 0x00000000}
    },
    {
      0x00010445,
      "DESERET SMALL LETTER ES",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0001041D, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001041D, 0x00000000, 0x00000000}
    },
    {
      0x00010446,
      "DESERET SMALL LETTER ZEE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0001041E, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001041E, 0x00000000, 0x00000000}
    },
    {
      0x00010447,
      "DESERET SMALL LETTER ESH",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x0001041F, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x0001041F, 0x00000000, 0x00000000}
    },
    {
      0x00010448,
      "DESERET SMALL LETTER ZHEE",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010420, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010420, 0x00000000, 0x00000000}
    },
    {
      0x00010449,
      "DESERET SMALL LETTER ER",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010421, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010421, 0x00000000, 0x00000000}
    },
    {
      0x0001044A,
      "DESERET SMALL LETTER EL",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010422, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010422, 0x00000000, 0x00000000}
    },
    {
      0x0001044B,
      "DESERET SMALL LETTER EM",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010423, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010423, 0x00000000, 0x00000000}
    },
    {
      0x0001044C,
      "DESERET SMALL LETTER EN",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010424, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010424, 0x00000000, 0x00000000}
    },
    {
      0x0001044D,
      "DESERET SMALL LETTER ENG",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010425, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010425, 0x00000000, 0x00000000}
    },
    {
      0x0001044E,
      "DESERET SMALL LETTER OI",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010426, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010426, 0x00000000, 0x00000000}
    },
    {
      0x0001044F,
      "DESERET SMALL LETTER EW",
      0x01, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00010427, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00010427, 0x00000000, 0x00000000}
    },
    {
      0x00010450,
      "SHAVIAN LETTER PEEP",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010451,
      "SHAVIAN LETTER TOT",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010452,
      "SHAVIAN LETTER KICK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010453,
      "SHAVIAN LETTER FEE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010454,
      "SHAVIAN LETTER THIGH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010455,
      "SHAVIAN LETTER SO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010456,
      "SHAVIAN LETTER SURE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010457,
      "SHAVIAN LETTER CHURCH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010458,
      "SHAVIAN LETTER YEA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010459,
      "SHAVIAN LETTER HUNG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001045A,
      "SHAVIAN LETTER BIB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001045B,
      "SHAVIAN LETTER DEAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001045C,
      "SHAVIAN LETTER GAG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001045D,
      "SHAVIAN LETTER VOW",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001045E,
      "SHAVIAN LETTER THEY",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001045F,
      "SHAVIAN LETTER ZOO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010460,
      "SHAVIAN LETTER MEASURE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010461,
      "SHAVIAN LETTER JUDGE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010462,
      "SHAVIAN LETTER WOE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010463,
      "SHAVIAN LETTER HA-HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010464,
      "SHAVIAN LETTER LOLL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010465,
      "SHAVIAN LETTER MIME",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010466,
      "SHAVIAN LETTER IF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010467,
      "SHAVIAN LETTER EGG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010468,
      "SHAVIAN LETTER ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010469,
      "SHAVIAN LETTER ADO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001046A,
      "SHAVIAN LETTER ON",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001046B,
      "SHAVIAN LETTER WOOL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001046C,
      "SHAVIAN LETTER OUT",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001046D,
      "SHAVIAN LETTER AH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001046E,
      "SHAVIAN LETTER ROAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001046F,
      "SHAVIAN LETTER NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010470,
      "SHAVIAN LETTER EAT",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010471,
      "SHAVIAN LETTER AGE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010472,
      "SHAVIAN LETTER ICE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010473,
      "SHAVIAN LETTER UP",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010474,
      "SHAVIAN LETTER OAK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010475,
      "SHAVIAN LETTER OOZE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010476,
      "SHAVIAN LETTER OIL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010477,
      "SHAVIAN LETTER AWE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010478,
      "SHAVIAN LETTER ARE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010479,
      "SHAVIAN LETTER OR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001047A,
      "SHAVIAN LETTER AIR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001047B,
      "SHAVIAN LETTER ERR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001047C,
      "SHAVIAN LETTER ARRAY",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001047D,
      "SHAVIAN LETTER EAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001047E,
      "SHAVIAN LETTER IAN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001047F,
      "SHAVIAN LETTER YEW",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010480,
      "OSMANYA LETTER ALEF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010481,
      "OSMANYA LETTER BA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010482,
      "OSMANYA LETTER TA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010483,
      "OSMANYA LETTER JA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010484,
      "OSMANYA LETTER XA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010485,
      "OSMANYA LETTER KHA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010486,
      "OSMANYA LETTER DEEL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010487,
      "OSMANYA LETTER RA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010488,
      "OSMANYA LETTER SA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010489,
      "OSMANYA LETTER SHIIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001048A,
      "OSMANYA LETTER DHA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001048B,
      "OSMANYA LETTER CAYN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001048C,
      "OSMANYA LETTER GA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001048D,
      "OSMANYA LETTER FA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001048E,
      "OSMANYA LETTER QAAF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001048F,
      "OSMANYA LETTER KAAF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010490,
      "OSMANYA LETTER LAAN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010491,
      "OSMANYA LETTER MIIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010492,
      "OSMANYA LETTER NUUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010493,
      "OSMANYA LETTER WAW",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010494,
      "OSMANYA LETTER HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010495,
      "OSMANYA LETTER YA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010496,
      "OSMANYA LETTER A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010497,
      "OSMANYA LETTER E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010498,
      "OSMANYA LETTER I",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010499,
      "OSMANYA LETTER O",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001049A,
      "OSMANYA LETTER U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001049B,
      "OSMANYA LETTER AA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001049C,
      "OSMANYA LETTER EE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001049D,
      "OSMANYA LETTER OO",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000104A0,
      "OSMANYA DIGIT ZERO",
      0x20, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000104A1,
      "OSMANYA DIGIT ONE",
      0x20, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000104A2,
      "OSMANYA DIGIT TWO",
      0x20, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000104A3,
      "OSMANYA DIGIT THREE",
      0x20, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000104A4,
      "OSMANYA DIGIT FOUR",
      0x20, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000104A5,
      "OSMANYA DIGIT FIVE",
      0x20, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000104A6,
      "OSMANYA DIGIT SIX",
      0x20, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000104A7,
      "OSMANYA DIGIT SEVEN",
      0x20, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000104A8,
      "OSMANYA DIGIT EIGHT",
      0x20, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000104A9,
      "OSMANYA DIGIT NINE",
      0x20, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010800,
      "CYPRIOT SYLLABLE A",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010801,
      "CYPRIOT SYLLABLE E",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010802,
      "CYPRIOT SYLLABLE I",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010803,
      "CYPRIOT SYLLABLE O",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010804,
      "CYPRIOT SYLLABLE U",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010805,
      "CYPRIOT SYLLABLE JA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010808,
      "CYPRIOT SYLLABLE JO",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001080A,
      "CYPRIOT SYLLABLE KA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001080B,
      "CYPRIOT SYLLABLE KE",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001080C,
      "CYPRIOT SYLLABLE KI",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001080D,
      "CYPRIOT SYLLABLE KO",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001080E,
      "CYPRIOT SYLLABLE KU",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001080F,
      "CYPRIOT SYLLABLE LA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010810,
      "CYPRIOT SYLLABLE LE",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010811,
      "CYPRIOT SYLLABLE LI",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010812,
      "CYPRIOT SYLLABLE LO",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010813,
      "CYPRIOT SYLLABLE LU",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010814,
      "CYPRIOT SYLLABLE MA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010815,
      "CYPRIOT SYLLABLE ME",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010816,
      "CYPRIOT SYLLABLE MI",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010817,
      "CYPRIOT SYLLABLE MO",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010818,
      "CYPRIOT SYLLABLE MU",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010819,
      "CYPRIOT SYLLABLE NA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001081A,
      "CYPRIOT SYLLABLE NE",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001081B,
      "CYPRIOT SYLLABLE NI",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001081C,
      "CYPRIOT SYLLABLE NO",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001081D,
      "CYPRIOT SYLLABLE NU",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001081E,
      "CYPRIOT SYLLABLE PA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001081F,
      "CYPRIOT SYLLABLE PE",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010820,
      "CYPRIOT SYLLABLE PI",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010821,
      "CYPRIOT SYLLABLE PO",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010822,
      "CYPRIOT SYLLABLE PU",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010823,
      "CYPRIOT SYLLABLE RA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010824,
      "CYPRIOT SYLLABLE RE",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010825,
      "CYPRIOT SYLLABLE RI",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010826,
      "CYPRIOT SYLLABLE RO",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010827,
      "CYPRIOT SYLLABLE RU",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010828,
      "CYPRIOT SYLLABLE SA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010829,
      "CYPRIOT SYLLABLE SE",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001082A,
      "CYPRIOT SYLLABLE SI",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001082B,
      "CYPRIOT SYLLABLE SO",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001082C,
      "CYPRIOT SYLLABLE SU",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001082D,
      "CYPRIOT SYLLABLE TA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001082E,
      "CYPRIOT SYLLABLE TE",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001082F,
      "CYPRIOT SYLLABLE TI",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010830,
      "CYPRIOT SYLLABLE TO",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010831,
      "CYPRIOT SYLLABLE TU",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010832,
      "CYPRIOT SYLLABLE WA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010833,
      "CYPRIOT SYLLABLE WE",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010834,
      "CYPRIOT SYLLABLE WI",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010835,
      "CYPRIOT SYLLABLE WO",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010837,
      "CYPRIOT SYLLABLE XA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010838,
      "CYPRIOT SYLLABLE XE",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001083C,
      "CYPRIOT SYLLABLE ZA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001083F,
      "CYPRIOT SYLLABLE ZO",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010900,
      "PHOENICIAN LETTER ALF",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010901,
      "PHOENICIAN LETTER BET",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010902,
      "PHOENICIAN LETTER GAML",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010903,
      "PHOENICIAN LETTER DELT",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010904,
      "PHOENICIAN LETTER HE",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010905,
      "PHOENICIAN LETTER WAU",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010906,
      "PHOENICIAN LETTER ZAI",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010907,
      "PHOENICIAN LETTER HET",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010908,
      "PHOENICIAN LETTER TET",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010909,
      "PHOENICIAN LETTER YOD",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001090A,
      "PHOENICIAN LETTER KAF",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001090B,
      "PHOENICIAN LETTER LAMD",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001090C,
      "PHOENICIAN LETTER MEM",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001090D,
      "PHOENICIAN LETTER NUN",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001090E,
      "PHOENICIAN LETTER SEMK",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001090F,
      "PHOENICIAN LETTER AIN",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010910,
      "PHOENICIAN LETTER PE",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010911,
      "PHOENICIAN LETTER SADE",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010912,
      "PHOENICIAN LETTER QOF",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010913,
      "PHOENICIAN LETTER ROSH",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010914,
      "PHOENICIAN LETTER SHIN",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010915,
      "PHOENICIAN LETTER TAU",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010916,
      "PHOENICIAN NUMBER ONE",
      0x22, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010917,
      "PHOENICIAN NUMBER TEN",
      0x22, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010918,
      "PHOENICIAN NUMBER TWENTY",
      0x22, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010919,
      "PHOENICIAN NUMBER ONE HUNDRED",
      0x22, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001091F,
      "PHOENICIAN WORD SEPARATOR",
      0x36, 0, 0x12, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A00,
      "KHAROSHTHI LETTER A",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A01,
      "KHAROSHTHI VOWEL SIGN I",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A02,
      "KHAROSHTHI VOWEL SIGN U",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A03,
      "KHAROSHTHI VOWEL SIGN VOCALIC R",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A05,
      "KHAROSHTHI VOWEL SIGN E",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A06,
      "KHAROSHTHI VOWEL SIGN O",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A0C,
      "KHAROSHTHI VOWEL LENGTH MARK",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A0D,
      "KHAROSHTHI SIGN DOUBLE RING BELOW",
      0x10, 220, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A0E,
      "KHAROSHTHI SIGN ANUSVARA",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A0F,
      "KHAROSHTHI SIGN VISARGA",
      0x10, 230, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A10,
      "KHAROSHTHI LETTER KA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A11,
      "KHAROSHTHI LETTER KHA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A12,
      "KHAROSHTHI LETTER GA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A13,
      "KHAROSHTHI LETTER GHA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A15,
      "KHAROSHTHI LETTER CA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A16,
      "KHAROSHTHI LETTER CHA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A17,
      "KHAROSHTHI LETTER JA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A19,
      "KHAROSHTHI LETTER NYA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A1A,
      "KHAROSHTHI LETTER TTA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A1B,
      "KHAROSHTHI LETTER TTHA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A1C,
      "KHAROSHTHI LETTER DDA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A1D,
      "KHAROSHTHI LETTER DDHA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A1E,
      "KHAROSHTHI LETTER NNA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A1F,
      "KHAROSHTHI LETTER TA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A20,
      "KHAROSHTHI LETTER THA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A21,
      "KHAROSHTHI LETTER DA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A22,
      "KHAROSHTHI LETTER DHA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A23,
      "KHAROSHTHI LETTER NA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A24,
      "KHAROSHTHI LETTER PA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A25,
      "KHAROSHTHI LETTER PHA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A26,
      "KHAROSHTHI LETTER BA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A27,
      "KHAROSHTHI LETTER BHA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A28,
      "KHAROSHTHI LETTER MA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A29,
      "KHAROSHTHI LETTER YA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A2A,
      "KHAROSHTHI LETTER RA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A2B,
      "KHAROSHTHI LETTER LA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A2C,
      "KHAROSHTHI LETTER VA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A2D,
      "KHAROSHTHI LETTER SHA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A2E,
      "KHAROSHTHI LETTER SSA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A2F,
      "KHAROSHTHI LETTER SA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A30,
      "KHAROSHTHI LETTER ZA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A31,
      "KHAROSHTHI LETTER HA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A32,
      "KHAROSHTHI LETTER KKA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A33,
      "KHAROSHTHI LETTER TTTHA",
      0x04, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A38,
      "KHAROSHTHI SIGN BAR ABOVE",
      0x10, 230, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A39,
      "KHAROSHTHI SIGN CAUDA",
      0x10, 1, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A3A,
      "KHAROSHTHI SIGN DOT BELOW",
      0x10, 220, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A3F,
      "KHAROSHTHI VIRAMA",
      0x10, 9, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A40,
      "KHAROSHTHI DIGIT ONE",
      0x22, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A41,
      "KHAROSHTHI DIGIT TWO",
      0x22, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A42,
      "KHAROSHTHI DIGIT THREE",
      0x22, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A43,
      "KHAROSHTHI DIGIT FOUR",
      0x22, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A44,
      "KHAROSHTHI NUMBER TEN",
      0x22, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A45,
      "KHAROSHTHI NUMBER TWENTY",
      0x22, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A46,
      "KHAROSHTHI NUMBER ONE HUNDRED",
      0x22, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A47,
      "KHAROSHTHI NUMBER ONE THOUSAND",
      0x22, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A50,
      "KHAROSHTHI PUNCTUATION DOT",
      0x36, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A51,
      "KHAROSHTHI PUNCTUATION SMALL CIRCLE",
      0x36, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A52,
      "KHAROSHTHI PUNCTUATION CIRCLE",
      0x36, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A53,
      "KHAROSHTHI PUNCTUATION CRESCENT BAR",
      0x36, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A54,
      "KHAROSHTHI PUNCTUATION MANGALAM",
      0x36, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A55,
      "KHAROSHTHI PUNCTUATION LOTUS",
      0x36, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A56,
      "KHAROSHTHI PUNCTUATION DANDA",
      0x36, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A57,
      "KHAROSHTHI PUNCTUATION DOUBLE DANDA",
      0x36, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00010A58,
      "KHAROSHTHI PUNCTUATION LINES",
      0x36, 0, 0x03, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012000,
      "CUNEIFORM SIGN A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012001,
      "CUNEIFORM SIGN A TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012002,
      "CUNEIFORM SIGN A TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012003,
      "CUNEIFORM SIGN A TIMES GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012004,
      "CUNEIFORM SIGN A TIMES HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012005,
      "CUNEIFORM SIGN A TIMES IGI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012006,
      "CUNEIFORM SIGN A TIMES LAGAR GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012007,
      "CUNEIFORM SIGN A TIMES MUSH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012008,
      "CUNEIFORM SIGN A TIMES SAG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012009,
      "CUNEIFORM SIGN A2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001200A,
      "CUNEIFORM SIGN AB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001200B,
      "CUNEIFORM SIGN AB TIMES ASH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001200C,
      "CUNEIFORM SIGN AB TIMES DUN3 GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001200D,
      "CUNEIFORM SIGN AB TIMES GAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001200E,
      "CUNEIFORM SIGN AB TIMES GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001200F,
      "CUNEIFORM SIGN AB TIMES HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012010,
      "CUNEIFORM SIGN AB TIMES IGI GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012011,
      "CUNEIFORM SIGN AB TIMES IMIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012012,
      "CUNEIFORM SIGN AB TIMES LAGAB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012013,
      "CUNEIFORM SIGN AB TIMES SHESH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012014,
      "CUNEIFORM SIGN AB TIMES U PLUS U PLUS U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012015,
      "CUNEIFORM SIGN AB GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012016,
      "CUNEIFORM SIGN AB2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012017,
      "CUNEIFORM SIGN AB2 TIMES BALAG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012018,
      "CUNEIFORM SIGN AB2 TIMES GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012019,
      "CUNEIFORM SIGN AB2 TIMES ME PLUS EN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001201A,
      "CUNEIFORM SIGN AB2 TIMES SHA3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001201B,
      "CUNEIFORM SIGN AB2 TIMES TAK4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001201C,
      "CUNEIFORM SIGN AD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001201D,
      "CUNEIFORM SIGN AK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001201E,
      "CUNEIFORM SIGN AK TIMES ERIN2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001201F,
      "CUNEIFORM SIGN AK TIMES SHITA PLUS GISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012020,
      "CUNEIFORM SIGN AL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012021,
      "CUNEIFORM SIGN AL TIMES AL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012022,
      "CUNEIFORM SIGN AL TIMES DIM2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012023,
      "CUNEIFORM SIGN AL TIMES GISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012024,
      "CUNEIFORM SIGN AL TIMES HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012025,
      "CUNEIFORM SIGN AL TIMES KAD3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012026,
      "CUNEIFORM SIGN AL TIMES KI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012027,
      "CUNEIFORM SIGN AL TIMES SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012028,
      "CUNEIFORM SIGN AL TIMES USH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012029,
      "CUNEIFORM SIGN ALAN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001202A,
      "CUNEIFORM SIGN ALEPH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001202B,
      "CUNEIFORM SIGN AMAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001202C,
      "CUNEIFORM SIGN AMAR TIMES SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001202D,
      "CUNEIFORM SIGN AN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001202E,
      "CUNEIFORM SIGN AN OVER AN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001202F,
      "CUNEIFORM SIGN AN THREE TIMES",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012030,
      "CUNEIFORM SIGN AN PLUS NAGA OPPOSING AN PLUS NAGA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012031,
      "CUNEIFORM SIGN AN PLUS NAGA SQUARED",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012032,
      "CUNEIFORM SIGN ANSHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012033,
      "CUNEIFORM SIGN APIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012034,
      "CUNEIFORM SIGN ARAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012035,
      "CUNEIFORM SIGN ARAD TIMES KUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012036,
      "CUNEIFORM SIGN ARKAB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012037,
      "CUNEIFORM SIGN ASAL2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012038,
      "CUNEIFORM SIGN ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012039,
      "CUNEIFORM SIGN ASH ZIDA TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001203A,
      "CUNEIFORM SIGN ASH KABA TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001203B,
      "CUNEIFORM SIGN ASH OVER ASH TUG2 OVER TUG2 TUG2 OVER TUG2 PAP",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001203C,
      "CUNEIFORM SIGN ASH OVER ASH OVER ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001203D,
      "CUNEIFORM SIGN ASH OVER ASH OVER ASH CROSSING ASH OVER ASH OVER ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001203E,
      "CUNEIFORM SIGN ASH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001203F,
      "CUNEIFORM SIGN ASHGAB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012040,
      "CUNEIFORM SIGN BA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012041,
      "CUNEIFORM SIGN BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012042,
      "CUNEIFORM SIGN BAG3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012043,
      "CUNEIFORM SIGN BAHAR2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012044,
      "CUNEIFORM SIGN BAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012045,
      "CUNEIFORM SIGN BAL OVER BAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012046,
      "CUNEIFORM SIGN BALAG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012047,
      "CUNEIFORM SIGN BAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012048,
      "CUNEIFORM SIGN BARA2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012049,
      "CUNEIFORM SIGN BI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001204A,
      "CUNEIFORM SIGN BI TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001204B,
      "CUNEIFORM SIGN BI TIMES GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001204C,
      "CUNEIFORM SIGN BI TIMES IGI GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001204D,
      "CUNEIFORM SIGN BU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001204E,
      "CUNEIFORM SIGN BU OVER BU AB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001204F,
      "CUNEIFORM SIGN BU OVER BU UN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012050,
      "CUNEIFORM SIGN BU CROSSING BU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012051,
      "CUNEIFORM SIGN BULUG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012052,
      "CUNEIFORM SIGN BULUG OVER BULUG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012053,
      "CUNEIFORM SIGN BUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012054,
      "CUNEIFORM SIGN BUR2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012055,
      "CUNEIFORM SIGN DA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012056,
      "CUNEIFORM SIGN DAG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012057,
      "CUNEIFORM SIGN DAG KISIM5 TIMES A PLUS MASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012058,
      "CUNEIFORM SIGN DAG KISIM5 TIMES AMAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012059,
      "CUNEIFORM SIGN DAG KISIM5 TIMES BALAG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001205A,
      "CUNEIFORM SIGN DAG KISIM5 TIMES BI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001205B,
      "CUNEIFORM SIGN DAG KISIM5 TIMES GA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001205C,
      "CUNEIFORM SIGN DAG KISIM5 TIMES GA PLUS MASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001205D,
      "CUNEIFORM SIGN DAG KISIM5 TIMES GI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001205E,
      "CUNEIFORM SIGN DAG KISIM5 TIMES GIR2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001205F,
      "CUNEIFORM SIGN DAG KISIM5 TIMES GUD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012060,
      "CUNEIFORM SIGN DAG KISIM5 TIMES HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012061,
      "CUNEIFORM SIGN DAG KISIM5 TIMES IR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012062,
      "CUNEIFORM SIGN DAG KISIM5 TIMES IR PLUS LU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012063,
      "CUNEIFORM SIGN DAG KISIM5 TIMES KAK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012064,
      "CUNEIFORM SIGN DAG KISIM5 TIMES LA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012065,
      "CUNEIFORM SIGN DAG KISIM5 TIMES LU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012066,
      "CUNEIFORM SIGN DAG KISIM5 TIMES LU PLUS MASH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012067,
      "CUNEIFORM SIGN DAG KISIM5 TIMES LUM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012068,
      "CUNEIFORM SIGN DAG KISIM5 TIMES NE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012069,
      "CUNEIFORM SIGN DAG KISIM5 TIMES PAP PLUS PAP",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001206A,
      "CUNEIFORM SIGN DAG KISIM5 TIMES SI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001206B,
      "CUNEIFORM SIGN DAG KISIM5 TIMES TAK4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001206C,
      "CUNEIFORM SIGN DAG KISIM5 TIMES U2 PLUS GIR2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001206D,
      "CUNEIFORM SIGN DAG KISIM5 TIMES USH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001206E,
      "CUNEIFORM SIGN DAM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001206F,
      "CUNEIFORM SIGN DAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012070,
      "CUNEIFORM SIGN DARA3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012071,
      "CUNEIFORM SIGN DARA4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012072,
      "CUNEIFORM SIGN DI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012073,
      "CUNEIFORM SIGN DIB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012074,
      "CUNEIFORM SIGN DIM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012075,
      "CUNEIFORM SIGN DIM TIMES SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012076,
      "CUNEIFORM SIGN DIM2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012077,
      "CUNEIFORM SIGN DIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012078,
      "CUNEIFORM SIGN DIN KASKAL U GUNU DISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012079,
      "CUNEIFORM SIGN DISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001207A,
      "CUNEIFORM SIGN DU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001207B,
      "CUNEIFORM SIGN DU OVER DU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001207C,
      "CUNEIFORM SIGN DU GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001207D,
      "CUNEIFORM SIGN DU SHESHIG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001207E,
      "CUNEIFORM SIGN DUB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001207F,
      "CUNEIFORM SIGN DUB TIMES ESH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012080,
      "CUNEIFORM SIGN DUB2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012081,
      "CUNEIFORM SIGN DUG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012082,
      "CUNEIFORM SIGN DUGUD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012083,
      "CUNEIFORM SIGN DUH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012084,
      "CUNEIFORM SIGN DUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012085,
      "CUNEIFORM SIGN DUN3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012086,
      "CUNEIFORM SIGN DUN3 GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012087,
      "CUNEIFORM SIGN DUN3 GUNU GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012088,
      "CUNEIFORM SIGN DUN4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012089,
      "CUNEIFORM SIGN DUR2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001208A,
      "CUNEIFORM SIGN E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001208B,
      "CUNEIFORM SIGN E TIMES PAP",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001208C,
      "CUNEIFORM SIGN E OVER E NUN OVER NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001208D,
      "CUNEIFORM SIGN E2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001208E,
      "CUNEIFORM SIGN E2 TIMES A PLUS HA PLUS DA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001208F,
      "CUNEIFORM SIGN E2 TIMES GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012090,
      "CUNEIFORM SIGN E2 TIMES MI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012091,
      "CUNEIFORM SIGN E2 TIMES SAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012092,
      "CUNEIFORM SIGN E2 TIMES SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012093,
      "CUNEIFORM SIGN E2 TIMES U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012094,
      "CUNEIFORM SIGN EDIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012095,
      "CUNEIFORM SIGN EGIR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012096,
      "CUNEIFORM SIGN EL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012097,
      "CUNEIFORM SIGN EN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012098,
      "CUNEIFORM SIGN EN TIMES GAN2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012099,
      "CUNEIFORM SIGN EN TIMES GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001209A,
      "CUNEIFORM SIGN EN TIMES ME",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001209B,
      "CUNEIFORM SIGN EN CROSSING EN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001209C,
      "CUNEIFORM SIGN EN OPPOSING EN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001209D,
      "CUNEIFORM SIGN EN SQUARED",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001209E,
      "CUNEIFORM SIGN EREN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001209F,
      "CUNEIFORM SIGN ERIN2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120A0,
      "CUNEIFORM SIGN ESH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120A1,
      "CUNEIFORM SIGN EZEN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120A2,
      "CUNEIFORM SIGN EZEN TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120A3,
      "CUNEIFORM SIGN EZEN TIMES A PLUS LAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120A4,
      "CUNEIFORM SIGN EZEN TIMES A PLUS LAL TIMES LAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120A5,
      "CUNEIFORM SIGN EZEN TIMES AN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120A6,
      "CUNEIFORM SIGN EZEN TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120A7,
      "CUNEIFORM SIGN EZEN TIMES DUN3 GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120A8,
      "CUNEIFORM SIGN EZEN TIMES DUN3 GUNU GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120A9,
      "CUNEIFORM SIGN EZEN TIMES HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120AA,
      "CUNEIFORM SIGN EZEN TIMES HA GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120AB,
      "CUNEIFORM SIGN EZEN TIMES IGI GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120AC,
      "CUNEIFORM SIGN EZEN TIMES KASKAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120AD,
      "CUNEIFORM SIGN EZEN TIMES KASKAL SQUARED",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120AE,
      "CUNEIFORM SIGN EZEN TIMES KU3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120AF,
      "CUNEIFORM SIGN EZEN TIMES LA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120B0,
      "CUNEIFORM SIGN EZEN TIMES LAL TIMES LAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120B1,
      "CUNEIFORM SIGN EZEN TIMES LI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120B2,
      "CUNEIFORM SIGN EZEN TIMES LU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120B3,
      "CUNEIFORM SIGN EZEN TIMES U2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120B4,
      "CUNEIFORM SIGN EZEN TIMES UD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120B5,
      "CUNEIFORM SIGN GA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120B6,
      "CUNEIFORM SIGN GA GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120B7,
      "CUNEIFORM SIGN GA2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120B8,
      "CUNEIFORM SIGN GA2 TIMES A PLUS DA PLUS HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120B9,
      "CUNEIFORM SIGN GA2 TIMES A PLUS HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120BA,
      "CUNEIFORM SIGN GA2 TIMES A PLUS IGI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120BB,
      "CUNEIFORM SIGN GA2 TIMES AB2 TENU PLUS TAB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120BC,
      "CUNEIFORM SIGN GA2 TIMES AN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120BD,
      "CUNEIFORM SIGN GA2 TIMES ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120BE,
      "CUNEIFORM SIGN GA2 TIMES ASH2 PLUS GAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120BF,
      "CUNEIFORM SIGN GA2 TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120C0,
      "CUNEIFORM SIGN GA2 TIMES BAR PLUS RA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120C1,
      "CUNEIFORM SIGN GA2 TIMES BUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120C2,
      "CUNEIFORM SIGN GA2 TIMES BUR PLUS RA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120C3,
      "CUNEIFORM SIGN GA2 TIMES DA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120C4,
      "CUNEIFORM SIGN GA2 TIMES DI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120C5,
      "CUNEIFORM SIGN GA2 TIMES DIM TIMES SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120C6,
      "CUNEIFORM SIGN GA2 TIMES DUB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120C7,
      "CUNEIFORM SIGN GA2 TIMES EL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120C8,
      "CUNEIFORM SIGN GA2 TIMES EL PLUS LA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120C9,
      "CUNEIFORM SIGN GA2 TIMES EN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120CA,
      "CUNEIFORM SIGN GA2 TIMES EN TIMES GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120CB,
      "CUNEIFORM SIGN GA2 TIMES GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120CC,
      "CUNEIFORM SIGN GA2 TIMES GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120CD,
      "CUNEIFORM SIGN GA2 TIMES GI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120CE,
      "CUNEIFORM SIGN GA2 TIMES GI4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120CF,
      "CUNEIFORM SIGN GA2 TIMES GI4 PLUS A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120D0,
      "CUNEIFORM SIGN GA2 TIMES GIR2 PLUS SU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120D1,
      "CUNEIFORM SIGN GA2 TIMES HA PLUS LU PLUS ESH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120D2,
      "CUNEIFORM SIGN GA2 TIMES HAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120D3,
      "CUNEIFORM SIGN GA2 TIMES HAL PLUS LA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120D4,
      "CUNEIFORM SIGN GA2 TIMES HI PLUS LI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120D5,
      "CUNEIFORM SIGN GA2 TIMES HUB2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120D6,
      "CUNEIFORM SIGN GA2 TIMES IGI GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120D7,
      "CUNEIFORM SIGN GA2 TIMES ISH PLUS HU PLUS ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120D8,
      "CUNEIFORM SIGN GA2 TIMES KAK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120D9,
      "CUNEIFORM SIGN GA2 TIMES KASKAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120DA,
      "CUNEIFORM SIGN GA2 TIMES KID",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120DB,
      "CUNEIFORM SIGN GA2 TIMES KID PLUS LAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120DC,
      "CUNEIFORM SIGN GA2 TIMES KU3 PLUS AN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120DD,
      "CUNEIFORM SIGN GA2 TIMES LA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120DE,
      "CUNEIFORM SIGN GA2 TIMES ME PLUS EN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120DF,
      "CUNEIFORM SIGN GA2 TIMES MI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120E0,
      "CUNEIFORM SIGN GA2 TIMES NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120E1,
      "CUNEIFORM SIGN GA2 TIMES NUN OVER NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120E2,
      "CUNEIFORM SIGN GA2 TIMES PA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120E3,
      "CUNEIFORM SIGN GA2 TIMES SAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120E4,
      "CUNEIFORM SIGN GA2 TIMES SAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120E5,
      "CUNEIFORM SIGN GA2 TIMES SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120E6,
      "CUNEIFORM SIGN GA2 TIMES SHE PLUS TUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120E7,
      "CUNEIFORM SIGN GA2 TIMES SHID",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120E8,
      "CUNEIFORM SIGN GA2 TIMES SUM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120E9,
      "CUNEIFORM SIGN GA2 TIMES TAK4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120EA,
      "CUNEIFORM SIGN GA2 TIMES U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120EB,
      "CUNEIFORM SIGN GA2 TIMES UD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120EC,
      "CUNEIFORM SIGN GA2 TIMES UD PLUS DU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120ED,
      "CUNEIFORM SIGN GA2 OVER GA2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120EE,
      "CUNEIFORM SIGN GABA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120EF,
      "CUNEIFORM SIGN GABA CROSSING GABA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120F0,
      "CUNEIFORM SIGN GAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120F1,
      "CUNEIFORM SIGN GAD OVER GAD GAR OVER GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120F2,
      "CUNEIFORM SIGN GAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120F3,
      "CUNEIFORM SIGN GAL GAD OVER GAD GAR OVER GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120F4,
      "CUNEIFORM SIGN GALAM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120F5,
      "CUNEIFORM SIGN GAM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120F6,
      "CUNEIFORM SIGN GAN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120F7,
      "CUNEIFORM SIGN GAN2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120F8,
      "CUNEIFORM SIGN GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120F9,
      "CUNEIFORM SIGN GAN2 OVER GAN2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120FA,
      "CUNEIFORM SIGN GAN2 CROSSING GAN2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120FB,
      "CUNEIFORM SIGN GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120FC,
      "CUNEIFORM SIGN GAR3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120FD,
      "CUNEIFORM SIGN GASHAN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120FE,
      "CUNEIFORM SIGN GESHTIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000120FF,
      "CUNEIFORM SIGN GESHTIN TIMES KUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012100,
      "CUNEIFORM SIGN GI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012101,
      "CUNEIFORM SIGN GI TIMES E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012102,
      "CUNEIFORM SIGN GI TIMES U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012103,
      "CUNEIFORM SIGN GI CROSSING GI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012104,
      "CUNEIFORM SIGN GI4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012105,
      "CUNEIFORM SIGN GI4 OVER GI4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012106,
      "CUNEIFORM SIGN GI4 CROSSING GI4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012107,
      "CUNEIFORM SIGN GIDIM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012108,
      "CUNEIFORM SIGN GIR2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012109,
      "CUNEIFORM SIGN GIR2 GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001210A,
      "CUNEIFORM SIGN GIR3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001210B,
      "CUNEIFORM SIGN GIR3 TIMES A PLUS IGI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001210C,
      "CUNEIFORM SIGN GIR3 TIMES GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001210D,
      "CUNEIFORM SIGN GIR3 TIMES IGI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001210E,
      "CUNEIFORM SIGN GIR3 TIMES LU PLUS IGI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001210F,
      "CUNEIFORM SIGN GIR3 TIMES PA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012110,
      "CUNEIFORM SIGN GISAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012111,
      "CUNEIFORM SIGN GISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012112,
      "CUNEIFORM SIGN GISH CROSSING GISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012113,
      "CUNEIFORM SIGN GISH TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012114,
      "CUNEIFORM SIGN GISH TIMES TAK4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012115,
      "CUNEIFORM SIGN GISH TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012116,
      "CUNEIFORM SIGN GU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012117,
      "CUNEIFORM SIGN GU CROSSING GU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012118,
      "CUNEIFORM SIGN GU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012119,
      "CUNEIFORM SIGN GU2 TIMES KAK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001211A,
      "CUNEIFORM SIGN GU2 TIMES KAK TIMES IGI GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001211B,
      "CUNEIFORM SIGN GU2 TIMES NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001211C,
      "CUNEIFORM SIGN GU2 TIMES SAL PLUS TUG2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001211D,
      "CUNEIFORM SIGN GU2 GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001211E,
      "CUNEIFORM SIGN GUD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001211F,
      "CUNEIFORM SIGN GUD TIMES A PLUS KUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012120,
      "CUNEIFORM SIGN GUD TIMES KUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012121,
      "CUNEIFORM SIGN GUD OVER GUD LUGAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012122,
      "CUNEIFORM SIGN GUL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012123,
      "CUNEIFORM SIGN GUM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012124,
      "CUNEIFORM SIGN GUM TIMES SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012125,
      "CUNEIFORM SIGN GUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012126,
      "CUNEIFORM SIGN GUR7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012127,
      "CUNEIFORM SIGN GURUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012128,
      "CUNEIFORM SIGN GURUSH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012129,
      "CUNEIFORM SIGN HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001212A,
      "CUNEIFORM SIGN HA TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001212B,
      "CUNEIFORM SIGN HA GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001212C,
      "CUNEIFORM SIGN HAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001212D,
      "CUNEIFORM SIGN HI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001212E,
      "CUNEIFORM SIGN HI TIMES ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001212F,
      "CUNEIFORM SIGN HI TIMES ASH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012130,
      "CUNEIFORM SIGN HI TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012131,
      "CUNEIFORM SIGN HI TIMES DISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012132,
      "CUNEIFORM SIGN HI TIMES GAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012133,
      "CUNEIFORM SIGN HI TIMES KIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012134,
      "CUNEIFORM SIGN HI TIMES NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012135,
      "CUNEIFORM SIGN HI TIMES SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012136,
      "CUNEIFORM SIGN HI TIMES U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012137,
      "CUNEIFORM SIGN HU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012138,
      "CUNEIFORM SIGN HUB2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012139,
      "CUNEIFORM SIGN HUB2 TIMES AN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001213A,
      "CUNEIFORM SIGN HUB2 TIMES HAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001213B,
      "CUNEIFORM SIGN HUB2 TIMES KASKAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001213C,
      "CUNEIFORM SIGN HUB2 TIMES LISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001213D,
      "CUNEIFORM SIGN HUB2 TIMES UD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001213E,
      "CUNEIFORM SIGN HUL2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001213F,
      "CUNEIFORM SIGN I",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012140,
      "CUNEIFORM SIGN I A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012141,
      "CUNEIFORM SIGN IB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012142,
      "CUNEIFORM SIGN IDIM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012143,
      "CUNEIFORM SIGN IDIM OVER IDIM BUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012144,
      "CUNEIFORM SIGN IDIM OVER IDIM SQUARED",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012145,
      "CUNEIFORM SIGN IG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012146,
      "CUNEIFORM SIGN IGI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012147,
      "CUNEIFORM SIGN IGI DIB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012148,
      "CUNEIFORM SIGN IGI RI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012149,
      "CUNEIFORM SIGN IGI OVER IGI SHIR OVER SHIR UD OVER UD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001214A,
      "CUNEIFORM SIGN IGI GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001214B,
      "CUNEIFORM SIGN IL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001214C,
      "CUNEIFORM SIGN IL TIMES GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001214D,
      "CUNEIFORM SIGN IL2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001214E,
      "CUNEIFORM SIGN IM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001214F,
      "CUNEIFORM SIGN IM TIMES TAK4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012150,
      "CUNEIFORM SIGN IM CROSSING IM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012151,
      "CUNEIFORM SIGN IM OPPOSING IM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012152,
      "CUNEIFORM SIGN IM SQUARED",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012153,
      "CUNEIFORM SIGN IMIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012154,
      "CUNEIFORM SIGN IN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012155,
      "CUNEIFORM SIGN IR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012156,
      "CUNEIFORM SIGN ISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012157,
      "CUNEIFORM SIGN KA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012158,
      "CUNEIFORM SIGN KA TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012159,
      "CUNEIFORM SIGN KA TIMES AD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001215A,
      "CUNEIFORM SIGN KA TIMES AD PLUS KU3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001215B,
      "CUNEIFORM SIGN KA TIMES ASH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001215C,
      "CUNEIFORM SIGN KA TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001215D,
      "CUNEIFORM SIGN KA TIMES BALAG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001215E,
      "CUNEIFORM SIGN KA TIMES BAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001215F,
      "CUNEIFORM SIGN KA TIMES BI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012160,
      "CUNEIFORM SIGN KA TIMES ERIN2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012161,
      "CUNEIFORM SIGN KA TIMES ESH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012162,
      "CUNEIFORM SIGN KA TIMES GA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012163,
      "CUNEIFORM SIGN KA TIMES GAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012164,
      "CUNEIFORM SIGN KA TIMES GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012165,
      "CUNEIFORM SIGN KA TIMES GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012166,
      "CUNEIFORM SIGN KA TIMES GAR PLUS SHA3 PLUS A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012167,
      "CUNEIFORM SIGN KA TIMES GI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012168,
      "CUNEIFORM SIGN KA TIMES GIR2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012169,
      "CUNEIFORM SIGN KA TIMES GISH PLUS SAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001216A,
      "CUNEIFORM SIGN KA TIMES GISH CROSSING GISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001216B,
      "CUNEIFORM SIGN KA TIMES GU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001216C,
      "CUNEIFORM SIGN KA TIMES GUR7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001216D,
      "CUNEIFORM SIGN KA TIMES IGI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001216E,
      "CUNEIFORM SIGN KA TIMES IM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001216F,
      "CUNEIFORM SIGN KA TIMES KAK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012170,
      "CUNEIFORM SIGN KA TIMES KI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012171,
      "CUNEIFORM SIGN KA TIMES KID",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012172,
      "CUNEIFORM SIGN KA TIMES LI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012173,
      "CUNEIFORM SIGN KA TIMES LU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012174,
      "CUNEIFORM SIGN KA TIMES ME",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012175,
      "CUNEIFORM SIGN KA TIMES ME PLUS DU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012176,
      "CUNEIFORM SIGN KA TIMES ME PLUS GI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012177,
      "CUNEIFORM SIGN KA TIMES ME PLUS TE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012178,
      "CUNEIFORM SIGN KA TIMES MI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012179,
      "CUNEIFORM SIGN KA TIMES MI PLUS NUNUZ",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001217A,
      "CUNEIFORM SIGN KA TIMES NE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001217B,
      "CUNEIFORM SIGN KA TIMES NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001217C,
      "CUNEIFORM SIGN KA TIMES PI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001217D,
      "CUNEIFORM SIGN KA TIMES RU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001217E,
      "CUNEIFORM SIGN KA TIMES SA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001217F,
      "CUNEIFORM SIGN KA TIMES SAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012180,
      "CUNEIFORM SIGN KA TIMES SHA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012181,
      "CUNEIFORM SIGN KA TIMES SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012182,
      "CUNEIFORM SIGN KA TIMES SHID",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012183,
      "CUNEIFORM SIGN KA TIMES SHU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012184,
      "CUNEIFORM SIGN KA TIMES SIG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012185,
      "CUNEIFORM SIGN KA TIMES SUHUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012186,
      "CUNEIFORM SIGN KA TIMES TAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012187,
      "CUNEIFORM SIGN KA TIMES U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012188,
      "CUNEIFORM SIGN KA TIMES U2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012189,
      "CUNEIFORM SIGN KA TIMES UD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001218A,
      "CUNEIFORM SIGN KA TIMES UMUM TIMES PA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001218B,
      "CUNEIFORM SIGN KA TIMES USH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001218C,
      "CUNEIFORM SIGN KA TIMES ZI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001218D,
      "CUNEIFORM SIGN KA2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001218E,
      "CUNEIFORM SIGN KA2 CROSSING KA2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001218F,
      "CUNEIFORM SIGN KAB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012190,
      "CUNEIFORM SIGN KAD2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012191,
      "CUNEIFORM SIGN KAD3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012192,
      "CUNEIFORM SIGN KAD4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012193,
      "CUNEIFORM SIGN KAD5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012194,
      "CUNEIFORM SIGN KAD5 OVER KAD5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012195,
      "CUNEIFORM SIGN KAK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012196,
      "CUNEIFORM SIGN KAK TIMES IGI GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012197,
      "CUNEIFORM SIGN KAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012198,
      "CUNEIFORM SIGN KAL TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012199,
      "CUNEIFORM SIGN KAL CROSSING KAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001219A,
      "CUNEIFORM SIGN KAM2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001219B,
      "CUNEIFORM SIGN KAM4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001219C,
      "CUNEIFORM SIGN KASKAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001219D,
      "CUNEIFORM SIGN KASKAL LAGAB TIMES U OVER LAGAB TIMES U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001219E,
      "CUNEIFORM SIGN KASKAL OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001219F,
      "CUNEIFORM SIGN KESH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121A0,
      "CUNEIFORM SIGN KI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121A1,
      "CUNEIFORM SIGN KI TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121A2,
      "CUNEIFORM SIGN KI TIMES U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121A3,
      "CUNEIFORM SIGN KI TIMES UD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121A4,
      "CUNEIFORM SIGN KID",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121A5,
      "CUNEIFORM SIGN KIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121A6,
      "CUNEIFORM SIGN KISAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121A7,
      "CUNEIFORM SIGN KISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121A8,
      "CUNEIFORM SIGN KISIM5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121A9,
      "CUNEIFORM SIGN KISIM5 OVER KISIM5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121AA,
      "CUNEIFORM SIGN KU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121AB,
      "CUNEIFORM SIGN KU OVER HI TIMES ASH2 KU OVER HI TIMES ASH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121AC,
      "CUNEIFORM SIGN KU3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121AD,
      "CUNEIFORM SIGN KU4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121AE,
      "CUNEIFORM SIGN KU4 VARIANT FORM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121AF,
      "CUNEIFORM SIGN KU7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121B0,
      "CUNEIFORM SIGN KUL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121B1,
      "CUNEIFORM SIGN KUL GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121B2,
      "CUNEIFORM SIGN KUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121B3,
      "CUNEIFORM SIGN KUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121B4,
      "CUNEIFORM SIGN KUR OPPOSING KUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121B5,
      "CUNEIFORM SIGN KUSHU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121B6,
      "CUNEIFORM SIGN KWU318",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121B7,
      "CUNEIFORM SIGN LA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121B8,
      "CUNEIFORM SIGN LAGAB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121B9,
      "CUNEIFORM SIGN LAGAB TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121BA,
      "CUNEIFORM SIGN LAGAB TIMES A PLUS DA PLUS HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121BB,
      "CUNEIFORM SIGN LAGAB TIMES A PLUS GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121BC,
      "CUNEIFORM SIGN LAGAB TIMES A PLUS LAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121BD,
      "CUNEIFORM SIGN LAGAB TIMES AL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121BE,
      "CUNEIFORM SIGN LAGAB TIMES AN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121BF,
      "CUNEIFORM SIGN LAGAB TIMES ASH ZIDA TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121C0,
      "CUNEIFORM SIGN LAGAB TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121C1,
      "CUNEIFORM SIGN LAGAB TIMES BI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121C2,
      "CUNEIFORM SIGN LAGAB TIMES DAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121C3,
      "CUNEIFORM SIGN LAGAB TIMES EN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121C4,
      "CUNEIFORM SIGN LAGAB TIMES GA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121C5,
      "CUNEIFORM SIGN LAGAB TIMES GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121C6,
      "CUNEIFORM SIGN LAGAB TIMES GUD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121C7,
      "CUNEIFORM SIGN LAGAB TIMES GUD PLUS GUD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121C8,
      "CUNEIFORM SIGN LAGAB TIMES HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121C9,
      "CUNEIFORM SIGN LAGAB TIMES HAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121CA,
      "CUNEIFORM SIGN LAGAB TIMES HI TIMES NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121CB,
      "CUNEIFORM SIGN LAGAB TIMES IGI GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121CC,
      "CUNEIFORM SIGN LAGAB TIMES IM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121CD,
      "CUNEIFORM SIGN LAGAB TIMES IM PLUS HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121CE,
      "CUNEIFORM SIGN LAGAB TIMES IM PLUS LU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121CF,
      "CUNEIFORM SIGN LAGAB TIMES KI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121D0,
      "CUNEIFORM SIGN LAGAB TIMES KIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121D1,
      "CUNEIFORM SIGN LAGAB TIMES KU3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121D2,
      "CUNEIFORM SIGN LAGAB TIMES KUL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121D3,
      "CUNEIFORM SIGN LAGAB TIMES KUL PLUS HI PLUS A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121D4,
      "CUNEIFORM SIGN LAGAB TIMES LAGAB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121D5,
      "CUNEIFORM SIGN LAGAB TIMES LISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121D6,
      "CUNEIFORM SIGN LAGAB TIMES LU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121D7,
      "CUNEIFORM SIGN LAGAB TIMES LUL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121D8,
      "CUNEIFORM SIGN LAGAB TIMES ME",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121D9,
      "CUNEIFORM SIGN LAGAB TIMES ME PLUS EN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121DA,
      "CUNEIFORM SIGN LAGAB TIMES MUSH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121DB,
      "CUNEIFORM SIGN LAGAB TIMES NE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121DC,
      "CUNEIFORM SIGN LAGAB TIMES SHE PLUS SUM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121DD,
      "CUNEIFORM SIGN LAGAB TIMES SHITA PLUS GISH PLUS ERIN2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121DE,
      "CUNEIFORM SIGN LAGAB TIMES SHITA PLUS GISH TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121DF,
      "CUNEIFORM SIGN LAGAB TIMES SHU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121E0,
      "CUNEIFORM SIGN LAGAB TIMES SHU2 PLUS SHU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121E1,
      "CUNEIFORM SIGN LAGAB TIMES SUM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121E2,
      "CUNEIFORM SIGN LAGAB TIMES TAG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121E3,
      "CUNEIFORM SIGN LAGAB TIMES TAK4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121E4,
      "CUNEIFORM SIGN LAGAB TIMES TE PLUS A PLUS SU PLUS NA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121E5,
      "CUNEIFORM SIGN LAGAB TIMES U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121E6,
      "CUNEIFORM SIGN LAGAB TIMES U PLUS A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121E7,
      "CUNEIFORM SIGN LAGAB TIMES U PLUS U PLUS U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121E8,
      "CUNEIFORM SIGN LAGAB TIMES U2 PLUS ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121E9,
      "CUNEIFORM SIGN LAGAB TIMES UD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121EA,
      "CUNEIFORM SIGN LAGAB TIMES USH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121EB,
      "CUNEIFORM SIGN LAGAB SQUARED",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121EC,
      "CUNEIFORM SIGN LAGAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121ED,
      "CUNEIFORM SIGN LAGAR TIMES SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121EE,
      "CUNEIFORM SIGN LAGAR TIMES SHE PLUS SUM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121EF,
      "CUNEIFORM SIGN LAGAR GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121F0,
      "CUNEIFORM SIGN LAGAR GUNU OVER LAGAR GUNU SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121F1,
      "CUNEIFORM SIGN LAHSHU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121F2,
      "CUNEIFORM SIGN LAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121F3,
      "CUNEIFORM SIGN LAL TIMES LAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121F4,
      "CUNEIFORM SIGN LAM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121F5,
      "CUNEIFORM SIGN LAM TIMES KUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121F6,
      "CUNEIFORM SIGN LAM TIMES KUR PLUS RU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121F7,
      "CUNEIFORM SIGN LI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121F8,
      "CUNEIFORM SIGN LIL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121F9,
      "CUNEIFORM SIGN LIMMU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121FA,
      "CUNEIFORM SIGN LISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121FB,
      "CUNEIFORM SIGN LU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121FC,
      "CUNEIFORM SIGN LU TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121FD,
      "CUNEIFORM SIGN LU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121FE,
      "CUNEIFORM SIGN LU2 TIMES AL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000121FF,
      "CUNEIFORM SIGN LU2 TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012200,
      "CUNEIFORM SIGN LU2 TIMES ESH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012201,
      "CUNEIFORM SIGN LU2 TIMES ESH2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012202,
      "CUNEIFORM SIGN LU2 TIMES GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012203,
      "CUNEIFORM SIGN LU2 TIMES HI TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012204,
      "CUNEIFORM SIGN LU2 TIMES IM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012205,
      "CUNEIFORM SIGN LU2 TIMES KAD2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012206,
      "CUNEIFORM SIGN LU2 TIMES KAD3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012207,
      "CUNEIFORM SIGN LU2 TIMES KAD3 PLUS ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012208,
      "CUNEIFORM SIGN LU2 TIMES KI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012209,
      "CUNEIFORM SIGN LU2 TIMES LA PLUS ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001220A,
      "CUNEIFORM SIGN LU2 TIMES LAGAB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001220B,
      "CUNEIFORM SIGN LU2 TIMES ME PLUS EN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001220C,
      "CUNEIFORM SIGN LU2 TIMES NE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001220D,
      "CUNEIFORM SIGN LU2 TIMES NU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001220E,
      "CUNEIFORM SIGN LU2 TIMES SI PLUS ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001220F,
      "CUNEIFORM SIGN LU2 TIMES SIK2 PLUS BU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012210,
      "CUNEIFORM SIGN LU2 TIMES TUG2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012211,
      "CUNEIFORM SIGN LU2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012212,
      "CUNEIFORM SIGN LU2 CROSSING LU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012213,
      "CUNEIFORM SIGN LU2 OPPOSING LU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012214,
      "CUNEIFORM SIGN LU2 SQUARED",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012215,
      "CUNEIFORM SIGN LU2 SHESHIG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012216,
      "CUNEIFORM SIGN LU3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012217,
      "CUNEIFORM SIGN LUGAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012218,
      "CUNEIFORM SIGN LUGAL OVER LUGAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012219,
      "CUNEIFORM SIGN LUGAL OPPOSING LUGAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001221A,
      "CUNEIFORM SIGN LUGAL SHESHIG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001221B,
      "CUNEIFORM SIGN LUH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001221C,
      "CUNEIFORM SIGN LUL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001221D,
      "CUNEIFORM SIGN LUM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001221E,
      "CUNEIFORM SIGN LUM OVER LUM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001221F,
      "CUNEIFORM SIGN LUM OVER LUM GAR OVER GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012220,
      "CUNEIFORM SIGN MA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012221,
      "CUNEIFORM SIGN MA TIMES TAK4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012222,
      "CUNEIFORM SIGN MA GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012223,
      "CUNEIFORM SIGN MA2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012224,
      "CUNEIFORM SIGN MAH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012225,
      "CUNEIFORM SIGN MAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012226,
      "CUNEIFORM SIGN MASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012227,
      "CUNEIFORM SIGN MASH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012228,
      "CUNEIFORM SIGN ME",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012229,
      "CUNEIFORM SIGN MES",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001222A,
      "CUNEIFORM SIGN MI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001222B,
      "CUNEIFORM SIGN MIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001222C,
      "CUNEIFORM SIGN MU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001222D,
      "CUNEIFORM SIGN MU OVER MU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001222E,
      "CUNEIFORM SIGN MUG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001222F,
      "CUNEIFORM SIGN MUG GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012230,
      "CUNEIFORM SIGN MUNSUB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012231,
      "CUNEIFORM SIGN MURGU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012232,
      "CUNEIFORM SIGN MUSH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012233,
      "CUNEIFORM SIGN MUSH TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012234,
      "CUNEIFORM SIGN MUSH TIMES KUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012235,
      "CUNEIFORM SIGN MUSH TIMES ZA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012236,
      "CUNEIFORM SIGN MUSH OVER MUSH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012237,
      "CUNEIFORM SIGN MUSH OVER MUSH TIMES A PLUS NA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012238,
      "CUNEIFORM SIGN MUSH CROSSING MUSH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012239,
      "CUNEIFORM SIGN MUSH3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001223A,
      "CUNEIFORM SIGN MUSH3 TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001223B,
      "CUNEIFORM SIGN MUSH3 TIMES A PLUS DI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001223C,
      "CUNEIFORM SIGN MUSH3 TIMES DI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001223D,
      "CUNEIFORM SIGN MUSH3 GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001223E,
      "CUNEIFORM SIGN NA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001223F,
      "CUNEIFORM SIGN NA2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012240,
      "CUNEIFORM SIGN NAGA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012241,
      "CUNEIFORM SIGN NAGA INVERTED",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012242,
      "CUNEIFORM SIGN NAGA TIMES SHU TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012243,
      "CUNEIFORM SIGN NAGA OPPOSING NAGA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012244,
      "CUNEIFORM SIGN NAGAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012245,
      "CUNEIFORM SIGN NAM NUTILLU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012246,
      "CUNEIFORM SIGN NAM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012247,
      "CUNEIFORM SIGN NAM2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012248,
      "CUNEIFORM SIGN NE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012249,
      "CUNEIFORM SIGN NE TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001224A,
      "CUNEIFORM SIGN NE TIMES UD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001224B,
      "CUNEIFORM SIGN NE SHESHIG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001224C,
      "CUNEIFORM SIGN NI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001224D,
      "CUNEIFORM SIGN NI TIMES E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001224E,
      "CUNEIFORM SIGN NI2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001224F,
      "CUNEIFORM SIGN NIM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012250,
      "CUNEIFORM SIGN NIM TIMES GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012251,
      "CUNEIFORM SIGN NIM TIMES GAR PLUS GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012252,
      "CUNEIFORM SIGN NINDA2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012253,
      "CUNEIFORM SIGN NINDA2 TIMES AN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012254,
      "CUNEIFORM SIGN NINDA2 TIMES ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012255,
      "CUNEIFORM SIGN NINDA2 TIMES ASH PLUS ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012256,
      "CUNEIFORM SIGN NINDA2 TIMES GUD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012257,
      "CUNEIFORM SIGN NINDA2 TIMES ME PLUS GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012258,
      "CUNEIFORM SIGN NINDA2 TIMES NE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012259,
      "CUNEIFORM SIGN NINDA2 TIMES NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001225A,
      "CUNEIFORM SIGN NINDA2 TIMES SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001225B,
      "CUNEIFORM SIGN NINDA2 TIMES SHE PLUS A AN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001225C,
      "CUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001225D,
      "CUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASH PLUS ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001225E,
      "CUNEIFORM SIGN NINDA2 TIMES U2 PLUS ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001225F,
      "CUNEIFORM SIGN NINDA2 TIMES USH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012260,
      "CUNEIFORM SIGN NISAG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012261,
      "CUNEIFORM SIGN NU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012262,
      "CUNEIFORM SIGN NU11",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012263,
      "CUNEIFORM SIGN NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012264,
      "CUNEIFORM SIGN NUN LAGAR TIMES GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012265,
      "CUNEIFORM SIGN NUN LAGAR TIMES MASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012266,
      "CUNEIFORM SIGN NUN LAGAR TIMES SAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012267,
      "CUNEIFORM SIGN NUN LAGAR TIMES SAL OVER NUN LAGAR TIMES SAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012268,
      "CUNEIFORM SIGN NUN LAGAR TIMES USH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012269,
      "CUNEIFORM SIGN NUN TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001226A,
      "CUNEIFORM SIGN NUN OVER NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001226B,
      "CUNEIFORM SIGN NUN CROSSING NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001226C,
      "CUNEIFORM SIGN NUN CROSSING NUN LAGAR OVER LAGAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001226D,
      "CUNEIFORM SIGN NUNUZ",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001226E,
      "CUNEIFORM SIGN NUNUZ AB2 TIMES ASHGAB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001226F,
      "CUNEIFORM SIGN NUNUZ AB2 TIMES BI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012270,
      "CUNEIFORM SIGN NUNUZ AB2 TIMES DUG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012271,
      "CUNEIFORM SIGN NUNUZ AB2 TIMES GUD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012272,
      "CUNEIFORM SIGN NUNUZ AB2 TIMES IGI GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012273,
      "CUNEIFORM SIGN NUNUZ AB2 TIMES KAD3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012274,
      "CUNEIFORM SIGN NUNUZ AB2 TIMES LA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012275,
      "CUNEIFORM SIGN NUNUZ AB2 TIMES NE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012276,
      "CUNEIFORM SIGN NUNUZ AB2 TIMES SILA3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012277,
      "CUNEIFORM SIGN NUNUZ AB2 TIMES U2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012278,
      "CUNEIFORM SIGN NUNUZ KISIM5 TIMES BI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012279,
      "CUNEIFORM SIGN NUNUZ KISIM5 TIMES BI U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001227A,
      "CUNEIFORM SIGN PA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001227B,
      "CUNEIFORM SIGN PAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001227C,
      "CUNEIFORM SIGN PAN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001227D,
      "CUNEIFORM SIGN PAP",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001227E,
      "CUNEIFORM SIGN PESH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001227F,
      "CUNEIFORM SIGN PI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012280,
      "CUNEIFORM SIGN PI TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012281,
      "CUNEIFORM SIGN PI TIMES AB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012282,
      "CUNEIFORM SIGN PI TIMES BI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012283,
      "CUNEIFORM SIGN PI TIMES BU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012284,
      "CUNEIFORM SIGN PI TIMES E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012285,
      "CUNEIFORM SIGN PI TIMES I",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012286,
      "CUNEIFORM SIGN PI TIMES IB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012287,
      "CUNEIFORM SIGN PI TIMES U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012288,
      "CUNEIFORM SIGN PI TIMES U2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012289,
      "CUNEIFORM SIGN PI CROSSING PI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001228A,
      "CUNEIFORM SIGN PIRIG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001228B,
      "CUNEIFORM SIGN PIRIG TIMES KAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001228C,
      "CUNEIFORM SIGN PIRIG TIMES UD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001228D,
      "CUNEIFORM SIGN PIRIG TIMES ZA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001228E,
      "CUNEIFORM SIGN PIRIG OPPOSING PIRIG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001228F,
      "CUNEIFORM SIGN RA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012290,
      "CUNEIFORM SIGN RAB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012291,
      "CUNEIFORM SIGN RI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012292,
      "CUNEIFORM SIGN RU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012293,
      "CUNEIFORM SIGN SA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012294,
      "CUNEIFORM SIGN SAG NUTILLU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012295,
      "CUNEIFORM SIGN SAG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012296,
      "CUNEIFORM SIGN SAG TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012297,
      "CUNEIFORM SIGN SAG TIMES DU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012298,
      "CUNEIFORM SIGN SAG TIMES DUB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012299,
      "CUNEIFORM SIGN SAG TIMES HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001229A,
      "CUNEIFORM SIGN SAG TIMES KAK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001229B,
      "CUNEIFORM SIGN SAG TIMES KUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001229C,
      "CUNEIFORM SIGN SAG TIMES LUM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001229D,
      "CUNEIFORM SIGN SAG TIMES MI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001229E,
      "CUNEIFORM SIGN SAG TIMES NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001229F,
      "CUNEIFORM SIGN SAG TIMES SAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122A0,
      "CUNEIFORM SIGN SAG TIMES SHID",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122A1,
      "CUNEIFORM SIGN SAG TIMES TAB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122A2,
      "CUNEIFORM SIGN SAG TIMES U2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122A3,
      "CUNEIFORM SIGN SAG TIMES UB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122A4,
      "CUNEIFORM SIGN SAG TIMES UM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122A5,
      "CUNEIFORM SIGN SAG TIMES UR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122A6,
      "CUNEIFORM SIGN SAG TIMES USH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122A7,
      "CUNEIFORM SIGN SAG OVER SAG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122A8,
      "CUNEIFORM SIGN SAG GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122A9,
      "CUNEIFORM SIGN SAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122AA,
      "CUNEIFORM SIGN SAL LAGAB TIMES ASH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122AB,
      "CUNEIFORM SIGN SANGA2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122AC,
      "CUNEIFORM SIGN SAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122AD,
      "CUNEIFORM SIGN SHA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122AE,
      "CUNEIFORM SIGN SHA3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122AF,
      "CUNEIFORM SIGN SHA3 TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122B0,
      "CUNEIFORM SIGN SHA3 TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122B1,
      "CUNEIFORM SIGN SHA3 TIMES GISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122B2,
      "CUNEIFORM SIGN SHA3 TIMES NE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122B3,
      "CUNEIFORM SIGN SHA3 TIMES SHU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122B4,
      "CUNEIFORM SIGN SHA3 TIMES TUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122B5,
      "CUNEIFORM SIGN SHA3 TIMES U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122B6,
      "CUNEIFORM SIGN SHA3 TIMES U PLUS A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122B7,
      "CUNEIFORM SIGN SHA6",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122B8,
      "CUNEIFORM SIGN SHAB6",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122B9,
      "CUNEIFORM SIGN SHAR2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122BA,
      "CUNEIFORM SIGN SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122BB,
      "CUNEIFORM SIGN SHE HU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122BC,
      "CUNEIFORM SIGN SHE OVER SHE GAD OVER GAD GAR OVER GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122BD,
      "CUNEIFORM SIGN SHE OVER SHE TAB OVER TAB GAR OVER GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122BE,
      "CUNEIFORM SIGN SHEG9",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122BF,
      "CUNEIFORM SIGN SHEN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122C0,
      "CUNEIFORM SIGN SHESH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122C1,
      "CUNEIFORM SIGN SHESH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122C2,
      "CUNEIFORM SIGN SHESHLAM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122C3,
      "CUNEIFORM SIGN SHID",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122C4,
      "CUNEIFORM SIGN SHID TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122C5,
      "CUNEIFORM SIGN SHID TIMES IM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122C6,
      "CUNEIFORM SIGN SHIM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122C7,
      "CUNEIFORM SIGN SHIM TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122C8,
      "CUNEIFORM SIGN SHIM TIMES BAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122C9,
      "CUNEIFORM SIGN SHIM TIMES BULUG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122CA,
      "CUNEIFORM SIGN SHIM TIMES DIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122CB,
      "CUNEIFORM SIGN SHIM TIMES GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122CC,
      "CUNEIFORM SIGN SHIM TIMES IGI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122CD,
      "CUNEIFORM SIGN SHIM TIMES IGI GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122CE,
      "CUNEIFORM SIGN SHIM TIMES KUSHU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122CF,
      "CUNEIFORM SIGN SHIM TIMES LUL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122D0,
      "CUNEIFORM SIGN SHIM TIMES MUG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122D1,
      "CUNEIFORM SIGN SHIM TIMES SAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122D2,
      "CUNEIFORM SIGN SHINIG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122D3,
      "CUNEIFORM SIGN SHIR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122D4,
      "CUNEIFORM SIGN SHIR TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122D5,
      "CUNEIFORM SIGN SHIR OVER SHIR BUR OVER BUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122D6,
      "CUNEIFORM SIGN SHITA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122D7,
      "CUNEIFORM SIGN SHU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122D8,
      "CUNEIFORM SIGN SHU OVER INVERTED SHU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122D9,
      "CUNEIFORM SIGN SHU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122DA,
      "CUNEIFORM SIGN SHUBUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122DB,
      "CUNEIFORM SIGN SI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122DC,
      "CUNEIFORM SIGN SI GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122DD,
      "CUNEIFORM SIGN SIG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122DE,
      "CUNEIFORM SIGN SIG4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122DF,
      "CUNEIFORM SIGN SIG4 OVER SIG4 SHU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122E0,
      "CUNEIFORM SIGN SIK2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122E1,
      "CUNEIFORM SIGN SILA3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122E2,
      "CUNEIFORM SIGN SU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122E3,
      "CUNEIFORM SIGN SU OVER SU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122E4,
      "CUNEIFORM SIGN SUD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122E5,
      "CUNEIFORM SIGN SUD2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122E6,
      "CUNEIFORM SIGN SUHUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122E7,
      "CUNEIFORM SIGN SUM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122E8,
      "CUNEIFORM SIGN SUMASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122E9,
      "CUNEIFORM SIGN SUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122EA,
      "CUNEIFORM SIGN SUR9",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122EB,
      "CUNEIFORM SIGN TA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122EC,
      "CUNEIFORM SIGN TA ASTERISK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122ED,
      "CUNEIFORM SIGN TA TIMES HI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122EE,
      "CUNEIFORM SIGN TA TIMES MI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122EF,
      "CUNEIFORM SIGN TA GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122F0,
      "CUNEIFORM SIGN TAB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122F1,
      "CUNEIFORM SIGN TAB OVER TAB NI OVER NI DISH OVER DISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122F2,
      "CUNEIFORM SIGN TAB SQUARED",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122F3,
      "CUNEIFORM SIGN TAG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122F4,
      "CUNEIFORM SIGN TAG TIMES BI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122F5,
      "CUNEIFORM SIGN TAG TIMES GUD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122F6,
      "CUNEIFORM SIGN TAG TIMES SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122F7,
      "CUNEIFORM SIGN TAG TIMES SHU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122F8,
      "CUNEIFORM SIGN TAG TIMES TUG2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122F9,
      "CUNEIFORM SIGN TAG TIMES UD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122FA,
      "CUNEIFORM SIGN TAK4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122FB,
      "CUNEIFORM SIGN TAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122FC,
      "CUNEIFORM SIGN TE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122FD,
      "CUNEIFORM SIGN TE GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122FE,
      "CUNEIFORM SIGN TI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000122FF,
      "CUNEIFORM SIGN TI TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012300,
      "CUNEIFORM SIGN TIL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012301,
      "CUNEIFORM SIGN TIR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012302,
      "CUNEIFORM SIGN TIR TIMES TAK4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012303,
      "CUNEIFORM SIGN TIR OVER TIR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012304,
      "CUNEIFORM SIGN TIR OVER TIR GAD OVER GAD GAR OVER GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012305,
      "CUNEIFORM SIGN TU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012306,
      "CUNEIFORM SIGN TUG2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012307,
      "CUNEIFORM SIGN TUK",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012308,
      "CUNEIFORM SIGN TUM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012309,
      "CUNEIFORM SIGN TUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001230A,
      "CUNEIFORM SIGN TUR OVER TUR ZA OVER ZA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001230B,
      "CUNEIFORM SIGN U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001230C,
      "CUNEIFORM SIGN U GUD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001230D,
      "CUNEIFORM SIGN U U U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001230E,
      "CUNEIFORM SIGN U OVER U PA OVER PA GAR OVER GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001230F,
      "CUNEIFORM SIGN U OVER U SUR OVER SUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012310,
      "CUNEIFORM SIGN U OVER U U REVERSED OVER U REVERSED",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012311,
      "CUNEIFORM SIGN U2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012312,
      "CUNEIFORM SIGN UB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012313,
      "CUNEIFORM SIGN UD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012314,
      "CUNEIFORM SIGN UD KUSHU2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012315,
      "CUNEIFORM SIGN UD TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012316,
      "CUNEIFORM SIGN UD TIMES MI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012317,
      "CUNEIFORM SIGN UD TIMES U PLUS U PLUS U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012318,
      "CUNEIFORM SIGN UD TIMES U PLUS U PLUS U GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012319,
      "CUNEIFORM SIGN UD GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001231A,
      "CUNEIFORM SIGN UD SHESHIG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001231B,
      "CUNEIFORM SIGN UD SHESHIG TIMES BAD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001231C,
      "CUNEIFORM SIGN UDUG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001231D,
      "CUNEIFORM SIGN UM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001231E,
      "CUNEIFORM SIGN UM TIMES LAGAB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001231F,
      "CUNEIFORM SIGN UM TIMES ME PLUS DA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012320,
      "CUNEIFORM SIGN UM TIMES SHA3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012321,
      "CUNEIFORM SIGN UM TIMES U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012322,
      "CUNEIFORM SIGN UMBIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012323,
      "CUNEIFORM SIGN UMUM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012324,
      "CUNEIFORM SIGN UMUM TIMES KASKAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012325,
      "CUNEIFORM SIGN UMUM TIMES PA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012326,
      "CUNEIFORM SIGN UN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012327,
      "CUNEIFORM SIGN UN GUNU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012328,
      "CUNEIFORM SIGN UR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012329,
      "CUNEIFORM SIGN UR CROSSING UR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001232A,
      "CUNEIFORM SIGN UR SHESHIG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001232B,
      "CUNEIFORM SIGN UR2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001232C,
      "CUNEIFORM SIGN UR2 TIMES A PLUS HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001232D,
      "CUNEIFORM SIGN UR2 TIMES A PLUS NA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001232E,
      "CUNEIFORM SIGN UR2 TIMES AL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001232F,
      "CUNEIFORM SIGN UR2 TIMES HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012330,
      "CUNEIFORM SIGN UR2 TIMES NUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012331,
      "CUNEIFORM SIGN UR2 TIMES U2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012332,
      "CUNEIFORM SIGN UR2 TIMES U2 PLUS ASH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012333,
      "CUNEIFORM SIGN UR2 TIMES U2 PLUS BI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012334,
      "CUNEIFORM SIGN UR4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012335,
      "CUNEIFORM SIGN URI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012336,
      "CUNEIFORM SIGN URI3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012337,
      "CUNEIFORM SIGN URU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012338,
      "CUNEIFORM SIGN URU TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012339,
      "CUNEIFORM SIGN URU TIMES ASHGAB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001233A,
      "CUNEIFORM SIGN URU TIMES BAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001233B,
      "CUNEIFORM SIGN URU TIMES DUN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001233C,
      "CUNEIFORM SIGN URU TIMES GA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001233D,
      "CUNEIFORM SIGN URU TIMES GAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001233E,
      "CUNEIFORM SIGN URU TIMES GAN2 TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001233F,
      "CUNEIFORM SIGN URU TIMES GAR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012340,
      "CUNEIFORM SIGN URU TIMES GU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012341,
      "CUNEIFORM SIGN URU TIMES HA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012342,
      "CUNEIFORM SIGN URU TIMES IGI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012343,
      "CUNEIFORM SIGN URU TIMES IM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012344,
      "CUNEIFORM SIGN URU TIMES ISH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012345,
      "CUNEIFORM SIGN URU TIMES KI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012346,
      "CUNEIFORM SIGN URU TIMES LUM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012347,
      "CUNEIFORM SIGN URU TIMES MIN",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012348,
      "CUNEIFORM SIGN URU TIMES PA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012349,
      "CUNEIFORM SIGN URU TIMES SHE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001234A,
      "CUNEIFORM SIGN URU TIMES SIG4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001234B,
      "CUNEIFORM SIGN URU TIMES TU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001234C,
      "CUNEIFORM SIGN URU TIMES U PLUS GUD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001234D,
      "CUNEIFORM SIGN URU TIMES UD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001234E,
      "CUNEIFORM SIGN URU TIMES URUDA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001234F,
      "CUNEIFORM SIGN URUDA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012350,
      "CUNEIFORM SIGN URUDA TIMES U",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012351,
      "CUNEIFORM SIGN USH",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012352,
      "CUNEIFORM SIGN USH TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012353,
      "CUNEIFORM SIGN USH TIMES KU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012354,
      "CUNEIFORM SIGN USH TIMES KUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012355,
      "CUNEIFORM SIGN USH TIMES TAK4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012356,
      "CUNEIFORM SIGN USHX",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012357,
      "CUNEIFORM SIGN USH2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012358,
      "CUNEIFORM SIGN USHUMX",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012359,
      "CUNEIFORM SIGN UTUKI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001235A,
      "CUNEIFORM SIGN UZ3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001235B,
      "CUNEIFORM SIGN UZ3 TIMES KASKAL",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001235C,
      "CUNEIFORM SIGN UZU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001235D,
      "CUNEIFORM SIGN ZA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001235E,
      "CUNEIFORM SIGN ZA TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001235F,
      "CUNEIFORM SIGN ZA SQUARED TIMES KUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012360,
      "CUNEIFORM SIGN ZAG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012361,
      "CUNEIFORM SIGN ZAMX",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012362,
      "CUNEIFORM SIGN ZE2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012363,
      "CUNEIFORM SIGN ZI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012364,
      "CUNEIFORM SIGN ZI OVER ZI",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012365,
      "CUNEIFORM SIGN ZI3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012366,
      "CUNEIFORM SIGN ZIB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012367,
      "CUNEIFORM SIGN ZIB KABA TENU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012368,
      "CUNEIFORM SIGN ZIG",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012369,
      "CUNEIFORM SIGN ZIZ2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001236A,
      "CUNEIFORM SIGN ZU",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001236B,
      "CUNEIFORM SIGN ZU5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001236C,
      "CUNEIFORM SIGN ZU5 TIMES A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001236D,
      "CUNEIFORM SIGN ZUBUR",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001236E,
      "CUNEIFORM SIGN ZUM",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012400,
      "CUNEIFORM NUMERIC SIGN TWO ASH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012401,
      "CUNEIFORM NUMERIC SIGN THREE ASH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012402,
      "CUNEIFORM NUMERIC SIGN FOUR ASH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012403,
      "CUNEIFORM NUMERIC SIGN FIVE ASH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012404,
      "CUNEIFORM NUMERIC SIGN SIX ASH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012405,
      "CUNEIFORM NUMERIC SIGN SEVEN ASH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012406,
      "CUNEIFORM NUMERIC SIGN EIGHT ASH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012407,
      "CUNEIFORM NUMERIC SIGN NINE ASH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012408,
      "CUNEIFORM NUMERIC SIGN THREE DISH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012409,
      "CUNEIFORM NUMERIC SIGN FOUR DISH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001240A,
      "CUNEIFORM NUMERIC SIGN FIVE DISH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001240B,
      "CUNEIFORM NUMERIC SIGN SIX DISH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001240C,
      "CUNEIFORM NUMERIC SIGN SEVEN DISH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001240D,
      "CUNEIFORM NUMERIC SIGN EIGHT DISH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001240E,
      "CUNEIFORM NUMERIC SIGN NINE DISH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001240F,
      "CUNEIFORM NUMERIC SIGN FOUR U",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012410,
      "CUNEIFORM NUMERIC SIGN FIVE U",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012411,
      "CUNEIFORM NUMERIC SIGN SIX U",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012412,
      "CUNEIFORM NUMERIC SIGN SEVEN U",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012413,
      "CUNEIFORM NUMERIC SIGN EIGHT U",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012414,
      "CUNEIFORM NUMERIC SIGN NINE U",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012415,
      "CUNEIFORM NUMERIC SIGN ONE GESH2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012416,
      "CUNEIFORM NUMERIC SIGN TWO GESH2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012417,
      "CUNEIFORM NUMERIC SIGN THREE GESH2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012418,
      "CUNEIFORM NUMERIC SIGN FOUR GESH2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012419,
      "CUNEIFORM NUMERIC SIGN FIVE GESH2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001241A,
      "CUNEIFORM NUMERIC SIGN SIX GESH2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001241B,
      "CUNEIFORM NUMERIC SIGN SEVEN GESH2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001241C,
      "CUNEIFORM NUMERIC SIGN EIGHT GESH2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001241D,
      "CUNEIFORM NUMERIC SIGN NINE GESH2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001241E,
      "CUNEIFORM NUMERIC SIGN ONE GESHU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001241F,
      "CUNEIFORM NUMERIC SIGN TWO GESHU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012420,
      "CUNEIFORM NUMERIC SIGN THREE GESHU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012421,
      "CUNEIFORM NUMERIC SIGN FOUR GESHU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012422,
      "CUNEIFORM NUMERIC SIGN FIVE GESHU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012423,
      "CUNEIFORM NUMERIC SIGN TWO SHAR2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012424,
      "CUNEIFORM NUMERIC SIGN THREE SHAR2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012425,
      "CUNEIFORM NUMERIC SIGN THREE SHAR2 VARIANT FORM",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012426,
      "CUNEIFORM NUMERIC SIGN FOUR SHAR2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012427,
      "CUNEIFORM NUMERIC SIGN FIVE SHAR2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012428,
      "CUNEIFORM NUMERIC SIGN SIX SHAR2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012429,
      "CUNEIFORM NUMERIC SIGN SEVEN SHAR2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001242A,
      "CUNEIFORM NUMERIC SIGN EIGHT SHAR2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001242B,
      "CUNEIFORM NUMERIC SIGN NINE SHAR2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001242C,
      "CUNEIFORM NUMERIC SIGN ONE SHARU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001242D,
      "CUNEIFORM NUMERIC SIGN TWO SHARU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001242E,
      "CUNEIFORM NUMERIC SIGN THREE SHARU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001242F,
      "CUNEIFORM NUMERIC SIGN THREE SHARU VARIANT FORM",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012430,
      "CUNEIFORM NUMERIC SIGN FOUR SHARU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012431,
      "CUNEIFORM NUMERIC SIGN FIVE SHARU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012432,
      "CUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS DISH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012433,
      "CUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS MIN",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012434,
      "CUNEIFORM NUMERIC SIGN ONE BURU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012435,
      "CUNEIFORM NUMERIC SIGN TWO BURU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012436,
      "CUNEIFORM NUMERIC SIGN THREE BURU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012437,
      "CUNEIFORM NUMERIC SIGN THREE BURU VARIANT FORM",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012438,
      "CUNEIFORM NUMERIC SIGN FOUR BURU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012439,
      "CUNEIFORM NUMERIC SIGN FIVE BURU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001243A,
      "CUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH16",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001243B,
      "CUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH21",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001243C,
      "CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001243D,
      "CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU4",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001243E,
      "CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU A",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001243F,
      "CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU B",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012440,
      "CUNEIFORM NUMERIC SIGN SIX VARIANT FORM ASH9",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012441,
      "CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN3",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012442,
      "CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN A",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012443,
      "CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN B",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012444,
      "CUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012445,
      "CUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSU3",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012446,
      "CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012447,
      "CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU3",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012448,
      "CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU4",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012449,
      "CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU A",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001244A,
      "CUNEIFORM NUMERIC SIGN TWO ASH TENU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001244B,
      "CUNEIFORM NUMERIC SIGN THREE ASH TENU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001244C,
      "CUNEIFORM NUMERIC SIGN FOUR ASH TENU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001244D,
      "CUNEIFORM NUMERIC SIGN FIVE ASH TENU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001244E,
      "CUNEIFORM NUMERIC SIGN SIX ASH TENU",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001244F,
      "CUNEIFORM NUMERIC SIGN ONE BAN2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012450,
      "CUNEIFORM NUMERIC SIGN TWO BAN2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012451,
      "CUNEIFORM NUMERIC SIGN THREE BAN2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012452,
      "CUNEIFORM NUMERIC SIGN FOUR BAN2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012453,
      "CUNEIFORM NUMERIC SIGN FOUR BAN2 VARIANT FORM",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012454,
      "CUNEIFORM NUMERIC SIGN FIVE BAN2",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012455,
      "CUNEIFORM NUMERIC SIGN FIVE BAN2 VARIANT FORM",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012456,
      "CUNEIFORM NUMERIC SIGN NIGIDAMIN",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012457,
      "CUNEIFORM NUMERIC SIGN NIGIDAESH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012458,
      "CUNEIFORM NUMERIC SIGN ONE ESHE3",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012459,
      "CUNEIFORM NUMERIC SIGN TWO ESHE3",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001245A,
      "CUNEIFORM NUMERIC SIGN ONE THIRD DISH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001245B,
      "CUNEIFORM NUMERIC SIGN TWO THIRDS DISH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001245C,
      "CUNEIFORM NUMERIC SIGN FIVE SIXTHS DISH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001245D,
      "CUNEIFORM NUMERIC SIGN ONE THIRD VARIANT FORM A",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001245E,
      "CUNEIFORM NUMERIC SIGN TWO THIRDS VARIANT FORM A",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001245F,
      "CUNEIFORM NUMERIC SIGN ONE EIGHTH ASH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012460,
      "CUNEIFORM NUMERIC SIGN ONE QUARTER ASH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012461,
      "CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE SIXTH",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012462,
      "CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTER",
      0x21, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012470,
      "CUNEIFORM PUNCTUATION SIGN OLD ASSYRIAN WORD DIVIDER",
      0x36, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012471,
      "CUNEIFORM PUNCTUATION SIGN VERTICAL COLON",
      0x36, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012472,
      "CUNEIFORM PUNCTUATION SIGN DIAGONAL COLON",
      0x36, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x00012473,
      "CUNEIFORM PUNCTUATION SIGN DIAGONAL TRICOLON",
      0x36, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D000,
      "BYZANTINE MUSICAL SYMBOL PSILI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D001,
      "BYZANTINE MUSICAL SYMBOL DASEIA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D002,
      "BYZANTINE MUSICAL SYMBOL PERISPOMENI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D003,
      "BYZANTINE MUSICAL SYMBOL OXEIA EKFONITIKON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D004,
      "BYZANTINE MUSICAL SYMBOL OXEIA DIPLI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D005,
      "BYZANTINE MUSICAL SYMBOL VAREIA EKFONITIKON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D006,
      "BYZANTINE MUSICAL SYMBOL VAREIA DIPLI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D007,
      "BYZANTINE MUSICAL SYMBOL KATHISTI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D008,
      "BYZANTINE MUSICAL SYMBOL SYRMATIKI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D009,
      "BYZANTINE MUSICAL SYMBOL PARAKLITIKI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D00A,
      "BYZANTINE MUSICAL SYMBOL YPOKRISIS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D00B,
      "BYZANTINE MUSICAL SYMBOL YPOKRISIS DIPLI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D00C,
      "BYZANTINE MUSICAL SYMBOL KREMASTI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D00D,
      "BYZANTINE MUSICAL SYMBOL APESO EKFONITIKON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D00E,
      "BYZANTINE MUSICAL SYMBOL EXO EKFONITIKON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D00F,
      "BYZANTINE MUSICAL SYMBOL TELEIA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D010,
      "BYZANTINE MUSICAL SYMBOL KENTIMATA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D011,
      "BYZANTINE MUSICAL SYMBOL APOSTROFOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D012,
      "BYZANTINE MUSICAL SYMBOL APOSTROFOS DIPLI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D013,
      "BYZANTINE MUSICAL SYMBOL SYNEVMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D014,
      "BYZANTINE MUSICAL SYMBOL THITA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D015,
      "BYZANTINE MUSICAL SYMBOL OLIGON ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D016,
      "BYZANTINE MUSICAL SYMBOL GORGON ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D017,
      "BYZANTINE MUSICAL SYMBOL PSILON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D018,
      "BYZANTINE MUSICAL SYMBOL CHAMILON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D019,
      "BYZANTINE MUSICAL SYMBOL VATHY",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D01A,
      "BYZANTINE MUSICAL SYMBOL ISON ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D01B,
      "BYZANTINE MUSICAL SYMBOL KENTIMA ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D01C,
      "BYZANTINE MUSICAL SYMBOL KENTIMATA ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D01D,
      "BYZANTINE MUSICAL SYMBOL SAXIMATA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D01E,
      "BYZANTINE MUSICAL SYMBOL PARICHON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D01F,
      "BYZANTINE MUSICAL SYMBOL STAVROS APODEXIA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D020,
      "BYZANTINE MUSICAL SYMBOL OXEIAI ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D021,
      "BYZANTINE MUSICAL SYMBOL VAREIAI ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D022,
      "BYZANTINE MUSICAL SYMBOL APODERMA ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D023,
      "BYZANTINE MUSICAL SYMBOL APOTHEMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D024,
      "BYZANTINE MUSICAL SYMBOL KLASMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D025,
      "BYZANTINE MUSICAL SYMBOL REVMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D026,
      "BYZANTINE MUSICAL SYMBOL PIASMA ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D027,
      "BYZANTINE MUSICAL SYMBOL TINAGMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D028,
      "BYZANTINE MUSICAL SYMBOL ANATRICHISMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D029,
      "BYZANTINE MUSICAL SYMBOL SEISMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D02A,
      "BYZANTINE MUSICAL SYMBOL SYNAGMA ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D02B,
      "BYZANTINE MUSICAL SYMBOL SYNAGMA META STAVROU",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D02C,
      "BYZANTINE MUSICAL SYMBOL OYRANISMA ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D02D,
      "BYZANTINE MUSICAL SYMBOL THEMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D02E,
      "BYZANTINE MUSICAL SYMBOL LEMOI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D02F,
      "BYZANTINE MUSICAL SYMBOL DYO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D030,
      "BYZANTINE MUSICAL SYMBOL TRIA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D031,
      "BYZANTINE MUSICAL SYMBOL TESSERA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D032,
      "BYZANTINE MUSICAL SYMBOL KRATIMATA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D033,
      "BYZANTINE MUSICAL SYMBOL APESO EXO NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D034,
      "BYZANTINE MUSICAL SYMBOL FTHORA ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D035,
      "BYZANTINE MUSICAL SYMBOL IMIFTHORA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D036,
      "BYZANTINE MUSICAL SYMBOL TROMIKON ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D037,
      "BYZANTINE MUSICAL SYMBOL KATAVA TROMIKON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D038,
      "BYZANTINE MUSICAL SYMBOL PELASTON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D039,
      "BYZANTINE MUSICAL SYMBOL PSIFISTON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D03A,
      "BYZANTINE MUSICAL SYMBOL KONTEVMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D03B,
      "BYZANTINE MUSICAL SYMBOL CHOREVMA ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D03C,
      "BYZANTINE MUSICAL SYMBOL RAPISMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D03D,
      "BYZANTINE MUSICAL SYMBOL PARAKALESMA ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D03E,
      "BYZANTINE MUSICAL SYMBOL PARAKLITIKI ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D03F,
      "BYZANTINE MUSICAL SYMBOL ICHADIN",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D040,
      "BYZANTINE MUSICAL SYMBOL NANA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D041,
      "BYZANTINE MUSICAL SYMBOL PETASMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D042,
      "BYZANTINE MUSICAL SYMBOL KONTEVMA ALLO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D043,
      "BYZANTINE MUSICAL SYMBOL TROMIKON ALLO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D044,
      "BYZANTINE MUSICAL SYMBOL STRAGGISMATA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D045,
      "BYZANTINE MUSICAL SYMBOL GRONTHISMATA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D046,
      "BYZANTINE MUSICAL SYMBOL ISON NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D047,
      "BYZANTINE MUSICAL SYMBOL OLIGON NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D048,
      "BYZANTINE MUSICAL SYMBOL OXEIA NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D049,
      "BYZANTINE MUSICAL SYMBOL PETASTI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D04A,
      "BYZANTINE MUSICAL SYMBOL KOUFISMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D04B,
      "BYZANTINE MUSICAL SYMBOL PETASTOKOUFISMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D04C,
      "BYZANTINE MUSICAL SYMBOL KRATIMOKOUFISMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D04D,
      "BYZANTINE MUSICAL SYMBOL PELASTON NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D04E,
      "BYZANTINE MUSICAL SYMBOL KENTIMATA NEO ANO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D04F,
      "BYZANTINE MUSICAL SYMBOL KENTIMA NEO ANO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D050,
      "BYZANTINE MUSICAL SYMBOL YPSILI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D051,
      "BYZANTINE MUSICAL SYMBOL APOSTROFOS NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D052,
      "BYZANTINE MUSICAL SYMBOL APOSTROFOI SYNDESMOS NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D053,
      "BYZANTINE MUSICAL SYMBOL YPORROI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D054,
      "BYZANTINE MUSICAL SYMBOL KRATIMOYPORROON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D055,
      "BYZANTINE MUSICAL SYMBOL ELAFRON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D056,
      "BYZANTINE MUSICAL SYMBOL CHAMILI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D057,
      "BYZANTINE MUSICAL SYMBOL MIKRON ISON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D058,
      "BYZANTINE MUSICAL SYMBOL VAREIA NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D059,
      "BYZANTINE MUSICAL SYMBOL PIASMA NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D05A,
      "BYZANTINE MUSICAL SYMBOL PSIFISTON NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D05B,
      "BYZANTINE MUSICAL SYMBOL OMALON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D05C,
      "BYZANTINE MUSICAL SYMBOL ANTIKENOMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D05D,
      "BYZANTINE MUSICAL SYMBOL LYGISMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D05E,
      "BYZANTINE MUSICAL SYMBOL PARAKLITIKI NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D05F,
      "BYZANTINE MUSICAL SYMBOL PARAKALESMA NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D060,
      "BYZANTINE MUSICAL SYMBOL ETERON PARAKALESMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D061,
      "BYZANTINE MUSICAL SYMBOL KYLISMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D062,
      "BYZANTINE MUSICAL SYMBOL ANTIKENOKYLISMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D063,
      "BYZANTINE MUSICAL SYMBOL TROMIKON NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D064,
      "BYZANTINE MUSICAL SYMBOL EKSTREPTON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D065,
      "BYZANTINE MUSICAL SYMBOL SYNAGMA NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D066,
      "BYZANTINE MUSICAL SYMBOL SYRMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D067,
      "BYZANTINE MUSICAL SYMBOL CHOREVMA NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D068,
      "BYZANTINE MUSICAL SYMBOL EPEGERMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D069,
      "BYZANTINE MUSICAL SYMBOL SEISMA NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D06A,
      "BYZANTINE MUSICAL SYMBOL XIRON KLASMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D06B,
      "BYZANTINE MUSICAL SYMBOL TROMIKOPSIFISTON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D06C,
      "BYZANTINE MUSICAL SYMBOL PSIFISTOLYGISMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D06D,
      "BYZANTINE MUSICAL SYMBOL TROMIKOLYGISMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D06E,
      "BYZANTINE MUSICAL SYMBOL TROMIKOPARAKALESMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D06F,
      "BYZANTINE MUSICAL SYMBOL PSIFISTOPARAKALESMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D070,
      "BYZANTINE MUSICAL SYMBOL TROMIKOSYNAGMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D071,
      "BYZANTINE MUSICAL SYMBOL PSIFISTOSYNAGMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D072,
      "BYZANTINE MUSICAL SYMBOL GORGOSYNTHETON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D073,
      "BYZANTINE MUSICAL SYMBOL ARGOSYNTHETON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D074,
      "BYZANTINE MUSICAL SYMBOL ETERON ARGOSYNTHETON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D075,
      "BYZANTINE MUSICAL SYMBOL OYRANISMA NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D076,
      "BYZANTINE MUSICAL SYMBOL THEMATISMOS ESO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D077,
      "BYZANTINE MUSICAL SYMBOL THEMATISMOS EXO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D078,
      "BYZANTINE MUSICAL SYMBOL THEMA APLOUN",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D079,
      "BYZANTINE MUSICAL SYMBOL THES KAI APOTHES",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D07A,
      "BYZANTINE MUSICAL SYMBOL KATAVASMA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D07B,
      "BYZANTINE MUSICAL SYMBOL ENDOFONON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D07C,
      "BYZANTINE MUSICAL SYMBOL YFEN KATO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D07D,
      "BYZANTINE MUSICAL SYMBOL YFEN ANO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D07E,
      "BYZANTINE MUSICAL SYMBOL STAVROS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D07F,
      "BYZANTINE MUSICAL SYMBOL KLASMA ANO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D080,
      "BYZANTINE MUSICAL SYMBOL DIPLI ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D081,
      "BYZANTINE MUSICAL SYMBOL KRATIMA ARCHAION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D082,
      "BYZANTINE MUSICAL SYMBOL KRATIMA ALLO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D083,
      "BYZANTINE MUSICAL SYMBOL KRATIMA NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D084,
      "BYZANTINE MUSICAL SYMBOL APODERMA NEO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D085,
      "BYZANTINE MUSICAL SYMBOL APLI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D086,
      "BYZANTINE MUSICAL SYMBOL DIPLI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D087,
      "BYZANTINE MUSICAL SYMBOL TRIPLI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D088,
      "BYZANTINE MUSICAL SYMBOL TETRAPLI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D089,
      "BYZANTINE MUSICAL SYMBOL KORONIS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D08A,
      "BYZANTINE MUSICAL SYMBOL LEIMMA ENOS CHRONOU",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D08B,
      "BYZANTINE MUSICAL SYMBOL LEIMMA DYO CHRONON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D08C,
      "BYZANTINE MUSICAL SYMBOL LEIMMA TRION CHRONON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D08D,
      "BYZANTINE MUSICAL SYMBOL LEIMMA TESSARON CHRONON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D08E,
      "BYZANTINE MUSICAL SYMBOL LEIMMA IMISEOS CHRONOU",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D08F,
      "BYZANTINE MUSICAL SYMBOL GORGON NEO ANO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D090,
      "BYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON ARISTERA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D091,
      "BYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON DEXIA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D092,
      "BYZANTINE MUSICAL SYMBOL DIGORGON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D093,
      "BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA KATO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D094,
      "BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA ANO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D095,
      "BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON DEXIA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D096,
      "BYZANTINE MUSICAL SYMBOL TRIGORGON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D097,
      "BYZANTINE MUSICAL SYMBOL ARGON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D098,
      "BYZANTINE MUSICAL SYMBOL IMIDIARGON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D099,
      "BYZANTINE MUSICAL SYMBOL DIARGON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D09A,
      "BYZANTINE MUSICAL SYMBOL AGOGI POLI ARGI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D09B,
      "BYZANTINE MUSICAL SYMBOL AGOGI ARGOTERI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D09C,
      "BYZANTINE MUSICAL SYMBOL AGOGI ARGI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D09D,
      "BYZANTINE MUSICAL SYMBOL AGOGI METRIA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D09E,
      "BYZANTINE MUSICAL SYMBOL AGOGI MESI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D09F,
      "BYZANTINE MUSICAL SYMBOL AGOGI GORGI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0A0,
      "BYZANTINE MUSICAL SYMBOL AGOGI GORGOTERI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0A1,
      "BYZANTINE MUSICAL SYMBOL AGOGI POLI GORGI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0A2,
      "BYZANTINE MUSICAL SYMBOL MARTYRIA PROTOS ICHOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0A3,
      "BYZANTINE MUSICAL SYMBOL MARTYRIA ALLI PROTOS ICHOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0A4,
      "BYZANTINE MUSICAL SYMBOL MARTYRIA DEYTEROS ICHOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0A5,
      "BYZANTINE MUSICAL SYMBOL MARTYRIA ALLI DEYTEROS ICHOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0A6,
      "BYZANTINE MUSICAL SYMBOL MARTYRIA TRITOS ICHOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0A7,
      "BYZANTINE MUSICAL SYMBOL MARTYRIA TRIFONIAS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0A8,
      "BYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS ICHOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0A9,
      "BYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS LEGETOS ICHOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0AA,
      "BYZANTINE MUSICAL SYMBOL MARTYRIA LEGETOS ICHOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0AB,
      "BYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS ICHOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0AC,
      "BYZANTINE MUSICAL SYMBOL ISAKIA TELOUS ICHIMATOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0AD,
      "BYZANTINE MUSICAL SYMBOL APOSTROFOI TELOUS ICHIMATOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0AE,
      "BYZANTINE MUSICAL SYMBOL FANEROSIS TETRAFONIAS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0AF,
      "BYZANTINE MUSICAL SYMBOL FANEROSIS MONOFONIAS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0B0,
      "BYZANTINE MUSICAL SYMBOL FANEROSIS DIFONIAS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0B1,
      "BYZANTINE MUSICAL SYMBOL MARTYRIA VARYS ICHOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0B2,
      "BYZANTINE MUSICAL SYMBOL MARTYRIA PROTOVARYS ICHOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0B3,
      "BYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS TETARTOS ICHOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0B4,
      "BYZANTINE MUSICAL SYMBOL GORTHMIKON N APLOUN",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0B5,
      "BYZANTINE MUSICAL SYMBOL GORTHMIKON N DIPLOUN",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0B6,
      "BYZANTINE MUSICAL SYMBOL ENARXIS KAI FTHORA VOU",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0B7,
      "BYZANTINE MUSICAL SYMBOL IMIFONON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0B8,
      "BYZANTINE MUSICAL SYMBOL IMIFTHORON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0B9,
      "BYZANTINE MUSICAL SYMBOL FTHORA ARCHAION DEYTEROU ICHOU",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0BA,
      "BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI PA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0BB,
      "BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NANA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0BC,
      "BYZANTINE MUSICAL SYMBOL FTHORA NAOS ICHOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0BD,
      "BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI DI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0BE,
      "BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON DIATONON DI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0BF,
      "BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI KE",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0C0,
      "BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI ZO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0C1,
      "BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI KATO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0C2,
      "BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI ANO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0C3,
      "BYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA DIFONIAS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0C4,
      "BYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA MONOFONIAS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0C5,
      "BYZANTINE MUSICAL SYMBOL FHTORA SKLIRON CHROMA VASIS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0C6,
      "BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA SYNAFI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0C7,
      "BYZANTINE MUSICAL SYMBOL FTHORA NENANO",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0C8,
      "BYZANTINE MUSICAL SYMBOL CHROA ZYGOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0C9,
      "BYZANTINE MUSICAL SYMBOL CHROA KLITON",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0CA,
      "BYZANTINE MUSICAL SYMBOL CHROA SPATHI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0CB,
      "BYZANTINE MUSICAL SYMBOL FTHORA I YFESIS TETARTIMORION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0CC,
      "BYZANTINE MUSICAL SYMBOL FTHORA ENARMONIOS ANTIFONIA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0CD,
      "BYZANTINE MUSICAL SYMBOL YFESIS TRITIMORION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0CE,
      "BYZANTINE MUSICAL SYMBOL DIESIS TRITIMORION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0CF,
      "BYZANTINE MUSICAL SYMBOL DIESIS TETARTIMORION",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0D0,
      "BYZANTINE MUSICAL SYMBOL DIESIS APLI DYO DODEKATA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0D1,
      "BYZANTINE MUSICAL SYMBOL DIESIS MONOGRAMMOS TESSERA DODEKATA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0D2,
      "BYZANTINE MUSICAL SYMBOL DIESIS DIGRAMMOS EX DODEKATA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0D3,
      "BYZANTINE MUSICAL SYMBOL DIESIS TRIGRAMMOS OKTO DODEKATA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0D4,
      "BYZANTINE MUSICAL SYMBOL YFESIS APLI DYO DODEKATA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0D5,
      "BYZANTINE MUSICAL SYMBOL YFESIS MONOGRAMMOS TESSERA DODEKATA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0D6,
      "BYZANTINE MUSICAL SYMBOL YFESIS DIGRAMMOS EX DODEKATA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0D7,
      "BYZANTINE MUSICAL SYMBOL YFESIS TRIGRAMMOS OKTO DODEKATA",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0D8,
      "BYZANTINE MUSICAL SYMBOL GENIKI DIESIS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0D9,
      "BYZANTINE MUSICAL SYMBOL GENIKI YFESIS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0DA,
      "BYZANTINE MUSICAL SYMBOL DIASTOLI APLI MIKRI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0DB,
      "BYZANTINE MUSICAL SYMBOL DIASTOLI APLI MEGALI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0DC,
      "BYZANTINE MUSICAL SYMBOL DIASTOLI DIPLI",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0DD,
      "BYZANTINE MUSICAL SYMBOL DIASTOLI THESEOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0DE,
      "BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0DF,
      "BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS DISIMOU",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0001D0E0,
      "BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS TRISIMOU",
      0x43, 0, 0x00, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000