// ---------------------------------------------------------------------------
// - Literal.hpp                                                             -
// - standard object library - literal abstract class definition             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_LITERAL_HPP
#define  AFNIX_LITERAL_HPP

#ifndef  AFNIX_SERIAL_HPP
#include "Serial.hpp"
#endif

namespace afnix {

  /// The Literal class is an abstract class which is used by object which
  /// have a constant literal representation. such object includes boolean,
  /// integer, relatif, real, character, string and regex. The Literal class 
  /// defines the tostring and toliteral methods as representation methods.
  /// @author amaury darsch

  class Literal : public Serial {
  public:
    /// @return a literal representation of this object
    virtual class String toliteral (void) const =0;

    /// @return a printable representation of this literal
    virtual class String tostring (void) const =0;

  public:
    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;

    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);
  };
}

#endif
