<?xml version="1.0"?>

<!-- ====================================================================== -->
<!-- = xref.xsl                                                           = -->
<!-- = afnix documentation xslt with xhtml output : cross references      = -->
<!-- ====================================================================== -->
<!-- = This  program  is  free  software; you  can redistribute it and/or = -->
<!-- = modify it provided that this copyright notice is kept intact.      = -->
<!-- = This program is distributed in the hope that it will be useful but = -->
<!-- = without  any  warranty;  without  even  the  implied  warranty  of = -->
<!-- = merchantability or fitness for  a  particular purpose. In no event = -->
<!-- = shall  the  copyright  holder be liable for any  direct, indirect, = -->
<!-- = incidental  or special  damages arising  in any way out of the use = -->
<!-- = of this software.                                                  = -->
<!-- ====================================================================== -->
<!-- = copyright (c) 2005-2007 - amaury darsch                            = -->
<!-- ====================================================================== -->

<xsl:stylesheet version="1.0" 
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns="http://www.w3.org/1999/xhtml">

 <!-- body with cross references template -->
 <xsl:template name="body.xref">
  <table>
   <colgroup id="xref">
     <col width="25%"/>
     <col width="75%"/>
   </colgroup>
   <tbody>
    <tr valign="top">
     <td id="xref">
       <xsl:for-each select="//title|//name">
         <xsl:call-template name="xref.toc"/>  
       </xsl:for-each>
     </td>
     <td>
       <!-- create the main document -->
       <xsl:apply-templates/>
     </td>
    </tr>
   </tbody>
  </table>
  <!-- footer -->
  <hr/>
  <table>
    <tr>
      <td align="left">
        <a  href="../index.htm"><img src="../img/hlp.png"
           width="16" height="16" alt="AFNIX information"/></a>

        <a  href="mailto:support@afnix.org"><img src="../img/mai.png"
	   width="16" height="16" alt="AFNIX support"/></a>
      </td>
      <td class="footer" align="right">
          Copyright &#169; 2007
          <a href="http://www.darsch.org">Amaury Darsch</a>
      </td>
    </tr>
  </table>
 </xsl:template>

 <!-- xref.toc template-->
 <xsl:template name="xref.toc">
  <xsl:choose>
   <xsl:when test="local-name(..)='chapter'">
     <p/>
     <hr/>
     <div class="chapter">
       <a class="chapter" href="#{generate-id(..)}">
         <xsl:value-of select="."/>
       </a>
     </div>
     <hr/>
   </xsl:when>
   <xsl:when test="local-name(..)='appendix'">
     <p/>
     <hr/>
     <div class="appendix">
       <a class="appendix" href="#{generate-id(..)}">
         <xsl:value-of select="."/>
       </a>
     </div>
     <hr/>
   </xsl:when>
   <xsl:when test="local-name(..)='section'">
     <h1 class="xref">
       <xsl:text>&#9724; </xsl:text>
       <a href="#{generate-id(..)}">
         <xsl:value-of select="."/>
       </a>
     </h1>
   </xsl:when>
   <xsl:when test="local-name(..)='keyword'">
     <h1 class="xref">
       <xsl:text>&#9724; </xsl:text>
       <a href="#{generate-id(..)}">
         <xsl:value-of select="."/>
       </a>
     </h1>
   </xsl:when>
   <xsl:when test="local-name(..)='object'">
     <h1 class="xref">
       <xsl:text>&#9724; </xsl:text>
       <a href="#{generate-id(..)}">
         <xsl:value-of select="."/>
       </a>
     </h1>
   </xsl:when>
   <xsl:when test="local-name(..)='control'">
     <h1 class="xref">
       <xsl:text>&#9724; </xsl:text>
       <a href="#{generate-id(..)}">
         <xsl:value-of select="."/>
       </a>
     </h1>
   </xsl:when>
   <xsl:when test="local-name(..)='client'">
     <p/>
     <hr/>
     <div class="elem">
       <a class="client" href="#{generate-id(..)}">
         <xsl:value-of select="."/>
       </a>
     </div>
     <hr/>
   </xsl:when>
   <xsl:when test="local-name(..)='remark'">
     <h1 class="xref">
       <xsl:text>&#9724; </xsl:text>
       <a href="#{generate-id(..)}">
         <xsl:value-of select="."/>
       </a>
     </h1>
   </xsl:when>
  </xsl:choose>
 </xsl:template>

</xsl:stylesheet>

