<?xml version="1.0"?>

<!-- ===================================================================== -->
<!-- = elem.xsl                                                          = -->
<!-- = afnix doumentation xslt with xhtml output : element templates     = -->
<!-- ===================================================================== -->
<!-- = This  program  is  free  software; you can redistribute it and/or = -->
<!-- = modify it provided that this copyright notice is kept intact.     = -->
<!-- = This program is distributed in the hope that it will be useful but= -->
<!-- = without  any  warranty; without  even  the  implied  warranty  of = -->
<!-- = merchantability or fitness for a  particular purpose. In no event = -->
<!-- = shall  the  copyright holder be liable for any  direct, indirect, = -->
<!-- = incidental  or special damages arising  in any way out of the use = -->
<!-- = of this software.                                                 = -->
<!-- ===================================================================== -->
<!-- = copyright (c) 2005-2007 - amaury darsch                           = -->
<!-- ===================================================================== -->

<xsl:stylesheet version="1.0" 
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns="http://www.w3.org/1999/xhtml">

 <!-- title template -->
 <xsl:template match="title">
  <xsl:choose>
   <xsl:when test="local-name(..)='remark'">
    <p id="{generate-id(..)}" class="elem">
      <xsl:apply-templates/>
    </p>
   </xsl:when>
   <xsl:when test="local-name(..)='chapter'">
    <hr/>
    <div id="{generate-id(..)}" class="chapter">
      <xsl:apply-templates/>
    </div>
    <hr/>
   </xsl:when>
   <xsl:when test="local-name(..)='appendix'">
    <div id="{generate-id(..)}" class="appendix">
      <xsl:apply-templates/>
    </div>
   </xsl:when>
   <xsl:when test="local-name(..)='section'">
    <div id="{generate-id(..)}" class="section">
      <xsl:apply-templates/>
    </div>
   </xsl:when>
   <xsl:when test="local-name(..)='subsect'">
    <p class="subsect">
      <xsl:apply-templates/>
    </p>
   </xsl:when>
  </xsl:choose>
 </xsl:template>

 <!-- name template -->
 <xsl:template match="name">
  <xsl:choose>
   <xsl:when test="local-name(..)='client'">
    <hr/>
    <div id="{generate-id(..)}" class="elem">
     <xsl:value-of select="."/>
     <xsl:text> [client]</xsl:text>
    </div>
    <hr/>
   </xsl:when>
   <xsl:when test="local-name(..)='opts'">
    <div class="elem">
     <xsl:value-of select="."/>
    </div>
   </xsl:when>
   <xsl:when test="local-name(..)='keyword'">
    <div id="{generate-id(..)}" class="elem">
      <xsl:value-of select="."/>
      <xsl:text> [reserved]</xsl:text>
    </div>
   </xsl:when>
   <xsl:when test="local-name(..)='control'">
    <div id="{generate-id(..)}" class="elem">
      <xsl:value-of select="."/>
      <xsl:text> [</xsl:text>
      <xsl:value-of select="../@nameset"/>
      <xsl:text>]</xsl:text>
    </div>
   </xsl:when>
   <xsl:when test="local-name(..)='object'">
    <p/>
    <div id="{generate-id(..)}" class="elem">
      <xsl:value-of select="."/>
      <xsl:if test="../@type">
        <xsl:text> [</xsl:text>
        <xsl:value-of select="../@type"/>
        <xsl:text>]</xsl:text>
      </xsl:if>
      <xsl:if test="../@nameset">
        <xsl:text> [</xsl:text>
        <xsl:value-of select="../@nameset"/>
        <xsl:text>]</xsl:text>
      </xsl:if>
    </div>
   </xsl:when>
   <xsl:when test="local-name(..)='inherit'">
    <div class="elem">
     <xsl:value-of select="."/>
    </div>
   </xsl:when>
   <xsl:when test="local-name(..)='ctor'">
    <div class="elem">
     <xsl:value-of select="."/>
    </div>
   </xsl:when>
   <xsl:when test="local-name(..)='constant'">
    <div class="elem">
     <xsl:value-of select="."/>
    </div>
   </xsl:when>
   <xsl:when test="local-name(..)='operator'">
    <div class="elem">
     <xsl:value-of select="."/>
    </div>
   </xsl:when>
   <xsl:when test="local-name(..)='method'">
    <div class="elem">
     <xsl:value-of select="."/>
    </div>
   </xsl:when>
  </xsl:choose>
 </xsl:template>

 <!-- function name template-->
 <xsl:template name="function.name">
  <div class="elem">
    <xsl:value-of select="name"/>
    <xsl:text> [</xsl:text>
    <xsl:value-of select="@nameset"/>
    <xsl:text>]</xsl:text>
  </div>
 </xsl:template>


 <!-- p template -->
 <xsl:template match="p">
  <xsl:choose>
   <xsl:when test="local-name(..)='client'">
    <p class="elem">Synopsis</p>
    <h1 class="text">
      <xsl:apply-templates/>
    </h1>
   </xsl:when>
   <xsl:when test="local-name(..)='remark'">
    <h1 class="text">
      <xsl:apply-templates/>
    </h1>
   </xsl:when>
   <xsl:when test="local-name(..)='keyword'">
    <p class="elem">Description</p>
    <h1 class="text">
      <xsl:apply-templates/>
    </h1>
   </xsl:when>
   <xsl:when test="local-name(..)='object'">
    <p class="elem">Description</p>
    <h1 class="text">
      <xsl:apply-templates/>
    </h1>
   </xsl:when>
   <xsl:otherwise>
    <p class="text">
      <xsl:apply-templates/>
    </p>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <!-- link template -->
 <xsl:template match="link">
  <a>
   <xsl:attribute name="href">
    <xsl:value-of select="@url"/>
   </xsl:attribute>
   <xsl:value-of select="."/>
  </a>
 </xsl:template>

 <!-- mail template -->
 <xsl:template match="mail">
  <a>
   <xsl:attribute name="href">
    <xsl:text>mailto:</xsl:text><xsl:value-of select="@address"/>
   </xsl:attribute>
   <xsl:value-of select="."/>
  </a>
 </xsl:template>

 <!-- product transformation template -->
 <xsl:template match="product">
  <i class="product"><xsl:value-of select="."/></i>
 </xsl:template>

 <!-- package transformation template -->
 <xsl:template match="package">
  <i class="package"><xsl:value-of select="."/></i>
 </xsl:template>

 <!-- command transformation template -->
 <xsl:template match="command">
  <tt class="command"><xsl:value-of select="."/></tt>
 </xsl:template>

 <!-- option transformation template -->
 <xsl:template match="option">
  <tt class="option"><xsl:value-of select="."/></tt>
 </xsl:template>

 <!-- file transformation template -->
 <xsl:template match="file">
  <tt class="file"><xsl:value-of select="."/></tt>
 </xsl:template>

 <!-- extn transformation template -->
 <xsl:template match="extn">
  <tt class="extn"><xsl:value-of select="."/></tt>
 </xsl:template>

 <!-- path transformation template -->
 <xsl:template match="path">
  <tt class="path"><xsl:value-of select="."/></tt>
 </xsl:template>

 <!-- code transformation template -->
 <xsl:template match="code">
  <tt class="code"><xsl:value-of select="."/></tt>
 </xsl:template>

 <!-- emphasis template -->
 <xsl:template match="em">
  <em><xsl:value-of select="."/></em>
 </xsl:template>

 <!-- newline template -->
 <xsl:template match="nl">
  <br/>
 </xsl:template>

 <!-- pred element -->
 <xsl:template match="pred">
  <p class="elem">Predicate</p>
  <h1 class="elem">
    <xsl:value-of select="."/>
  </h1>
 </xsl:template>
 
 <!-- retn element -->
 <xsl:template match="retn">
  <xsl:choose>
   <xsl:when test="local-name(..)='function'">
     <div class="text">
       <xsl:text>return: </xsl:text>
       <xsl:value-of select="."/>
     </div>
   </xsl:when>
   <xsl:otherwise>
     <p/>
     <div class="text">
       <xsl:text>return: </xsl:text>
       <xsl:value-of select="."/>
     </div>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <!-- args element -->
 <xsl:template match="args">
  <p/>
  <div class="text">
    <xsl:text>arguments: </xsl:text>
    <xsl:value-of select="."/>
  </div>
 </xsl:template>

</xsl:stylesheet>

