# ----------------------------------------------------------------------------
# - afnix-docs                                                               -
# - afnix documentation rule makefile configuration                          -
# ----------------------------------------------------------------------------
# - This program is  free software;  you can  redistribute it and/or  modify -
# - it provided that this copyright notice is kept intact.                   -
# -                                                                          -
# - This  program  is  distributed in the hope  that it  will be useful, but -
# - without  any   warranty;  without  even   the   implied    warranty   of -
# - merchantability  or fitness for a particular purpose. In not event shall -
# - the copyright holder be  liable for  any direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.      -
# ----------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                    -
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - documentation definitions                                                -
# ----------------------------------------------------------------------------

DOCETC		= $(DIRDOC)/etc
DOCDTD		= $(DIRDOC)/dtd
DOCXML		= $(DIRDOC)/xml

XSLHTM		= $(DIRDOC)/xsl/htm/axim.xsl
REFCSS		= $(DOCETC)/style.css
REFDTD		= $(DOCDTD)/axmxa.dtd

# ----------------------------------------------------------------------------
# - documentation control                                                    -
# ----------------------------------------------------------------------------

XLINT		= xmllint
XSLTP		= xsltproc
XLOPT		= --noout --noent --postvalid --xinclude --dtdvalid $(REFDTD)
XSOPT		= --xinclude --path $(DOCDTD)
XSPRM		=

# ----------------------------------------------------------------------------
# - documentation rules                                                      -
# ----------------------------------------------------------------------------

ifneq ($(MANUAL),)
doc: htm
.PHONY: doc

xlint:
	$(XLINT) $(XLOPT) $(MANUAL)

htm:
	@$(XSLTP) $(XSOPT) $(XSPRM) -o $(MANUAL:.xml=.htm) $(XSLHTM) $(MANUAL)
	@$(MKDIR) $(BLDDOC)
	@$(CP) $(REFCSS)           $(BLDDOC)
	@$(CP) $(MANUAL:.xml=.htm) $(BLDDOC)
endif

# ----------------------------------------------------------------------------
# - generic clean                                                            -
# ----------------------------------------------------------------------------

clean::
	@$(RM) *~ core *.core
.PHONY: clean
