/* Mailcap.h - Declarations for af's mailcap file handling.
   Copyright (C) 1997 Malc Arnold.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


/****************************************************************************/
/* RCS info */

#define	MAILCAPID	"$Id: mailcap.h,v 1.1 1997/11/16 00:40:56 malc Exp $"

/****************************************************************************/
/* The structure for storing a mailcap entry */

typedef struct mailcap {
	char *contype, *test;		/* MIME type and test command */
	char *view, *print, *edit;	/* View, print, and edit commands */
	char *compose, *typed;		/* Composition commands */
	char *desc, *file;		/* Description and file template */
	unsigned term : 1, page : 1;	/* Need a terminal or pager? */
	unsigned textual : 1;		/* Is this type textual? */
	struct mailcap *next;		/* The next mailcap */
} MAILCAP;

/****************************************************************************/
/* The structures for storing a mime.types entry */

typedef struct mime_type {
	char *contype;			/* The mime type */
	struct mime_type *next;		/* The next mime type */
} MIME_TYPE;

typedef struct mime_suffix {
	char *suffix;			/* The file suffix */
	MIME_TYPE *type;		/* The related mime type */
	struct mime_suffix *next;	/* The next file suffix */
} MIME_SUFFIX;

/****************************************************************************/
/* The structure for storing a mime.charsets entry */

typedef struct mime_charset {
	char *charset;			/* The mime charset */
	struct mime_charset *next;	/* The next charset */
} MIME_CHARSET;

/****************************************************************************/
/* The structure for storing sets of temporary files */

typedef struct mime_tempfiles {
	char **tfiles;			/* The temp files for a mailcap */
	struct mime_tempfiles *next;	/* The next set of temp files */
} MIME_TEMPFILES;

/****************************************************************************/
/* The commands we can run from a mailcap entry */

#define MCAP_TEST		0
#define MCAP_VIEW		1
#define MCAP_PRINT		2
#define MCAP_EDIT		3
#define MCAP_COMPOSE		4
#define MCAP_TYPED		5

/****************************************************************************/
/* The types of temporary file escapes we can have */

#define	TFILE_MESSAGE		0x1
#define TFILE_BODY_PARTS	0x2

/****************************************************************************/
