/* Caplist.h - The list of mailcap fields and their handlers for af.
   Copyright (C) 1997 Malc Arnold.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


/****************************************************************************/
/* RCS info */

#ifndef lint
static char *CaplistId = "$Id: caplist.h,v 1.1 1997/11/16 00:40:56 malc Exp $";
#endif /* ! lint */

/****************************************************************************/
/* The structure for storing a mailcap field */

typedef struct field {
	char *name;			/* The name of the field */
	int argument;			/* Does the field need an argument? */
	int (*handler)();		/* Function to handle the field */
} FIELD;

/****************************************************************************/
/* The functions used to handle mailcap fields */

static int mcap_test(), mcap_print(), mcap_edit();
static int mcap_compose(), mcap_typed(), mcap_desc();
static int mcap_file(), mcap_term(), mcap_page();
static int mcap_textual();

/****************************************************************************/
/* The list of fields and their handlers */

static FIELD mailcap_fields[] = {
	{ "compose", TRUE, mcap_compose },
	{ "composetyped", TRUE, mcap_typed },
	{ "copiousoutput", FALSE, mcap_page },
	{ "description", TRUE, mcap_desc },
	{ "edit", TRUE, mcap_edit },
	{ "nametemplate", TRUE, mcap_file },
	{ "needsterminal", FALSE, mcap_term },
	{ "print", TRUE, mcap_print },
	{ "test", TRUE, mcap_test },
	{ "textualnewlines", TRUE, mcap_textual },
	{ NULL, FALSE, NULL }
};

/****************************************************************************/
