(***********************************************************************)
(*                                                                     *)
(*                             Active-DVI                              *)
(*                                                                     *)
(*                   Projet Cristal, INRIA Rocquencourt                *)
(*                                                                     *)
(*  Copyright 2002 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the GNU Lesser General Public License.          *)
(*                                                                     *)
(*  Jun Furuse, Didier Rmy and Pierre Weis.                           *)
(*  Contributions by Roberto Di Cosmo, Didier Le Botlan,               *)
(*  Xavier Leroy, and Alan Schmitt.                                    *)
(*                                                                     *)
(*  Based on Mldvi by Alexandre Miquel.                                *)
(***********************************************************************)

(* $Id: driver.mli,v 1.1 2007/01/18 14:14:35 rousse Exp $ *)

open Cdvi;;

exception Pause;;
exception Wait of float;;
type cooked_dvi;;
val with_active : bool -> ('a -> 'b) -> 'a -> 'b;;
val toggle_active : unit -> unit;;
val cook_dvi : Cdvi.t -> cooked_dvi;;
val render_step :
      cooked_dvi -> int -> ?trans:Transitions.direction -> 
      ?chst:(known_status -> known_status) -> float -> int -> int ->
      (unit -> bool);;
val unfreeze_fonts : cooked_dvi -> unit;;
val unfreeze_glyphs : cooked_dvi -> float -> unit;;
val scan_special_pages : cooked_dvi -> int -> unit;;
val scan_find_location : 
    cooked_dvi -> int -> (int * string option) -> int;;
val scan_find_anchor_location : 
    cooked_dvi -> int -> string -> (int * string option) option;;
val clear_symbols : unit -> unit;;
