/* 
   Project: UL

   Copyright (C) 2007 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef _ULEXPORTCONTROLLER_
#define _ULEXPORTCONTROLLER_
#include <AppKit/AppKit.h>
#include <AdunKernel/AdunKernel.h>
#include <AdunKernel/AdunSimulationData.h>
#include "ULFramework/ULIOManager.h"
#include "ULFramework/ULTemplate.h"
#include "ULFramework/ULFrameworkFunctions.h"
#include "ULExportPanel.h"
#include "ULPasteboard.h"

/**
Description forthcoming.
\ingroup interface
*/
@interface ULExportController: NSObject
{
	id exportPanel;
	NSDictionary* knownFormats;
	NSDictionary* displayStrings;
	ULPasteboard* pasteboard;
	NSMutableDictionary* exportMethods;
}
+ (id) sharedExportController;
/**
Exports the object currently on the pasteboard
*/
- (void) export: (id) sender;
/**
Exports object
*/
- (void) exportObject: (id) anObject 
		toFile: (NSString*) filename 
		format: (NSString*) format;
@end

#endif

