/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-07-06 16:32:04 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include "ULOptionsController.h"

@implementation ULOptionsController

- (id) init
{
	if(self = [super init])
	{
		ioManager = [ULIOManager appIOManager];
		simulationDatabase = [ULDatabaseInterface databaseInterface];
		defaultOptionsFile = [[[NSBundle mainBundle] resourcePath] 
					stringByAppendingPathComponent: @"defaultOptions.plist"];
		[defaultOptionsFile retain];
		NSDebugLLog(@"ULOptionsController", 
			@"Options path: %@", defaultOptionsFile);
		currentOptions = nil;	
	}
	
	return self;
}

- (void) dealloc
{
	[defaultOptionsFile release];
	[currentOptions release];
	[super dealloc];
}

- (void) addOptionsForController: (NSString*) controller
{
	NSMutableDictionary* controllerOptions;
	id controllerPath;

	controllerPath = [[ioManager valueForKey:@"controllerDir"] 
				stringByAppendingPathComponent: controller];
	controllerOptions = [NSMutableDictionary dictionaryWithContentsOfFile: 
				[controllerPath stringByAppendingPathComponent: @"options.plist"]];
	[currentOptions setValue: controllerOptions 
		forKeyPath: @"Options.Controller"];
}

- (void) newModelObject
{
	id options;

	if(currentOptions != nil)
		[currentOptions release];

	currentOptions = [[ULOptions optionsWithContentsOfFile: defaultOptionsFile] retain];
	NSDebugLLog(@"ULOptionsController", 
		@"Current options are %@", 
		[currentOptions valueForKey:@"Options"]);
}

- (id) optionForKeyPath: (NSString*) keyPath
{
	return [currentOptions valueForKeyPath: keyPath];
}

/**
The same problem with the title of the options exists here
as in ULSystemController. see there for more
*/

- (void) saveModelObject
{
	[simulationDatabase addObjectToFileSystemDatabase: currentOptions];
	[[NSNotificationCenter defaultCenter] 
		postNotificationName: @"ULOptionsDidChangeNotification"
		object: [currentOptions valueForKey :@"name"]]; 
}

- (ULOptions*) Options
{
	return currentOptions;
}
@end
