/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-05-23 14:09:36 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include "ULModelController.h"

@implementation ULModelController

- (id) init
{
	//create model controllers and processManager

	ioManager = [ULIOManager appIOManager];
	simulationDatabase = [ULDatabaseInterface new];
	processManager = [ULProcessManager new];
	systemController = [ULSystemController new];
	optionsController = [ULOptionsController new];

	return self;
}

- (void) dealloc
{
	[processManager release];
	[systemController release];
	[optionsController release];
	[simulationDatabase release];
	[super dealloc];
}

//\note maybe change this to createProcessWithSystem:options:host
//with the system and options loaded from the database??
//i.e. move all database funcionality to the database object
//(loading, deleting, adding etc) and use system and options
//contoller just for creation ....

- (void) createProcessWithSystem: (ULSystem*) system 
		options: (ULOptions*) options 
		host: (NSString*) host
{
	id solvent, chain;
	NSString* solventPath;
	NSMutableDictionary* solventOptions;
	NSError* buildError;

	//check if its an explicit solvent calculation
	//\note we should be able to extract the build options for a system after the fact
	//add a system type ivar to ULSystem
	//define some keyworkd types (common to both kernel and userland )to apply to a system

	if([[[options valueForKeyPath: @"Options.Solvation.Selection"] objectAtIndex: 0] isEqual: @"Explicit"])
	{
		//assume water as solvent for the moment
		solventPath =  [[[NSBundle mainBundle] resourcePath] 
					stringByAppendingPathComponent: @"H2O.pdb"];
		[systemController setBuildMolecule: solventPath];
		solventOptions = [systemController buildOptions];
		chain = [solventOptions objectForKey: @"Chain 1"];
		[[chain objectForKey: @"Selection"] addObject: @"Solvent"] ;
		[[chain valueForKeyPath: @"Solvent.Selection"] addObject: @"HOH1"];
		buildError = nil;
		[systemController buildSystemWithOptions: solventOptions error: &buildError];
		solvent = [systemController valueForKey: @"System"];
		[processManager newProcessWithSystems: [NSArray arrayWithObjects: system, solvent, nil]
			options: options host: host];
		[systemController setValue: system forKey: @"System"];
	}
	else
		[processManager newProcessWithSystem: system
			options: options host: host];
}

- (void) saveDatabase
{
	[simulationDatabase saveDatabase];
}

- (id) SystemController
{
	return systemController;
}
- (id) OptionsController
{
	return optionsController;
}
- (id) ProcessManager 
{
	return processManager;
}

@end
