/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef _ADLISTMEMORYMANAGEMENT_H_
#define _ADLISTMEMORYMANAGEMENT_H_

#include <Foundation/Foundation.h>
#include "AdunKernel/AdunNonBondedListHandler.h"

/**
These methods add linked list memory management
to the list handler classes. For efficent memory use
and to ensure that the elements of a list are located
together, large blocks of ListElements arrays are allocated.
Requests for new ListElements structures are then met
by returning memory from these blocks. Freed structures (allocated
using these methods) are added to a freedElement list which
is used as the first source of ListElement structures upon
future requests. For optimum performance if you are removing and
then adding to a list however it would
be better to hold any removed elements directly and then use these
structures for the new elements preservering their place in the list. 
This will preserve the correlation between the linked list order
and the order of the structures in memory thus maximising cache 
efficency.
\todo Find some way to do the above here **/


@interface AdNonBondedListHandler (AdListMemoryManagement)
- (ListElement*) createNewListBlock;
- (ListElement*) getNewListElement;
- (void) freeListElement: (ListElement*) list_p;
- (void) initialiseListMemory;
- (void) clearListMemory;
- (void) resetListMemory;
@end

#endif //  _ADLISTMEMORYMANAGEMENT_H_
