/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-06-23 11:06:55 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef _GRFNONBONDED_CALCULATOR
#define _GRFNONBONDED_CALCULATOR
#include "Base/AdForceFieldFunctions.h"
#include "Base/AdLinkedList.h"
#include "AdunKernel/AdunNonbondedCalculator.h"
#include "AdunKernel/AdunDefinitions.h"

/**\note must be careful with global variables 'accelerations' and 'coordinates' declared
in ForceField.h that we dont use them instead of the instance variables of similar names.
The globals will be phased out over time **/


@interface GRFNonbondedCalculator: AdNonbondedCalculator
{
	float cutoff;
	double permittivity;
	double vdwPotential;	
	double estPotential;  
	double epsilon1; 	//!< The inner sphere relative permittivity 
	double epsilon2; 	//!< The outer sphere relative permittivity 
	double kappa;		//!< The inverse of the debye screening length in angstroms-1
	double b0;		//!< The parameter B0 in the GRF equation
	double b1;		//!< The parameter B1 in the GRF equation
	ListElement* interactionList;
}
@end

#endif
