/***************************************************************************
 *   Copyright (C) 2007 by Pino Toscano <pino@kde.org>                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _SIDEBAR_H_
#define _SIDEBAR_H_

#include <QtGui/QWidget>
#include <QtGui/QListWidget>

class QIcon;
class QListWidgetItem;

class Sidebar : public QWidget
{
    Q_OBJECT
    public:
        Sidebar( QWidget *parent = 0 );
        ~Sidebar();

        int addItem( QWidget *widget, const QIcon &icon, const QString &text );

        void setMainWidget( QWidget *widget );
        void setBottomWidget( QWidget *widget );

        void setItemEnabled( int index, bool enabled );
        bool isItemEnabled( int index ) const;
        void setSidebarEnabled( bool e );

        void setCurrentWidget( QWidget *w );
        void setCurrentIndex( int index );
        int currentIndex() const;

        void setSidebarVisibility( bool visible );
        bool isSidebarVisible() const;

    private slots:
        void itemClicked( QListWidgetItem *item );
        void splitterMoved( int pos, int index );
        void listContextMenu( const QPoint & );
        void showTextToggled( bool );
        void iconSizeChanged( QAction *action );

    private:
        void saveSplitterSize() const;

        // private storage
        class Private;
        Private *d;
};

class SidebarDelegate : public QAbstractItemDelegate
{
    public:
        SidebarDelegate( QObject *parent = 0 );
        ~SidebarDelegate();

        void setShowText( bool show );
        bool isTextShown() const;

        // from QAbstractItemDelegate
        void paint( QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index ) const;
        QSize sizeHint( const QStyleOptionViewItem &option, const QModelIndex &index ) const;

    private:
        bool m_showText;
};

static const int SidebarItemType = QListWidgetItem::UserType + 1;

/* A custom list widget that ignores the events for disabled items */
class SidebarListWidget : public QListWidget
{
    public:
        SidebarListWidget( QWidget *parent = 0 );
        ~SidebarListWidget();

    protected:
        // from QListWidget
        void mouseDoubleClickEvent( QMouseEvent *event );
        void mouseMoveEvent( QMouseEvent *event );
        void mousePressEvent( QMouseEvent *event );
        void mouseReleaseEvent( QMouseEvent *event );

        QModelIndex moveCursor( QAbstractItemView::CursorAction cursorAction, Qt::KeyboardModifiers modifiers );
};

/* List item representing a sidebar entry. */
class SidebarItem : public QListWidgetItem
{
    public:
        SidebarItem( QWidget* w, const QIcon &icon, const QString &text )
            : QListWidgetItem( 0, SidebarItemType ),
              m_widget( w )
        {
            setFlags( Qt::ItemIsSelectable | Qt::ItemIsEnabled );
            setIcon( icon );
            setText( text );
            setToolTip( text );
        }

        QWidget* widget() const
        {
            return m_widget;
        }

    private:
        QWidget *m_widget;
};
#endif
