#include <stdio.h>
#include <stdlib.h>
#include <QtWidgets/QSlider>
#include "multislider.h"
#include "modslider.h"

MultiSlider::MultiSlider(Model *p_model, int p_numLayer, Qt::Orientation orientation, QWidget *parent) : ModSlider(p_model, orientation, parent) {

  int i1;

  model = p_model;
  numLayer = p_numLayer;
  layer = 0;
  buf = (int *)malloc(numLayer * sizeof(int));
  memset(buf, 0, numLayer * sizeof(int));
  for (i1 = 0; i1 < model->getPoly(); i1++) {
    modBuf[i1] = (int *)malloc(numLayer * sizeof(int));
    memset(modBuf[i1], 0, numLayer * sizeof(int));
  }  
}

MultiSlider::~MultiSlider() {

  int i1;

  free(buf); 
  for (i1 = 0; i1 < model->getPoly(); i1++) {
    free(modBuf[i1]); 
  }  
}

void MultiSlider::sliderChange(SliderChange change) {

  int vStart, vEnd, i1;

  QSlider::sliderChange(change);
  buf[layer] = value();
  model->getEditRange(vStart, vEnd);
  for (i1 = vStart; i1 <= vEnd; i1++) {
    modBuf[i1][layer] = getModValue(i1);
  }  
}

int MultiSlider::getLayer() {
 
  return(layer);
}

void MultiSlider::setLayer(int p_layer) {
  
  int vStart, vEnd, i1;

  layer = p_layer;
  setValue(buf[layer]);
  model->getEditRange(vStart, vEnd);    
  for (i1 = vStart; i1 <= vEnd; i1++) { 
    setModValue(i1, modBuf[i1][layer]);
  }  
}

void MultiSlider::readBufValue(int p_layer, int& p_value, int& p_modValue) {

  int vStart, vEnd;
  
  p_value = buf[p_layer];
  model->getEditRange(vStart, vEnd);
  p_modValue = modBuf[vStart][p_layer];
}
 
void MultiSlider::writeBufValue(int p_layer, int p_value, int p_modValue) {

  int vStart, vEnd, i1;
  
  if (p_value < 1234) {  
    buf[p_layer] = p_value;
  }  
  if (p_modValue < 1234) {
    model->getEditRange(vStart, vEnd);
    for (i1 = vStart; i1 <= vEnd; i1++) {
      modBuf[i1][p_layer] = p_modValue;
    }  
  }  
}

void MultiSlider::readBufValue(int p_layer, int& p_value, int voiceIndex, int& p_modValue) {

  int vStart, vEnd;
  
  p_value = buf[p_layer];
  if (voiceIndex < 0) {
    model->getEditRange(vStart, vEnd);
    p_modValue = modBuf[vStart][p_layer];  
  } else {
    p_modValue = modBuf[voiceIndex][p_layer];
  }  
}
 
void MultiSlider::writeBufValue(int p_layer, int p_value, int voiceIndex, int p_modValue) {

  int vStart, vEnd, i1;
  
  if (p_value < 1234) {  
    buf[p_layer] = p_value;
  }  
  if (p_modValue < 1234) {
    if (voiceIndex < 0) {
      model->getEditRange(vStart, vEnd);
      for (i1 = vStart; i1 <= vEnd; i1++) {
        modBuf[i1][p_layer] = p_modValue;
      }
    } else {     
      modBuf[voiceIndex][p_layer] = p_modValue;
    }  
  }  
}

void MultiSlider::writeValue(int p_value, int p_modValue) {
  
  int vStart, vEnd, i1;

  buf[layer] = p_value;
  setValue(p_value);
  model->getEditRange(vStart, vEnd);
  for (i1 = vStart; i1 <= vEnd; i1++) {
    modBuf[i1][layer] = p_modValue;
    setModValue(i1, p_modValue);
  }  
}

void MultiSlider::updateSlider() {

  int vStart, vEnd, i1;
  
  setValue(buf[layer]);  
  model->getEditRange(vStart, vEnd);
  for (i1 = vStart; i1 <= vEnd; i1++) {
    setModValue(i1, modBuf[i1][layer]);
  }  
  update();
}
