(IN-PACKAGE "ACL2")

; Edited by Matt K.:
; (INCLUDE-BOOK "source_shallow" :DIR :BOOKS)
(INCLUDE-BOOK "../books/source_shallow")

; Edited by Matt K.:
; (INCLUDE-BOOK "computed-hints" :DIR :BOOKS)
(INCLUDE-BOOK "../books/computed-hints")

(DEFUND |$ind_0_typep| (X)
  (AND (TRUE-LISTP X) (TRUE-LISTP (NTH 0 X)) (NATP (NTH 0 (NTH 0 X)))
    (< (NTH 0 (NTH 0 X)) 256) (NATP (NTH 1 (NTH 0 X)))
    (< (NTH 1 (NTH 0 X)) 256) (NATP (NTH 2 (NTH 0 X)))
    (< (NTH 2 (NTH 0 X)) 256) (NATP (NTH 3 (NTH 0 X)))
    (< (NTH 3 (NTH 0 X)) 256) (NATP (NTH 4 (NTH 0 X)))
    (< (NTH 4 (NTH 0 X)) 256) (NATP (NTH 5 (NTH 0 X)))
    (< (NTH 5 (NTH 0 X)) 256) (NATP (NTH 6 (NTH 0 X)))
    (< (NTH 6 (NTH 0 X)) 256) (NATP (NTH 7 (NTH 0 X)))
    (< (NTH 7 (NTH 0 X)) 256) (NATP (NTH 1 X)) (< (NTH 1 X) 256)))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_1| (|tmp_68| |ys_2| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 8 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 8) NIL
      (CONS
        (LET ((|xs_6| (NTH |$i| (NTH 0 |tmp_68|))))
          (C-WORD-PARITY 8 (C-WORD-&& |xs_6| |ys_2|)))
        (|$ind_comp_1| |tmp_68| |ys_2| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_bitMmult_1| (|tmp_68|)
  (IF (NOT (AND (|$ind_0_typep| |tmp_68|))) 0
    (LET* ((|ys_2| (NTH 1 |tmp_68|)))
      (NAT-REP (REVERSE (|$ind_comp_1| |tmp_68| |ys_2| 0))))))

(DEFUND |$ind_1_typep| (X)
  (AND (TRUE-LISTP X) (NATP (NTH 0 X)) (< (NTH 0 X) 256) (NATP (NTH 1 X))
    (< (NTH 1 X) 256)))

(DEFUND |ind_gtimes_1| (|tmp_67|)
  (IF (NOT (AND (|$ind_1_typep| |tmp_67|))) 0
    (C-WORD-PMOD 15 9 (C-WORD-PMULT 8 8 (NTH 0 |tmp_67|) (NTH 1 |tmp_67|))
      283)))

(DEFUN |$ind_2_typep| (X) (AND (NATP X) (< X 256)))

(DEFUN |$ind_measure_ps_2| (|$i| |$s|)
  (ACL2-COUNT
    (|+| (* (|+| |$i| (COND ((EQ |$s| '|ps_2|) 0))) 1)
      (COND ((EQ |$s| '|ps_2|) 0)))))

(DEFUN |$ind_block_ps_2| (|x_8| |$i| |$s|)
  (DECLARE
    (XARGS :MEASURE (|$ind_measure_ps_2| |$i| |$s|) :HINTS (MEASURE-HINT)))
  (IF (NOT (AND (|$ind_2_typep| |x_8|) (NATP |$i|)))
    (COND ((EQ |$s| '|ps_2|) 0))
    (COND
      ((EQ |$s| '|ps_2|)
        (LET ((|tmp_66| |$i|))
          (COND ((< |$i| 1) (NTH (LOGHEAD 0 |tmp_66|) (LIST 1)))
            (T
              (|ind_gtimes_1|
                (LIST |x_8|
                  (|$ind_block_ps_2| |x_8| (|+| |tmp_66| -1) '|ps_2|))))))))))

(DEFUND |ind_ps_2| (|x_8| |$i|)
  (IF (NOT (NATP |$i|)) 0 (|$ind_block_ps_2| |x_8| |$i| '|ps_2|)))

(DEFUND |ind_gpower_1| (|tmp_65|)
  (IF (NOT (AND (|$ind_1_typep| |tmp_65|))) 0
    (LET* ((|x_7| (NTH 0 |tmp_65|))) (|ind_ps_2| |x_7| (NTH 1 |tmp_65|)))))

(DEFUND |ind_ginverse_1| (|x_6|)
  (IF (NOT (AND (|$ind_2_typep| |x_6|))) 0
    (IF (C-== |x_6| 0) 0 (C-WORD-PINV 9 8 283 |x_6|))))

(DEFUND |$ind_3_typep| (X)
  (AND (TRUE-LISTP X) (NATP (NTH 0 X)) (< (NTH 0 X) 256) (NATP (NTH 1 X))
    (< (NTH 1 X) 256) (NATP (NTH 2 X)) (< (NTH 2 X) 256) (NATP (NTH 3 X))
    (< (NTH 3 X) 256)))

(DEFUN |$ind_measure_sums_2| (|$i| |$s|)
  (ACL2-COUNT
    (|+| (* (|+| |$i| (COND ((EQ |$s| '|sums_2|) 0))) 1)
      (COND ((EQ |$s| '|sums_2|) 0)))))

(DEFUN |$ind_block_sums_2| (|xs_5| |$i| |$s|)
  (DECLARE
    (XARGS :MEASURE (|$ind_measure_sums_2| |$i| |$s|) :HINTS (MEASURE-HINT)))
  (IF (NOT (AND (|$ind_3_typep| |xs_5|) (NATP |$i|)))
    (COND ((EQ |$s| '|sums_2|) 0))
    (COND
      ((EQ |$s| '|sums_2|)
        (LET ((|tmp_64| |$i|))
          (COND ((< |$i| 1) (NTH (LOGHEAD 0 |tmp_64|) (LIST 0)))
            (T
              (C-WORD-^^ (NTH (LOGHEAD 2 (C-WORD-- 32 |tmp_64| 1)) |xs_5|)
                (|$ind_block_sums_2| |xs_5| (|+| |tmp_64| -1) '|sums_2|)))))))))

(DEFUND |ind_sums_2| (|xs_5| |$i|)
  (IF (NOT (NATP |$i|)) 0 (|$ind_block_sums_2| |xs_5| |$i| '|sums_2|)))

(DEFUND |ind_byteSum_1| (|xs_4|)
  (IF (NOT (AND (|$ind_3_typep| |xs_4|))) 0 (|ind_sums_2| |xs_4| 4)))

(DEFUND |$ind_4_typep| (X)
  (AND (TRUE-LISTP X) (TRUE-LISTP (NTH 0 X)) (NATP (NTH 0 (NTH 0 X)))
    (< (NTH 0 (NTH 0 X)) 256) (NATP (NTH 1 (NTH 0 X)))
    (< (NTH 1 (NTH 0 X)) 256) (NATP (NTH 2 (NTH 0 X)))
    (< (NTH 2 (NTH 0 X)) 256) (NATP (NTH 3 (NTH 0 X)))
    (< (NTH 3 (NTH 0 X)) 256) (TRUE-LISTP (NTH 1 X)) (NATP (NTH 0 (NTH 1 X)))
    (< (NTH 0 (NTH 1 X)) 256) (NATP (NTH 1 (NTH 1 X)))
    (< (NTH 1 (NTH 1 X)) 256) (NATP (NTH 2 (NTH 1 X)))
    (< (NTH 2 (NTH 1 X)) 256) (NATP (NTH 3 (NTH 1 X)))
    (< (NTH 3 (NTH 1 X)) 256)))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_2| (|tmp_63| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 4 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 4) NIL
      (CONS
        (LET ((|a_1| (NTH |$i| (NTH 0 |tmp_63|))))
          (LET ((|b_1| (NTH |$i| (NTH 1 |tmp_63|))))
            (|ind_gtimes_1| (LIST |a_1| |b_1|))))
        (|$ind_comp_2| |tmp_63| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_byteDot_1| (|tmp_63|)
  (IF (NOT (AND (|$ind_4_typep| |tmp_63|))) 0
    (|ind_byteSum_1| (|$ind_comp_2| |tmp_63| 0))))

(DEFUND |$ind_5_typep| (X)
  (AND (TRUE-LISTP X) (TRUE-LISTP (NTH 0 X)) (TRUE-LISTP (NTH 0 (NTH 0 X)))
    (NATP (NTH 0 (NTH 0 (NTH 0 X)))) (< (NTH 0 (NTH 0 (NTH 0 X))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 0 X)))) (< (NTH 1 (NTH 0 (NTH 0 X))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 0 X)))) (< (NTH 2 (NTH 0 (NTH 0 X))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 0 X)))) (< (NTH 3 (NTH 0 (NTH 0 X))) 256)
    (TRUE-LISTP (NTH 1 (NTH 0 X))) (NATP (NTH 0 (NTH 1 (NTH 0 X))))
    (< (NTH 0 (NTH 1 (NTH 0 X))) 256) (NATP (NTH 1 (NTH 1 (NTH 0 X))))
    (< (NTH 1 (NTH 1 (NTH 0 X))) 256) (NATP (NTH 2 (NTH 1 (NTH 0 X))))
    (< (NTH 2 (NTH 1 (NTH 0 X))) 256) (NATP (NTH 3 (NTH 1 (NTH 0 X))))
    (< (NTH 3 (NTH 1 (NTH 0 X))) 256) (TRUE-LISTP (NTH 2 (NTH 0 X)))
    (NATP (NTH 0 (NTH 2 (NTH 0 X)))) (< (NTH 0 (NTH 2 (NTH 0 X))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 0 X)))) (< (NTH 1 (NTH 2 (NTH 0 X))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 0 X)))) (< (NTH 2 (NTH 2 (NTH 0 X))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 0 X)))) (< (NTH 3 (NTH 2 (NTH 0 X))) 256)
    (TRUE-LISTP (NTH 3 (NTH 0 X))) (NATP (NTH 0 (NTH 3 (NTH 0 X))))
    (< (NTH 0 (NTH 3 (NTH 0 X))) 256) (NATP (NTH 1 (NTH 3 (NTH 0 X))))
    (< (NTH 1 (NTH 3 (NTH 0 X))) 256) (NATP (NTH 2 (NTH 3 (NTH 0 X))))
    (< (NTH 2 (NTH 3 (NTH 0 X))) 256) (NATP (NTH 3 (NTH 3 (NTH 0 X))))
    (< (NTH 3 (NTH 3 (NTH 0 X))) 256) (TRUE-LISTP (NTH 1 X))
    (NATP (NTH 0 (NTH 1 X))) (< (NTH 0 (NTH 1 X)) 256)
    (NATP (NTH 1 (NTH 1 X))) (< (NTH 1 (NTH 1 X)) 256)
    (NATP (NTH 2 (NTH 1 X))) (< (NTH 2 (NTH 1 X)) 256)
    (NATP (NTH 3 (NTH 1 X))) (< (NTH 3 (NTH 1 X)) 256)))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_3| (|tmp_62| |ys_1| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 4 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 4) NIL
      (CONS
        (LET ((|xs_3| (NTH |$i| (NTH 0 |tmp_62|))))
          (|ind_byteDot_1| (LIST |xs_3| |ys_1|)))
        (|$ind_comp_3| |tmp_62| |ys_1| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_byteMmult_1| (|tmp_62|)
  (IF (NOT (AND (|$ind_5_typep| |tmp_62|))) (LIST 0 0 0 0)
    (LET* ((|ys_1| (NTH 1 |tmp_62|))) (|$ind_comp_3| |tmp_62| |ys_1| 0))))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_4| (|$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 8 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 8) NIL
      (CONS
        (LET ((|i_7| (NTH |$i| (LIST 0 1 2 3 4 5 6 7))))
          (C-WORD->>> 8 248 |i_7|)) (|$ind_comp_4| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_affMat_1| NIL (|$ind_comp_4| 0))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_5| (|$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 8 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 8) NIL
      (CONS
        (LET ((|i_6| (NTH |$i| (LIST 0 1 2 3 4 5 6 7))))
          (C-WORD->>> 8 82 |i_6|)) (|$ind_comp_5| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_invAffMat_1| NIL (|$ind_comp_5| 0))

(DEFUND |ind_affine_1| (|xs_2|)
  (IF (NOT (AND (|$ind_2_typep| |xs_2|))) 0
    (C-WORD-^^ (|ind_bitMmult_1| (LIST (|ind_affMat_1|) |xs_2|)) 99)))

(DEFUND |ind_invAffine_1| (|xs_1|)
  (IF (NOT (AND (|$ind_2_typep| |xs_1|))) 0
    (|ind_bitMmult_1| (LIST (|ind_invAffMat_1|) (C-WORD-^^ |xs_1| 99)))))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_6| (|$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 256 (|-| |$i|))) :HINTS
      (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 256) NIL
      (CONS
        (LET
          ((|x_5|
             (NTH |$i|
               (LIST 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21
                 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41
                 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61
                 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81
                 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100
                 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115
                 116 117 118 119 120 121 122 123 124 125 126 127 128 129 130
                 131 132 133 134 135 136 137 138 139 140 141 142 143 144 145
                 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160
                 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175
                 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190
                 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205
                 206 207 208 209 210 211 212 213 214 215 216 217 218 219 220
                 221 222 223 224 225 226 227 228 229 230 231 232 233 234 235
                 236 237 238 239 240 241 242 243 244 245 246 247 248 249 250
                 251 252 253 254 255))))
          (|ind_affine_1| (|ind_ginverse_1| |x_5|)))
        (|$ind_comp_6| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_sbox_1| NIL
  (IF
    (C-== (LIST 115 114 99 101 45 115 104 97 108)
      (LIST 97 97 109 112 45 100 101 101 112))
    (LIST 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
      0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
      0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
      0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
      0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
      0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
      0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
      0 0 0 0 0 0) (|$ind_comp_6| 0)))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_7| (|$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 256 (|-| |$i|))) :HINTS
      (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 256) NIL
      (CONS
        (LET
          ((|x_4|
             (NTH |$i|
               (LIST 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21
                 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41
                 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61
                 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81
                 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100
                 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115
                 116 117 118 119 120 121 122 123 124 125 126 127 128 129 130
                 131 132 133 134 135 136 137 138 139 140 141 142 143 144 145
                 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160
                 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175
                 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190
                 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205
                 206 207 208 209 210 211 212 213 214 215 216 217 218 219 220
                 221 222 223 224 225 226 227 228 229 230 231 232 233 234 235
                 236 237 238 239 240 241 242 243 244 245 246 247 248 249 250
                 251 252 253 254 255))))
          (|ind_ginverse_1| (|ind_invAffine_1| |x_4|)))
        (|$ind_comp_7| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_invSbox_1| NIL
  (IF
    (C-== (LIST 115 114 99 101 45 115 104 97 108)
      (LIST 97 97 109 112 45 100 101 101 112))
    (LIST 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
      0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
      0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
      0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
      0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
      0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
      0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
      0 0 0 0 0 0) (|$ind_comp_7| 0)))

(DEFUND |$ind_6_typep| (X)
  (AND (TRUE-LISTP X) (TRUE-LISTP (NTH 0 X)) (NATP (NTH 0 (NTH 0 X)))
    (< (NTH 0 (NTH 0 X)) 256) (NATP (NTH 1 (NTH 0 X)))
    (< (NTH 1 (NTH 0 X)) 256) (NATP (NTH 2 (NTH 0 X)))
    (< (NTH 2 (NTH 0 X)) 256) (NATP (NTH 3 (NTH 0 X)))
    (< (NTH 3 (NTH 0 X)) 256) (TRUE-LISTP (NTH 1 X)) (NATP (NTH 0 (NTH 1 X)))
    (< (NTH 0 (NTH 1 X)) 256) (NATP (NTH 1 (NTH 1 X)))
    (< (NTH 1 (NTH 1 X)) 256) (NATP (NTH 2 (NTH 1 X)))
    (< (NTH 2 (NTH 1 X)) 256) (NATP (NTH 3 (NTH 1 X)))
    (< (NTH 3 (NTH 1 X)) 256) (TRUE-LISTP (NTH 2 X)) (NATP (NTH 0 (NTH 2 X)))
    (< (NTH 0 (NTH 2 X)) 256) (NATP (NTH 1 (NTH 2 X)))
    (< (NTH 1 (NTH 2 X)) 256) (NATP (NTH 2 (NTH 2 X)))
    (< (NTH 2 (NTH 2 X)) 256) (NATP (NTH 3 (NTH 2 X)))
    (< (NTH 3 (NTH 2 X)) 256) (TRUE-LISTP (NTH 3 X)) (NATP (NTH 0 (NTH 3 X)))
    (< (NTH 0 (NTH 3 X)) 256) (NATP (NTH 1 (NTH 3 X)))
    (< (NTH 1 (NTH 3 X)) 256) (NATP (NTH 2 (NTH 3 X)))
    (< (NTH 2 (NTH 3 X)) 256) (NATP (NTH 3 (NTH 3 X)))
    (< (NTH 3 (NTH 3 X)) 256)))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_9| (|row_4| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 4 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 4) NIL
      (CONS (LET ((|x_3| (NTH |$i| |row_4|))) (NTH |x_3| (|ind_sbox_1|)))
        (|$ind_comp_9| |row_4| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_8| (|state_11| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 4 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 4) NIL
      (CONS (LET ((|row_4| (NTH |$i| |state_11|))) (|$ind_comp_9| |row_4| 0))
        (|$ind_comp_8| |state_11| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_byteSub_1| (|state_11|)
  (IF (NOT (AND (|$ind_6_typep| |state_11|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (|$ind_comp_8| |state_11| 0)))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_11| (|row_3| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 4 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 4) NIL
      (CONS (LET ((|x_2| (NTH |$i| |row_3|))) (NTH |x_2| (|ind_invSbox_1|)))
        (|$ind_comp_11| |row_3| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_10| (|state_10| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 4 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 4) NIL
      (CONS
        (LET ((|row_3| (NTH |$i| |state_10|))) (|$ind_comp_11| |row_3| 0))
        (|$ind_comp_10| |state_10| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_invByteSub_1| (|state_10|)
  (IF (NOT (AND (|$ind_6_typep| |state_10|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (|$ind_comp_10| |state_10| 0)))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_12| (|state_9| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 4 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 4) NIL
      (CONS
        (LET ((|row_2| (NTH |$i| |state_9|)))
          (LET ((|i_5| (NTH |$i| (LIST 0 1 2 3)))) (C-VEC-<<< |row_2| |i_5|)))
        (|$ind_comp_12| |state_9| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_shiftRow_1| (|state_9|)
  (IF (NOT (AND (|$ind_6_typep| |state_9|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (|$ind_comp_12| |state_9| 0)))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_13| (|state_8| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 4 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 4) NIL
      (CONS
        (LET ((|row_1| (NTH |$i| |state_8|)))
          (LET ((|i_4| (NTH |$i| (LIST 0 1 2 3)))) (C-VEC->>> |row_1| |i_4|)))
        (|$ind_comp_13| |state_8| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_invShiftRow_1| (|state_8|)
  (IF (NOT (AND (|$ind_6_typep| |state_8|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (|$ind_comp_13| |state_8| 0)))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_14| (|coeff_1| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 4 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 4) NIL
      (CONS
        (LET ((|i_3| (NTH |$i| (LIST 0 1 2 3)))) (C-VEC->>> |coeff_1| |i_3|))
        (|$ind_comp_14| |coeff_1| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_polyMat_1| (|coeff_1|)
  (IF (NOT (AND (|$ind_3_typep| |coeff_1|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (C-VEC-TRANSPOSE 4 4 (|$ind_comp_14| |coeff_1| 0))))

(DEFUND |ind_cx_1| NIL (|ind_polyMat_1| (LIST 2 1 1 3)))

(DEFUND |ind_dx_1| NIL (|ind_polyMat_1| (LIST 14 9 13 11)))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_15| (|state_7| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 4 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 4) NIL
      (CONS
        (LET ((|col_2| (NTH |$i| (C-VEC-TRANSPOSE 4 4 |state_7|))))
          (|ind_byteMmult_1| (LIST (|ind_cx_1|) |col_2|)))
        (|$ind_comp_15| |state_7| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_mixColumn_1| (|state_7|)
  (IF (NOT (AND (|$ind_6_typep| |state_7|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (C-VEC-TRANSPOSE 4 4 (|$ind_comp_15| |state_7| 0))))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_16| (|state_6| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 4 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 4) NIL
      (CONS
        (LET ((|col_1| (NTH |$i| (C-VEC-TRANSPOSE 4 4 |state_6|))))
          (|ind_byteMmult_1| (LIST (|ind_dx_1|) |col_1|)))
        (|$ind_comp_16| |state_6| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_invMixColumn_1| (|state_6|)
  (IF (NOT (AND (|$ind_6_typep| |state_6|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (C-VEC-TRANSPOSE 4 4 (|$ind_comp_16| |state_6| 0))))

(DEFUND |$ind_7_typep| (X)
  (AND (TRUE-LISTP X) (TRUE-LISTP (NTH 0 X)) (TRUE-LISTP (NTH 0 (NTH 0 X)))
    (NATP (NTH 0 (NTH 0 (NTH 0 X)))) (< (NTH 0 (NTH 0 (NTH 0 X))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 0 X)))) (< (NTH 1 (NTH 0 (NTH 0 X))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 0 X)))) (< (NTH 2 (NTH 0 (NTH 0 X))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 0 X)))) (< (NTH 3 (NTH 0 (NTH 0 X))) 256)
    (TRUE-LISTP (NTH 1 (NTH 0 X))) (NATP (NTH 0 (NTH 1 (NTH 0 X))))
    (< (NTH 0 (NTH 1 (NTH 0 X))) 256) (NATP (NTH 1 (NTH 1 (NTH 0 X))))
    (< (NTH 1 (NTH 1 (NTH 0 X))) 256) (NATP (NTH 2 (NTH 1 (NTH 0 X))))
    (< (NTH 2 (NTH 1 (NTH 0 X))) 256) (NATP (NTH 3 (NTH 1 (NTH 0 X))))
    (< (NTH 3 (NTH 1 (NTH 0 X))) 256) (TRUE-LISTP (NTH 2 (NTH 0 X)))
    (NATP (NTH 0 (NTH 2 (NTH 0 X)))) (< (NTH 0 (NTH 2 (NTH 0 X))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 0 X)))) (< (NTH 1 (NTH 2 (NTH 0 X))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 0 X)))) (< (NTH 2 (NTH 2 (NTH 0 X))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 0 X)))) (< (NTH 3 (NTH 2 (NTH 0 X))) 256)
    (TRUE-LISTP (NTH 3 (NTH 0 X))) (NATP (NTH 0 (NTH 3 (NTH 0 X))))
    (< (NTH 0 (NTH 3 (NTH 0 X))) 256) (NATP (NTH 1 (NTH 3 (NTH 0 X))))
    (< (NTH 1 (NTH 3 (NTH 0 X))) 256) (NATP (NTH 2 (NTH 3 (NTH 0 X))))
    (< (NTH 2 (NTH 3 (NTH 0 X))) 256) (NATP (NTH 3 (NTH 3 (NTH 0 X))))
    (< (NTH 3 (NTH 3 (NTH 0 X))) 256) (TRUE-LISTP (NTH 1 X))
    (TRUE-LISTP (NTH 0 (NTH 1 X))) (NATP (NTH 0 (NTH 0 (NTH 1 X))))
    (< (NTH 0 (NTH 0 (NTH 1 X))) 256) (NATP (NTH 1 (NTH 0 (NTH 1 X))))
    (< (NTH 1 (NTH 0 (NTH 1 X))) 256) (NATP (NTH 2 (NTH 0 (NTH 1 X))))
    (< (NTH 2 (NTH 0 (NTH 1 X))) 256) (NATP (NTH 3 (NTH 0 (NTH 1 X))))
    (< (NTH 3 (NTH 0 (NTH 1 X))) 256) (TRUE-LISTP (NTH 1 (NTH 1 X)))
    (NATP (NTH 0 (NTH 1 (NTH 1 X)))) (< (NTH 0 (NTH 1 (NTH 1 X))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 1 X)))) (< (NTH 1 (NTH 1 (NTH 1 X))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 1 X)))) (< (NTH 2 (NTH 1 (NTH 1 X))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 1 X)))) (< (NTH 3 (NTH 1 (NTH 1 X))) 256)
    (TRUE-LISTP (NTH 2 (NTH 1 X))) (NATP (NTH 0 (NTH 2 (NTH 1 X))))
    (< (NTH 0 (NTH 2 (NTH 1 X))) 256) (NATP (NTH 1 (NTH 2 (NTH 1 X))))
    (< (NTH 1 (NTH 2 (NTH 1 X))) 256) (NATP (NTH 2 (NTH 2 (NTH 1 X))))
    (< (NTH 2 (NTH 2 (NTH 1 X))) 256) (NATP (NTH 3 (NTH 2 (NTH 1 X))))
    (< (NTH 3 (NTH 2 (NTH 1 X))) 256) (TRUE-LISTP (NTH 3 (NTH 1 X)))
    (NATP (NTH 0 (NTH 3 (NTH 1 X)))) (< (NTH 0 (NTH 3 (NTH 1 X))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 1 X)))) (< (NTH 1 (NTH 3 (NTH 1 X))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 1 X)))) (< (NTH 2 (NTH 3 (NTH 1 X))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 1 X)))) (< (NTH 3 (NTH 3 (NTH 1 X))) 256)))

(DEFUND |ind_xorS_1| (|tmp_61|)
  (IF (NOT (AND (|$ind_7_typep| |tmp_61|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (C-VEC-SPLIT 4
      (C-WORD-SPLIT 8 16
        (C-WORD-^^ (C-WORD-JOIN 8 (C-VEC-JOIN (NTH 0 |tmp_61|)))
          (C-WORD-JOIN 8 (C-VEC-JOIN (NTH 1 |tmp_61|))))))))

(DEFUND |ind_round_1| (|tmp_60|)
  (IF (NOT (AND (|$ind_7_typep| |tmp_60|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (|ind_xorS_1|
      (LIST
        (|ind_mixColumn_1|
          (|ind_shiftRow_1| (|ind_byteSub_1| (NTH 0 |tmp_60|))))
        (NTH 1 |tmp_60|)))))

(DEFUND |ind_finalRound_1| (|tmp_59|)
  (IF (NOT (AND (|$ind_7_typep| |tmp_59|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (|ind_xorS_1|
      (LIST (|ind_shiftRow_1| (|ind_byteSub_1| (NTH 0 |tmp_59|)))
        (NTH 1 |tmp_59|)))))

(DEFUND |ind_invRound_1| (|tmp_58|)
  (IF (NOT (AND (|$ind_7_typep| |tmp_58|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (|ind_xorS_1|
      (LIST
        (|ind_invMixColumn_1|
          (|ind_invShiftRow_1| (|ind_invByteSub_1| (NTH 0 |tmp_58|))))
        (NTH 1 |tmp_58|)))))

(DEFUND |ind_invFinalRound_1| (|tmp_57|)
  (IF (NOT (AND (|$ind_7_typep| |tmp_57|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (|ind_xorS_1|
      (LIST (|ind_invShiftRow_1| (|ind_invByteSub_1| (NTH 0 |tmp_57|)))
        (NTH 1 |tmp_57|)))))

(DEFUND |$ind_8_typep| (X)
  (AND (TRUE-LISTP X) (TRUE-LISTP (NTH 0 X)) (TRUE-LISTP (NTH 0 (NTH 0 X)))
    (NATP (NTH 0 (NTH 0 (NTH 0 X)))) (< (NTH 0 (NTH 0 (NTH 0 X))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 0 X)))) (< (NTH 1 (NTH 0 (NTH 0 X))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 0 X)))) (< (NTH 2 (NTH 0 (NTH 0 X))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 0 X)))) (< (NTH 3 (NTH 0 (NTH 0 X))) 256)
    (TRUE-LISTP (NTH 1 (NTH 0 X))) (NATP (NTH 0 (NTH 1 (NTH 0 X))))
    (< (NTH 0 (NTH 1 (NTH 0 X))) 256) (NATP (NTH 1 (NTH 1 (NTH 0 X))))
    (< (NTH 1 (NTH 1 (NTH 0 X))) 256) (NATP (NTH 2 (NTH 1 (NTH 0 X))))
    (< (NTH 2 (NTH 1 (NTH 0 X))) 256) (NATP (NTH 3 (NTH 1 (NTH 0 X))))
    (< (NTH 3 (NTH 1 (NTH 0 X))) 256) (TRUE-LISTP (NTH 2 (NTH 0 X)))
    (NATP (NTH 0 (NTH 2 (NTH 0 X)))) (< (NTH 0 (NTH 2 (NTH 0 X))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 0 X)))) (< (NTH 1 (NTH 2 (NTH 0 X))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 0 X)))) (< (NTH 2 (NTH 2 (NTH 0 X))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 0 X)))) (< (NTH 3 (NTH 2 (NTH 0 X))) 256)
    (TRUE-LISTP (NTH 3 (NTH 0 X))) (NATP (NTH 0 (NTH 3 (NTH 0 X))))
    (< (NTH 0 (NTH 3 (NTH 0 X))) 256) (NATP (NTH 1 (NTH 3 (NTH 0 X))))
    (< (NTH 1 (NTH 3 (NTH 0 X))) 256) (NATP (NTH 2 (NTH 3 (NTH 0 X))))
    (< (NTH 2 (NTH 3 (NTH 0 X))) 256) (NATP (NTH 3 (NTH 3 (NTH 0 X))))
    (< (NTH 3 (NTH 3 (NTH 0 X))) 256) (TRUE-LISTP (NTH 1 X))
    (TRUE-LISTP (NTH 0 (NTH 1 X))) (NATP (NTH 0 (NTH 0 (NTH 1 X))))
    (< (NTH 0 (NTH 0 (NTH 1 X))) 256) (NATP (NTH 1 (NTH 0 (NTH 1 X))))
    (< (NTH 1 (NTH 0 (NTH 1 X))) 256) (NATP (NTH 2 (NTH 0 (NTH 1 X))))
    (< (NTH 2 (NTH 0 (NTH 1 X))) 256) (NATP (NTH 3 (NTH 0 (NTH 1 X))))
    (< (NTH 3 (NTH 0 (NTH 1 X))) 256) (TRUE-LISTP (NTH 1 (NTH 1 X)))
    (NATP (NTH 0 (NTH 1 (NTH 1 X)))) (< (NTH 0 (NTH 1 (NTH 1 X))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 1 X)))) (< (NTH 1 (NTH 1 (NTH 1 X))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 1 X)))) (< (NTH 2 (NTH 1 (NTH 1 X))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 1 X)))) (< (NTH 3 (NTH 1 (NTH 1 X))) 256)
    (TRUE-LISTP (NTH 2 (NTH 1 X))) (NATP (NTH 0 (NTH 2 (NTH 1 X))))
    (< (NTH 0 (NTH 2 (NTH 1 X))) 256) (NATP (NTH 1 (NTH 2 (NTH 1 X))))
    (< (NTH 1 (NTH 2 (NTH 1 X))) 256) (NATP (NTH 2 (NTH 2 (NTH 1 X))))
    (< (NTH 2 (NTH 2 (NTH 1 X))) 256) (NATP (NTH 3 (NTH 2 (NTH 1 X))))
    (< (NTH 3 (NTH 2 (NTH 1 X))) 256) (TRUE-LISTP (NTH 3 (NTH 1 X)))
    (NATP (NTH 0 (NTH 3 (NTH 1 X)))) (< (NTH 0 (NTH 3 (NTH 1 X))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 1 X)))) (< (NTH 1 (NTH 3 (NTH 1 X))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 1 X)))) (< (NTH 2 (NTH 3 (NTH 1 X))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 1 X)))) (< (NTH 3 (NTH 3 (NTH 1 X))) 256)
    (TRUE-LISTP (NTH 2 X)) (TRUE-LISTP (NTH 0 (NTH 2 X)))
    (NATP (NTH 0 (NTH 0 (NTH 2 X)))) (< (NTH 0 (NTH 0 (NTH 2 X))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 2 X)))) (< (NTH 1 (NTH 0 (NTH 2 X))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 2 X)))) (< (NTH 2 (NTH 0 (NTH 2 X))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 2 X)))) (< (NTH 3 (NTH 0 (NTH 2 X))) 256)
    (TRUE-LISTP (NTH 1 (NTH 2 X))) (NATP (NTH 0 (NTH 1 (NTH 2 X))))
    (< (NTH 0 (NTH 1 (NTH 2 X))) 256) (NATP (NTH 1 (NTH 1 (NTH 2 X))))
    (< (NTH 1 (NTH 1 (NTH 2 X))) 256) (NATP (NTH 2 (NTH 1 (NTH 2 X))))
    (< (NTH 2 (NTH 1 (NTH 2 X))) 256) (NATP (NTH 3 (NTH 1 (NTH 2 X))))
    (< (NTH 3 (NTH 1 (NTH 2 X))) 256) (TRUE-LISTP (NTH 2 (NTH 2 X)))
    (NATP (NTH 0 (NTH 2 (NTH 2 X)))) (< (NTH 0 (NTH 2 (NTH 2 X))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 2 X)))) (< (NTH 1 (NTH 2 (NTH 2 X))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 2 X)))) (< (NTH 2 (NTH 2 (NTH 2 X))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 2 X)))) (< (NTH 3 (NTH 2 (NTH 2 X))) 256)
    (TRUE-LISTP (NTH 3 (NTH 2 X))) (NATP (NTH 0 (NTH 3 (NTH 2 X))))
    (< (NTH 0 (NTH 3 (NTH 2 X))) 256) (NATP (NTH 1 (NTH 3 (NTH 2 X))))
    (< (NTH 1 (NTH 3 (NTH 2 X))) 256) (NATP (NTH 2 (NTH 3 (NTH 2 X))))
    (< (NTH 2 (NTH 3 (NTH 2 X))) 256) (NATP (NTH 3 (NTH 3 (NTH 2 X))))
    (< (NTH 3 (NTH 3 (NTH 2 X))) 256) (TRUE-LISTP (NTH 3 X))
    (TRUE-LISTP (NTH 0 (NTH 3 X))) (NATP (NTH 0 (NTH 0 (NTH 3 X))))
    (< (NTH 0 (NTH 0 (NTH 3 X))) 256) (NATP (NTH 1 (NTH 0 (NTH 3 X))))
    (< (NTH 1 (NTH 0 (NTH 3 X))) 256) (NATP (NTH 2 (NTH 0 (NTH 3 X))))
    (< (NTH 2 (NTH 0 (NTH 3 X))) 256) (NATP (NTH 3 (NTH 0 (NTH 3 X))))
    (< (NTH 3 (NTH 0 (NTH 3 X))) 256) (TRUE-LISTP (NTH 1 (NTH 3 X)))
    (NATP (NTH 0 (NTH 1 (NTH 3 X)))) (< (NTH 0 (NTH 1 (NTH 3 X))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 3 X)))) (< (NTH 1 (NTH 1 (NTH 3 X))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 3 X)))) (< (NTH 2 (NTH 1 (NTH 3 X))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 3 X)))) (< (NTH 3 (NTH 1 (NTH 3 X))) 256)
    (TRUE-LISTP (NTH 2 (NTH 3 X))) (NATP (NTH 0 (NTH 2 (NTH 3 X))))
    (< (NTH 0 (NTH 2 (NTH 3 X))) 256) (NATP (NTH 1 (NTH 2 (NTH 3 X))))
    (< (NTH 1 (NTH 2 (NTH 3 X))) 256) (NATP (NTH 2 (NTH 2 (NTH 3 X))))
    (< (NTH 2 (NTH 2 (NTH 3 X))) 256) (NATP (NTH 3 (NTH 2 (NTH 3 X))))
    (< (NTH 3 (NTH 2 (NTH 3 X))) 256) (TRUE-LISTP (NTH 3 (NTH 3 X)))
    (NATP (NTH 0 (NTH 3 (NTH 3 X)))) (< (NTH 0 (NTH 3 (NTH 3 X))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 3 X)))) (< (NTH 1 (NTH 3 (NTH 3 X))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 3 X)))) (< (NTH 2 (NTH 3 (NTH 3 X))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 3 X)))) (< (NTH 3 (NTH 3 (NTH 3 X))) 256)
    (TRUE-LISTP (NTH 4 X)) (TRUE-LISTP (NTH 0 (NTH 4 X)))
    (NATP (NTH 0 (NTH 0 (NTH 4 X)))) (< (NTH 0 (NTH 0 (NTH 4 X))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 4 X)))) (< (NTH 1 (NTH 0 (NTH 4 X))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 4 X)))) (< (NTH 2 (NTH 0 (NTH 4 X))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 4 X)))) (< (NTH 3 (NTH 0 (NTH 4 X))) 256)
    (TRUE-LISTP (NTH 1 (NTH 4 X))) (NATP (NTH 0 (NTH 1 (NTH 4 X))))
    (< (NTH 0 (NTH 1 (NTH 4 X))) 256) (NATP (NTH 1 (NTH 1 (NTH 4 X))))
    (< (NTH 1 (NTH 1 (NTH 4 X))) 256) (NATP (NTH 2 (NTH 1 (NTH 4 X))))
    (< (NTH 2 (NTH 1 (NTH 4 X))) 256) (NATP (NTH 3 (NTH 1 (NTH 4 X))))
    (< (NTH 3 (NTH 1 (NTH 4 X))) 256) (TRUE-LISTP (NTH 2 (NTH 4 X)))
    (NATP (NTH 0 (NTH 2 (NTH 4 X)))) (< (NTH 0 (NTH 2 (NTH 4 X))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 4 X)))) (< (NTH 1 (NTH 2 (NTH 4 X))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 4 X)))) (< (NTH 2 (NTH 2 (NTH 4 X))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 4 X)))) (< (NTH 3 (NTH 2 (NTH 4 X))) 256)
    (TRUE-LISTP (NTH 3 (NTH 4 X))) (NATP (NTH 0 (NTH 3 (NTH 4 X))))
    (< (NTH 0 (NTH 3 (NTH 4 X))) 256) (NATP (NTH 1 (NTH 3 (NTH 4 X))))
    (< (NTH 1 (NTH 3 (NTH 4 X))) 256) (NATP (NTH 2 (NTH 3 (NTH 4 X))))
    (< (NTH 2 (NTH 3 (NTH 4 X))) 256) (NATP (NTH 3 (NTH 3 (NTH 4 X))))
    (< (NTH 3 (NTH 3 (NTH 4 X))) 256) (TRUE-LISTP (NTH 5 X))
    (TRUE-LISTP (NTH 0 (NTH 5 X))) (NATP (NTH 0 (NTH 0 (NTH 5 X))))
    (< (NTH 0 (NTH 0 (NTH 5 X))) 256) (NATP (NTH 1 (NTH 0 (NTH 5 X))))
    (< (NTH 1 (NTH 0 (NTH 5 X))) 256) (NATP (NTH 2 (NTH 0 (NTH 5 X))))
    (< (NTH 2 (NTH 0 (NTH 5 X))) 256) (NATP (NTH 3 (NTH 0 (NTH 5 X))))
    (< (NTH 3 (NTH 0 (NTH 5 X))) 256) (TRUE-LISTP (NTH 1 (NTH 5 X)))
    (NATP (NTH 0 (NTH 1 (NTH 5 X)))) (< (NTH 0 (NTH 1 (NTH 5 X))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 5 X)))) (< (NTH 1 (NTH 1 (NTH 5 X))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 5 X)))) (< (NTH 2 (NTH 1 (NTH 5 X))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 5 X)))) (< (NTH 3 (NTH 1 (NTH 5 X))) 256)
    (TRUE-LISTP (NTH 2 (NTH 5 X))) (NATP (NTH 0 (NTH 2 (NTH 5 X))))
    (< (NTH 0 (NTH 2 (NTH 5 X))) 256) (NATP (NTH 1 (NTH 2 (NTH 5 X))))
    (< (NTH 1 (NTH 2 (NTH 5 X))) 256) (NATP (NTH 2 (NTH 2 (NTH 5 X))))
    (< (NTH 2 (NTH 2 (NTH 5 X))) 256) (NATP (NTH 3 (NTH 2 (NTH 5 X))))
    (< (NTH 3 (NTH 2 (NTH 5 X))) 256) (TRUE-LISTP (NTH 3 (NTH 5 X)))
    (NATP (NTH 0 (NTH 3 (NTH 5 X)))) (< (NTH 0 (NTH 3 (NTH 5 X))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 5 X)))) (< (NTH 1 (NTH 3 (NTH 5 X))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 5 X)))) (< (NTH 2 (NTH 3 (NTH 5 X))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 5 X)))) (< (NTH 3 (NTH 3 (NTH 5 X))) 256)
    (TRUE-LISTP (NTH 6 X)) (TRUE-LISTP (NTH 0 (NTH 6 X)))
    (NATP (NTH 0 (NTH 0 (NTH 6 X)))) (< (NTH 0 (NTH 0 (NTH 6 X))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 6 X)))) (< (NTH 1 (NTH 0 (NTH 6 X))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 6 X)))) (< (NTH 2 (NTH 0 (NTH 6 X))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 6 X)))) (< (NTH 3 (NTH 0 (NTH 6 X))) 256)
    (TRUE-LISTP (NTH 1 (NTH 6 X))) (NATP (NTH 0 (NTH 1 (NTH 6 X))))
    (< (NTH 0 (NTH 1 (NTH 6 X))) 256) (NATP (NTH 1 (NTH 1 (NTH 6 X))))
    (< (NTH 1 (NTH 1 (NTH 6 X))) 256) (NATP (NTH 2 (NTH 1 (NTH 6 X))))
    (< (NTH 2 (NTH 1 (NTH 6 X))) 256) (NATP (NTH 3 (NTH 1 (NTH 6 X))))
    (< (NTH 3 (NTH 1 (NTH 6 X))) 256) (TRUE-LISTP (NTH 2 (NTH 6 X)))
    (NATP (NTH 0 (NTH 2 (NTH 6 X)))) (< (NTH 0 (NTH 2 (NTH 6 X))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 6 X)))) (< (NTH 1 (NTH 2 (NTH 6 X))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 6 X)))) (< (NTH 2 (NTH 2 (NTH 6 X))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 6 X)))) (< (NTH 3 (NTH 2 (NTH 6 X))) 256)
    (TRUE-LISTP (NTH 3 (NTH 6 X))) (NATP (NTH 0 (NTH 3 (NTH 6 X))))
    (< (NTH 0 (NTH 3 (NTH 6 X))) 256) (NATP (NTH 1 (NTH 3 (NTH 6 X))))
    (< (NTH 1 (NTH 3 (NTH 6 X))) 256) (NATP (NTH 2 (NTH 3 (NTH 6 X))))
    (< (NTH 2 (NTH 3 (NTH 6 X))) 256) (NATP (NTH 3 (NTH 3 (NTH 6 X))))
    (< (NTH 3 (NTH 3 (NTH 6 X))) 256) (TRUE-LISTP (NTH 7 X))
    (TRUE-LISTP (NTH 0 (NTH 7 X))) (NATP (NTH 0 (NTH 0 (NTH 7 X))))
    (< (NTH 0 (NTH 0 (NTH 7 X))) 256) (NATP (NTH 1 (NTH 0 (NTH 7 X))))
    (< (NTH 1 (NTH 0 (NTH 7 X))) 256) (NATP (NTH 2 (NTH 0 (NTH 7 X))))
    (< (NTH 2 (NTH 0 (NTH 7 X))) 256) (NATP (NTH 3 (NTH 0 (NTH 7 X))))
    (< (NTH 3 (NTH 0 (NTH 7 X))) 256) (TRUE-LISTP (NTH 1 (NTH 7 X)))
    (NATP (NTH 0 (NTH 1 (NTH 7 X)))) (< (NTH 0 (NTH 1 (NTH 7 X))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 7 X)))) (< (NTH 1 (NTH 1 (NTH 7 X))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 7 X)))) (< (NTH 2 (NTH 1 (NTH 7 X))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 7 X)))) (< (NTH 3 (NTH 1 (NTH 7 X))) 256)
    (TRUE-LISTP (NTH 2 (NTH 7 X))) (NATP (NTH 0 (NTH 2 (NTH 7 X))))
    (< (NTH 0 (NTH 2 (NTH 7 X))) 256) (NATP (NTH 1 (NTH 2 (NTH 7 X))))
    (< (NTH 1 (NTH 2 (NTH 7 X))) 256) (NATP (NTH 2 (NTH 2 (NTH 7 X))))
    (< (NTH 2 (NTH 2 (NTH 7 X))) 256) (NATP (NTH 3 (NTH 2 (NTH 7 X))))
    (< (NTH 3 (NTH 2 (NTH 7 X))) 256) (TRUE-LISTP (NTH 3 (NTH 7 X)))
    (NATP (NTH 0 (NTH 3 (NTH 7 X)))) (< (NTH 0 (NTH 3 (NTH 7 X))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 7 X)))) (< (NTH 1 (NTH 3 (NTH 7 X))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 7 X)))) (< (NTH 2 (NTH 3 (NTH 7 X))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 7 X)))) (< (NTH 3 (NTH 3 (NTH 7 X))) 256)
    (TRUE-LISTP (NTH 8 X)) (TRUE-LISTP (NTH 0 (NTH 8 X)))
    (NATP (NTH 0 (NTH 0 (NTH 8 X)))) (< (NTH 0 (NTH 0 (NTH 8 X))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 8 X)))) (< (NTH 1 (NTH 0 (NTH 8 X))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 8 X)))) (< (NTH 2 (NTH 0 (NTH 8 X))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 8 X)))) (< (NTH 3 (NTH 0 (NTH 8 X))) 256)
    (TRUE-LISTP (NTH 1 (NTH 8 X))) (NATP (NTH 0 (NTH 1 (NTH 8 X))))
    (< (NTH 0 (NTH 1 (NTH 8 X))) 256) (NATP (NTH 1 (NTH 1 (NTH 8 X))))
    (< (NTH 1 (NTH 1 (NTH 8 X))) 256) (NATP (NTH 2 (NTH 1 (NTH 8 X))))
    (< (NTH 2 (NTH 1 (NTH 8 X))) 256) (NATP (NTH 3 (NTH 1 (NTH 8 X))))
    (< (NTH 3 (NTH 1 (NTH 8 X))) 256) (TRUE-LISTP (NTH 2 (NTH 8 X)))
    (NATP (NTH 0 (NTH 2 (NTH 8 X)))) (< (NTH 0 (NTH 2 (NTH 8 X))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 8 X)))) (< (NTH 1 (NTH 2 (NTH 8 X))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 8 X)))) (< (NTH 2 (NTH 2 (NTH 8 X))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 8 X)))) (< (NTH 3 (NTH 2 (NTH 8 X))) 256)
    (TRUE-LISTP (NTH 3 (NTH 8 X))) (NATP (NTH 0 (NTH 3 (NTH 8 X))))
    (< (NTH 0 (NTH 3 (NTH 8 X))) 256) (NATP (NTH 1 (NTH 3 (NTH 8 X))))
    (< (NTH 1 (NTH 3 (NTH 8 X))) 256) (NATP (NTH 2 (NTH 3 (NTH 8 X))))
    (< (NTH 2 (NTH 3 (NTH 8 X))) 256) (NATP (NTH 3 (NTH 3 (NTH 8 X))))
    (< (NTH 3 (NTH 3 (NTH 8 X))) 256)))

(DEFUN |$ind_measure_rnds_4| (|$i| |$s|)
  (ACL2-COUNT
    (|+| (* (|+| |$i| (COND ((EQ |$s| '|rnds_4|) 0))) 1)
      (COND ((EQ |$s| '|rnds_4|) 0)))))

(DEFUN |$ind_block_rnds_4| (|state_5| |rndKeys_2| |initialKey_2| |$i| |$s|)
  (DECLARE
    (XARGS :MEASURE (|$ind_measure_rnds_4| |$i| |$s|) :HINTS (MEASURE-HINT)))
  (IF
    (NOT
      (AND (|$ind_6_typep| |initialKey_2|) (|$ind_8_typep| |rndKeys_2|)
        (|$ind_6_typep| |state_5|) (NATP |$i|)))
    (COND
      ((EQ |$s| '|rnds_4|)
        (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))))
    (COND
      ((EQ |$s| '|rnds_4|)
        (LET ((|tmp_56| |$i|))
          (COND
            ((< |$i| 1)
              (NTH (LOGHEAD 0 |tmp_56|)
                (LIST (|ind_xorS_1| (LIST |state_5| |initialKey_2|)))))
            (T
              (|ind_round_1|
                (LIST
                  (|$ind_block_rnds_4| |state_5| |rndKeys_2| |initialKey_2|
                    (|+| |tmp_56| -1) '|rnds_4|)
                  (NTH (LOGHEAD 4 (C-WORD-% (C-WORD-- 32 |tmp_56| 1) 9))
                    |rndKeys_2|))))))))))

(DEFUND |ind_rnds_4| (|state_5| |rndKeys_2| |initialKey_2| |$i|)
  (IF (NOT (NATP |$i|))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (|$ind_block_rnds_4| |state_5| |rndKeys_2| |initialKey_2| |$i| '|rnds_4|)))

(DEFUND |$ind_9_typep| (X)
  (AND (TRUE-LISTP X) (TRUE-LISTP (NTH 0 X)) (TRUE-LISTP (NTH 0 (NTH 0 X)))
    (NATP (NTH 0 (NTH 0 (NTH 0 X)))) (< (NTH 0 (NTH 0 (NTH 0 X))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 0 X)))) (< (NTH 1 (NTH 0 (NTH 0 X))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 0 X)))) (< (NTH 2 (NTH 0 (NTH 0 X))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 0 X)))) (< (NTH 3 (NTH 0 (NTH 0 X))) 256)
    (TRUE-LISTP (NTH 1 (NTH 0 X))) (NATP (NTH 0 (NTH 1 (NTH 0 X))))
    (< (NTH 0 (NTH 1 (NTH 0 X))) 256) (NATP (NTH 1 (NTH 1 (NTH 0 X))))
    (< (NTH 1 (NTH 1 (NTH 0 X))) 256) (NATP (NTH 2 (NTH 1 (NTH 0 X))))
    (< (NTH 2 (NTH 1 (NTH 0 X))) 256) (NATP (NTH 3 (NTH 1 (NTH 0 X))))
    (< (NTH 3 (NTH 1 (NTH 0 X))) 256) (TRUE-LISTP (NTH 2 (NTH 0 X)))
    (NATP (NTH 0 (NTH 2 (NTH 0 X)))) (< (NTH 0 (NTH 2 (NTH 0 X))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 0 X)))) (< (NTH 1 (NTH 2 (NTH 0 X))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 0 X)))) (< (NTH 2 (NTH 2 (NTH 0 X))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 0 X)))) (< (NTH 3 (NTH 2 (NTH 0 X))) 256)
    (TRUE-LISTP (NTH 3 (NTH 0 X))) (NATP (NTH 0 (NTH 3 (NTH 0 X))))
    (< (NTH 0 (NTH 3 (NTH 0 X))) 256) (NATP (NTH 1 (NTH 3 (NTH 0 X))))
    (< (NTH 1 (NTH 3 (NTH 0 X))) 256) (NATP (NTH 2 (NTH 3 (NTH 0 X))))
    (< (NTH 2 (NTH 3 (NTH 0 X))) 256) (NATP (NTH 3 (NTH 3 (NTH 0 X))))
    (< (NTH 3 (NTH 3 (NTH 0 X))) 256) (TRUE-LISTP (NTH 1 X))
    (TRUE-LISTP (NTH 0 (NTH 1 X))) (TRUE-LISTP (NTH 0 (NTH 0 (NTH 1 X))))
    (NATP (NTH 0 (NTH 0 (NTH 0 (NTH 1 X)))))
    (< (NTH 0 (NTH 0 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 0 (NTH 1 X)))))
    (< (NTH 1 (NTH 0 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 0 (NTH 1 X)))))
    (< (NTH 2 (NTH 0 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 0 (NTH 1 X)))))
    (< (NTH 3 (NTH 0 (NTH 0 (NTH 1 X)))) 256)
    (TRUE-LISTP (NTH 1 (NTH 0 (NTH 1 X))))
    (NATP (NTH 0 (NTH 1 (NTH 0 (NTH 1 X)))))
    (< (NTH 0 (NTH 1 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 0 (NTH 1 X)))))
    (< (NTH 1 (NTH 1 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 0 (NTH 1 X)))))
    (< (NTH 2 (NTH 1 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 0 (NTH 1 X)))))
    (< (NTH 3 (NTH 1 (NTH 0 (NTH 1 X)))) 256)
    (TRUE-LISTP (NTH 2 (NTH 0 (NTH 1 X))))
    (NATP (NTH 0 (NTH 2 (NTH 0 (NTH 1 X)))))
    (< (NTH 0 (NTH 2 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 0 (NTH 1 X)))))
    (< (NTH 1 (NTH 2 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 0 (NTH 1 X)))))
    (< (NTH 2 (NTH 2 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 0 (NTH 1 X)))))
    (< (NTH 3 (NTH 2 (NTH 0 (NTH 1 X)))) 256)
    (TRUE-LISTP (NTH 3 (NTH 0 (NTH 1 X))))
    (NATP (NTH 0 (NTH 3 (NTH 0 (NTH 1 X)))))
    (< (NTH 0 (NTH 3 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 0 (NTH 1 X)))))
    (< (NTH 1 (NTH 3 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 0 (NTH 1 X)))))
    (< (NTH 2 (NTH 3 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 0 (NTH 1 X)))))
    (< (NTH 3 (NTH 3 (NTH 0 (NTH 1 X)))) 256) (TRUE-LISTP (NTH 1 (NTH 1 X)))
    (TRUE-LISTP (NTH 0 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 0 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 0 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 0 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 0 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 1 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 1 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 1 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 1 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 2 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 2 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 2 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 2 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 3 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 3 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 3 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 3 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 4 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 4 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 4 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 4 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 4 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 5 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 5 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 5 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 5 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 5 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 6 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 6 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 6 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 6 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 6 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 7 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 7 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 7 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 7 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 7 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 8 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 8 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 8 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 8 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 8 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 1 X))) (TRUE-LISTP (NTH 0 (NTH 2 (NTH 1 X))))
    (NATP (NTH 0 (NTH 0 (NTH 2 (NTH 1 X)))))
    (< (NTH 0 (NTH 0 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 2 (NTH 1 X)))))
    (< (NTH 1 (NTH 0 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 2 (NTH 1 X)))))
    (< (NTH 2 (NTH 0 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 2 (NTH 1 X)))))
    (< (NTH 3 (NTH 0 (NTH 2 (NTH 1 X)))) 256)
    (TRUE-LISTP (NTH 1 (NTH 2 (NTH 1 X))))
    (NATP (NTH 0 (NTH 1 (NTH 2 (NTH 1 X)))))
    (< (NTH 0 (NTH 1 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 2 (NTH 1 X)))))
    (< (NTH 1 (NTH 1 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 2 (NTH 1 X)))))
    (< (NTH 2 (NTH 1 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 2 (NTH 1 X)))))
    (< (NTH 3 (NTH 1 (NTH 2 (NTH 1 X)))) 256)
    (TRUE-LISTP (NTH 2 (NTH 2 (NTH 1 X))))
    (NATP (NTH 0 (NTH 2 (NTH 2 (NTH 1 X)))))
    (< (NTH 0 (NTH 2 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 2 (NTH 1 X)))))
    (< (NTH 1 (NTH 2 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 2 (NTH 1 X)))))
    (< (NTH 2 (NTH 2 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 2 (NTH 1 X)))))
    (< (NTH 3 (NTH 2 (NTH 2 (NTH 1 X)))) 256)
    (TRUE-LISTP (NTH 3 (NTH 2 (NTH 1 X))))
    (NATP (NTH 0 (NTH 3 (NTH 2 (NTH 1 X)))))
    (< (NTH 0 (NTH 3 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 2 (NTH 1 X)))))
    (< (NTH 1 (NTH 3 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 2 (NTH 1 X)))))
    (< (NTH 2 (NTH 3 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 2 (NTH 1 X)))))
    (< (NTH 3 (NTH 3 (NTH 2 (NTH 1 X)))) 256)))

(DEFUND |ind_rounds_1| (|tmp_54|)
  (IF (NOT (AND (|$ind_9_typep| |tmp_54|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (LET*
      ((|state_4| (NTH 0 |tmp_54|)) (|tmp_55| (NTH 1 |tmp_54|))
        (|initialKey_1| (NTH 0 |tmp_55|)) (|rndKeys_1| (NTH 1 |tmp_55|)))
      (|ind_finalRound_1|
        (LIST
          (|ind_rnds_4| |state_4| |rndKeys_1| |initialKey_1|
            (C-WORD-- 32 10 1)) (NTH 2 |tmp_55|))))))

(DEFUN |$ind_measure_rnds_3| (|$i| |$s|)
  (ACL2-COUNT
    (|+| (* (|+| |$i| (COND ((EQ |$s| '|rnds_3|) 0))) 1)
      (COND ((EQ |$s| '|rnds_3|) 0)))))

(DEFUN |$ind_block_rnds_3| (|state_3| |invRndKeys_2| |finalKey_2| |$i| |$s|)
  (DECLARE
    (XARGS :MEASURE (|$ind_measure_rnds_3| |$i| |$s|) :HINTS (MEASURE-HINT)))
  (IF
    (NOT
      (AND (|$ind_6_typep| |finalKey_2|) (|$ind_8_typep| |invRndKeys_2|)
        (|$ind_6_typep| |state_3|) (NATP |$i|)))
    (COND
      ((EQ |$s| '|rnds_3|)
        (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))))
    (COND
      ((EQ |$s| '|rnds_3|)
        (LET ((|tmp_53| |$i|))
          (COND
            ((< |$i| 1)
              (NTH (LOGHEAD 0 |tmp_53|)
                (LIST (|ind_xorS_1| (LIST |state_3| |finalKey_2|)))))
            (T
              (|ind_invRound_1|
                (LIST
                  (|$ind_block_rnds_3| |state_3| |invRndKeys_2| |finalKey_2|
                    (|+| |tmp_53| -1) '|rnds_3|)
                  (NTH (LOGHEAD 4 (C-WORD-% (C-WORD-- 32 |tmp_53| 1) 9))
                    |invRndKeys_2|))))))))))

(DEFUND |ind_rnds_3| (|state_3| |invRndKeys_2| |finalKey_2| |$i|)
  (IF (NOT (NATP |$i|))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (|$ind_block_rnds_3| |state_3| |invRndKeys_2| |finalKey_2| |$i|
      '|rnds_3|)))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_17| (|tmp_52| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 9 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 9) NIL
      (CONS
        (LET ((|k_1| (NTH |$i| (C-VEC-REVERSE 9 (NTH 1 |tmp_52|)))))
          (|ind_invMixColumn_1| |k_1|))
        (|$ind_comp_17| |tmp_52| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_invRounds_1| (|tmp_51|)
  (IF (NOT (AND (|$ind_9_typep| |tmp_51|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (LET*
      ((|state_2| (NTH 0 |tmp_51|)) (|tmp_52| (NTH 1 |tmp_51|))
        (|finalKey_1| (NTH 2 |tmp_52|))
        (|invRndKeys_1| (|$ind_comp_17| |tmp_52| 0)))
      (|ind_invFinalRound_1|
        (LIST
          (|ind_rnds_3| |state_2| |invRndKeys_1| |finalKey_1|
            (C-WORD-- 32 10 1)) (NTH 0 |tmp_52|))))))

(DEFUND |ind_xorB4_1| (|tmp_50|)
  (IF (NOT (AND (|$ind_4_typep| |tmp_50|))) (LIST 0 0 0 0)
    (C-WORD-SPLIT 8 4
      (C-WORD-^^ (C-WORD-JOIN 8 (NTH 0 |tmp_50|))
        (C-WORD-JOIN 8 (NTH 1 |tmp_50|))))))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_18| (|p_1| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 4 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 4) NIL
      (CONS (LET ((|x_1| (NTH |$i| |p_1|))) (NTH |x_1| (|ind_sbox_1|)))
        (|$ind_comp_18| |p_1| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_subByte_1| (|p_1|)
  (IF (NOT (AND (|$ind_3_typep| |p_1|))) (LIST 0 0 0 0)
    (|$ind_comp_18| |p_1| 0)))

(DEFUND |ind_rcon_1| (|i_2|)
  (IF (NOT (AND (|$ind_2_typep| |i_2|))) (LIST 0 0 0 0)
    (LIST (|ind_gpower_1| (LIST 2 (C-WORD-- 8 |i_2| 1))) 0 0 0)))

(DEFUND |$ind_10_typep| (X)
  (AND (TRUE-LISTP X) (NATP (NTH 0 X)) (< (NTH 0 X) 256)
    (TRUE-LISTP (NTH 1 X)) (NATP (NTH 0 (NTH 1 X))) (< (NTH 0 (NTH 1 X)) 256)
    (NATP (NTH 1 (NTH 1 X))) (< (NTH 1 (NTH 1 X)) 256)
    (NATP (NTH 2 (NTH 1 X))) (< (NTH 2 (NTH 1 X)) 256)
    (NATP (NTH 3 (NTH 1 X))) (< (NTH 3 (NTH 1 X)) 256) (TRUE-LISTP (NTH 2 X))
    (NATP (NTH 0 (NTH 2 X))) (< (NTH 0 (NTH 2 X)) 256)
    (NATP (NTH 1 (NTH 2 X))) (< (NTH 1 (NTH 2 X)) 256)
    (NATP (NTH 2 (NTH 2 X))) (< (NTH 2 (NTH 2 X)) 256)
    (NATP (NTH 3 (NTH 2 X))) (< (NTH 3 (NTH 2 X)) 256)))

(DEFUND |ind_nextWord_1| (|tmp_49|)
  (IF (NOT (AND (|$ind_10_typep| |tmp_49|))) (LIST 0 0 0 0)
    (LET* ((|i_1| (NTH 0 |tmp_49|)) (|prev_1| (NTH 2 |tmp_49|)))
      (|ind_xorB4_1|
        (LIST (NTH 1 |tmp_49|)
          (IF (C-== (C-WORD-% |i_1| 4) 0)
            (|ind_xorB4_1|
              (LIST (|ind_subByte_1| (C-VEC-<<< |prev_1| 1))
                (|ind_rcon_1| (C-WORD-/ |i_1| 4))))
            (IF (AND (< 6 4) (C-== (C-WORD-% |i_1| 4) 4))
              (|ind_subByte_1| |prev_1|) |prev_1|)))))))

(DEFUN |$ind_measure_w_2| (|$i| |$s|)
  (ACL2-COUNT
    (|+| (* (|+| |$i| (COND ((EQ |$s| '|w_2|) 0))) 1)
      (COND ((EQ |$s| '|w_2|) 0)))))

(DEFUN |$ind_block_w_2| (|keyCols_2| |$i| |$s|)
  (DECLARE
    (XARGS :MEASURE (|$ind_measure_w_2| |$i| |$s|) :HINTS (MEASURE-HINT)))
  (IF (NOT (AND (|$ind_6_typep| |keyCols_2|) (NATP |$i|)))
    (COND ((EQ |$s| '|w_2|) (LIST 0 0 0 0)))
    (COND
      ((EQ |$s| '|w_2|)
        (LET ((|tmp_48| |$i|))
          (COND ((< |$i| 4) (NTH (LOGHEAD 2 |tmp_48|) |keyCols_2|))
            (T
              (|ind_nextWord_1|
                (LIST
                  (NTH (LOGHEAD 6 (C-WORD-% (C-WORD-- 32 |tmp_48| 4) 40))
                    (LIST 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22
                      23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40
                      41 42 43))
                  (|$ind_block_w_2| |keyCols_2| (|+| |tmp_48| -4) '|w_2|)
                  (|$ind_block_w_2| |keyCols_2| (|+| |tmp_48| -1) '|w_2|))))))))))

(DEFUND |ind_w_2| (|keyCols_2| |$i|)
  (IF (NOT (NATP |$i|)) (LIST 0 0 0 0)
    (|$ind_block_w_2| |keyCols_2| |$i| '|w_2|)))

(DEFUND |$ind_11_typep| (X)
  (AND (TRUE-LISTP X) (NATP (NTH 0 X)) (< (NTH 0 X) 256) (NATP (NTH 1 X))
    (< (NTH 1 X) 256) (NATP (NTH 2 X)) (< (NTH 2 X) 256) (NATP (NTH 3 X))
    (< (NTH 3 X) 256) (NATP (NTH 4 X)) (< (NTH 4 X) 256) (NATP (NTH 5 X))
    (< (NTH 5 X) 256) (NATP (NTH 6 X)) (< (NTH 6 X) 256) (NATP (NTH 7 X))
    (< (NTH 7 X) 256) (NATP (NTH 8 X)) (< (NTH 8 X) 256) (NATP (NTH 9 X))
    (< (NTH 9 X) 256) (NATP (NTH 10 X)) (< (NTH 10 X) 256) (NATP (NTH 11 X))
    (< (NTH 11 X) 256) (NATP (NTH 12 X)) (< (NTH 12 X) 256) (NATP (NTH 13 X))
    (< (NTH 13 X) 256) (NATP (NTH 14 X)) (< (NTH 14 X) 256) (NATP (NTH 15 X))
    (< (NTH 15 X) 256)))

(DEFUN |$ind_takes_1| (|$tmp_69| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 44 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 44) NIL
      (CONS (|ind_w_2| |$tmp_69| |$i|)
        (|$ind_takes_1| |$tmp_69| (|1+| |$i|))))))

(DEFUND |ind_keyExpansion_1| (|key_2|)
  (IF (NOT (AND (|$ind_11_typep| |key_2|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
      (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
      (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
      (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
      (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
      (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
      (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
      (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
      (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
      (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
      (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (LET* ((|keyCols_1| (C-VEC-SPLIT 4 |key_2|)))
      (|$ind_takes_1| |keyCols_1| 0))))

(SET-IGNORE-OK T)

(DEFUN |$ind_comp_19| (|key_1| |$i|)
  (DECLARE
    (XARGS :MEASURE (ACL2-COUNT (|+| 1 11 (|-| |$i|))) :HINTS (MEASURE-HINT)))
  (IF (NOT (NATP |$i|)) NIL
    (IF (>= |$i| 11) NIL
      (CONS
        (LET
          ((|ws_1| (NTH |$i| (C-VEC-SPLIT 4 (|ind_keyExpansion_1| |key_1|)))))
          (C-VEC-TRANSPOSE 4 4 |ws_1|)) (|$ind_comp_19| |key_1| (|1+| |$i|))))))

(SET-IGNORE-OK NIL)

(DEFUND |ind_keySchedule_1| (|key_1|)
  (IF (NOT (AND (|$ind_11_typep| |key_1|)))
    (LIST (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
      (LIST
        (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
        (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
        (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
        (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
        (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
        (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
        (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
        (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
        (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)))
      (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)))
    (LET* ((|rKeys_1| (|$ind_comp_19| |key_1| 0)))
      (LIST
        (IF (<= 0 10) (NTH 0 |rKeys_1|)
          (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)))
        (IF (<= 1 2) (C-VEC-SEGMENT 9 |rKeys_1| 1)
          (LIST
            (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
              (LIST 0 0 0 0))
            (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
              (LIST 0 0 0 0))
            (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
              (LIST 0 0 0 0))
            (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
              (LIST 0 0 0 0))
            (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
              (LIST 0 0 0 0))
            (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
              (LIST 0 0 0 0))
            (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
              (LIST 0 0 0 0))
            (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
              (LIST 0 0 0 0))
            (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)
              (LIST 0 0 0 0))))
        (IF (<= 10 10) (NTH 10 |rKeys_1|)
          (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0)))))))

(DEFUND |ind_stripe_1| (|block_1|)
  (IF (NOT (AND (|$ind_11_typep| |block_1|)))
    (LIST (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0) (LIST 0 0 0 0))
    (C-VEC-TRANSPOSE 4 4 (C-VEC-SPLIT 4 |block_1|))))

(DEFUND |ind_unstripe_1| (|state_1|)
  (IF (NOT (AND (|$ind_6_typep| |state_1|)))
    (LIST 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
    (C-VEC-JOIN (C-VEC-TRANSPOSE 4 4 |state_1|))))

(DEFUND |$ind_12_typep| (X)
  (AND (TRUE-LISTP X) (TRUE-LISTP (NTH 0 X)) (NATP (NTH 0 (NTH 0 X)))
    (< (NTH 0 (NTH 0 X)) 256) (NATP (NTH 1 (NTH 0 X)))
    (< (NTH 1 (NTH 0 X)) 256) (NATP (NTH 2 (NTH 0 X)))
    (< (NTH 2 (NTH 0 X)) 256) (NATP (NTH 3 (NTH 0 X)))
    (< (NTH 3 (NTH 0 X)) 256) (NATP (NTH 4 (NTH 0 X)))
    (< (NTH 4 (NTH 0 X)) 256) (NATP (NTH 5 (NTH 0 X)))
    (< (NTH 5 (NTH 0 X)) 256) (NATP (NTH 6 (NTH 0 X)))
    (< (NTH 6 (NTH 0 X)) 256) (NATP (NTH 7 (NTH 0 X)))
    (< (NTH 7 (NTH 0 X)) 256) (NATP (NTH 8 (NTH 0 X)))
    (< (NTH 8 (NTH 0 X)) 256) (NATP (NTH 9 (NTH 0 X)))
    (< (NTH 9 (NTH 0 X)) 256) (NATP (NTH 10 (NTH 0 X)))
    (< (NTH 10 (NTH 0 X)) 256) (NATP (NTH 11 (NTH 0 X)))
    (< (NTH 11 (NTH 0 X)) 256) (NATP (NTH 12 (NTH 0 X)))
    (< (NTH 12 (NTH 0 X)) 256) (NATP (NTH 13 (NTH 0 X)))
    (< (NTH 13 (NTH 0 X)) 256) (NATP (NTH 14 (NTH 0 X)))
    (< (NTH 14 (NTH 0 X)) 256) (NATP (NTH 15 (NTH 0 X)))
    (< (NTH 15 (NTH 0 X)) 256) (TRUE-LISTP (NTH 1 X))
    (TRUE-LISTP (NTH 0 (NTH 1 X))) (TRUE-LISTP (NTH 0 (NTH 0 (NTH 1 X))))
    (NATP (NTH 0 (NTH 0 (NTH 0 (NTH 1 X)))))
    (< (NTH 0 (NTH 0 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 0 (NTH 1 X)))))
    (< (NTH 1 (NTH 0 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 0 (NTH 1 X)))))
    (< (NTH 2 (NTH 0 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 0 (NTH 1 X)))))
    (< (NTH 3 (NTH 0 (NTH 0 (NTH 1 X)))) 256)
    (TRUE-LISTP (NTH 1 (NTH 0 (NTH 1 X))))
    (NATP (NTH 0 (NTH 1 (NTH 0 (NTH 1 X)))))
    (< (NTH 0 (NTH 1 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 0 (NTH 1 X)))))
    (< (NTH 1 (NTH 1 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 0 (NTH 1 X)))))
    (< (NTH 2 (NTH 1 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 0 (NTH 1 X)))))
    (< (NTH 3 (NTH 1 (NTH 0 (NTH 1 X)))) 256)
    (TRUE-LISTP (NTH 2 (NTH 0 (NTH 1 X))))
    (NATP (NTH 0 (NTH 2 (NTH 0 (NTH 1 X)))))
    (< (NTH 0 (NTH 2 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 0 (NTH 1 X)))))
    (< (NTH 1 (NTH 2 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 0 (NTH 1 X)))))
    (< (NTH 2 (NTH 2 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 0 (NTH 1 X)))))
    (< (NTH 3 (NTH 2 (NTH 0 (NTH 1 X)))) 256)
    (TRUE-LISTP (NTH 3 (NTH 0 (NTH 1 X))))
    (NATP (NTH 0 (NTH 3 (NTH 0 (NTH 1 X)))))
    (< (NTH 0 (NTH 3 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 0 (NTH 1 X)))))
    (< (NTH 1 (NTH 3 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 0 (NTH 1 X)))))
    (< (NTH 2 (NTH 3 (NTH 0 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 0 (NTH 1 X)))))
    (< (NTH 3 (NTH 3 (NTH 0 (NTH 1 X)))) 256) (TRUE-LISTP (NTH 1 (NTH 1 X)))
    (TRUE-LISTP (NTH 0 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 0 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 0 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 0 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 0 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 0 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 1 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 1 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 1 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 1 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 1 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 2 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 2 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 2 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 2 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 2 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 3 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 3 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 3 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 3 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 3 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 4 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 4 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 4 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 4 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 4 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 4 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 5 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 5 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 5 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 5 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 5 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 5 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 6 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 6 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 6 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 6 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 6 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 6 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 7 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 7 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 7 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 7 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 7 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 7 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 8 (NTH 1 (NTH 1 X))))
    (TRUE-LISTP (NTH 0 (NTH 8 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 0 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 1 (NTH 8 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 1 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 8 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 2 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 3 (NTH 8 (NTH 1 (NTH 1 X)))))
    (NATP (NTH 0 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 0 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 1 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 2 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))))
    (< (NTH 3 (NTH 3 (NTH 8 (NTH 1 (NTH 1 X))))) 256)
    (TRUE-LISTP (NTH 2 (NTH 1 X))) (TRUE-LISTP (NTH 0 (NTH 2 (NTH 1 X))))
    (NATP (NTH 0 (NTH 0 (NTH 2 (NTH 1 X)))))
    (< (NTH 0 (NTH 0 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 0 (NTH 2 (NTH 1 X)))))
    (< (NTH 1 (NTH 0 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 0 (NTH 2 (NTH 1 X)))))
    (< (NTH 2 (NTH 0 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 0 (NTH 2 (NTH 1 X)))))
    (< (NTH 3 (NTH 0 (NTH 2 (NTH 1 X)))) 256)
    (TRUE-LISTP (NTH 1 (NTH 2 (NTH 1 X))))
    (NATP (NTH 0 (NTH 1 (NTH 2 (NTH 1 X)))))
    (< (NTH 0 (NTH 1 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 1 (NTH 2 (NTH 1 X)))))
    (< (NTH 1 (NTH 1 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 1 (NTH 2 (NTH 1 X)))))
    (< (NTH 2 (NTH 1 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 1 (NTH 2 (NTH 1 X)))))
    (< (NTH 3 (NTH 1 (NTH 2 (NTH 1 X)))) 256)
    (TRUE-LISTP (NTH 2 (NTH 2 (NTH 1 X))))
    (NATP (NTH 0 (NTH 2 (NTH 2 (NTH 1 X)))))
    (< (NTH 0 (NTH 2 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 2 (NTH 2 (NTH 1 X)))))
    (< (NTH 1 (NTH 2 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 2 (NTH 2 (NTH 1 X)))))
    (< (NTH 2 (NTH 2 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 2 (NTH 2 (NTH 1 X)))))
    (< (NTH 3 (NTH 2 (NTH 2 (NTH 1 X)))) 256)
    (TRUE-LISTP (NTH 3 (NTH 2 (NTH 1 X))))
    (NATP (NTH 0 (NTH 3 (NTH 2 (NTH 1 X)))))
    (< (NTH 0 (NTH 3 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 1 (NTH 3 (NTH 2 (NTH 1 X)))))
    (< (NTH 1 (NTH 3 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 2 (NTH 3 (NTH 2 (NTH 1 X)))))
    (< (NTH 2 (NTH 3 (NTH 2 (NTH 1 X)))) 256)
    (NATP (NTH 3 (NTH 3 (NTH 2 (NTH 1 X)))))
    (< (NTH 3 (NTH 3 (NTH 2 (NTH 1 X)))) 256)))

(DEFUND |ind_encrypt_1| (|tmp_47|)
  (IF (NOT (AND (|$ind_12_typep| |tmp_47|)))
    (LIST 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
    (|ind_unstripe_1|
      (|ind_rounds_1|
        (LIST (|ind_stripe_1| (NTH 0 |tmp_47|)) (NTH 1 |tmp_47|))))))

(DEFUND |ind_decrypt_1| (|tmp_46|)
  (IF (NOT (AND (|$ind_12_typep| |tmp_46|)))
    (LIST 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
    (|ind_unstripe_1|
      (|ind_invRounds_1|
        (LIST (|ind_stripe_1| (NTH 0 |tmp_46|)) (NTH 1 |tmp_46|))))))

(DEFUND |$ind_13_typep| (X)
  (AND (TRUE-LISTP X) (TRUE-LISTP (NTH 0 X)) (NATP (NTH 0 (NTH 0 X)))
    (< (NTH 0 (NTH 0 X)) 256) (NATP (NTH 1 (NTH 0 X)))
    (< (NTH 1 (NTH 0 X)) 256) (NATP (NTH 2 (NTH 0 X)))
    (< (NTH 2 (NTH 0 X)) 256) (NATP (NTH 3 (NTH 0 X)))
    (< (NTH 3 (NTH 0 X)) 256) (NATP (NTH 4 (NTH 0 X)))
    (< (NTH 4 (NTH 0 X)) 256) (NATP (NTH 5 (NTH 0 X)))
    (< (NTH 5 (NTH 0 X)) 256) (NATP (NTH 6 (NTH 0 X)))
    (< (NTH 6 (NTH 0 X)) 256) (NATP (NTH 7 (NTH 0 X)))
    (< (NTH 7 (NTH 0 X)) 256) (NATP (NTH 8 (NTH 0 X)))
    (< (NTH 8 (NTH 0 X)) 256) (NATP (NTH 9 (NTH 0 X)))
    (< (NTH 9 (NTH 0 X)) 256) (NATP (NTH 10 (NTH 0 X)))
    (< (NTH 10 (NTH 0 X)) 256) (NATP (NTH 11 (NTH 0 X)))
    (< (NTH 11 (NTH 0 X)) 256) (NATP (NTH 12 (NTH 0 X)))
    (< (NTH 12 (NTH 0 X)) 256) (NATP (NTH 13 (NTH 0 X)))
    (< (NTH 13 (NTH 0 X)) 256) (NATP (NTH 14 (NTH 0 X)))
    (< (NTH 14 (NTH 0 X)) 256) (NATP (NTH 15 (NTH 0 X)))
    (< (NTH 15 (NTH 0 X)) 256) (TRUE-LISTP (NTH 1 X))
    (NATP (NTH 0 (NTH 1 X))) (< (NTH 0 (NTH 1 X)) 256)
    (NATP (NTH 1 (NTH 1 X))) (< (NTH 1 (NTH 1 X)) 256)
    (NATP (NTH 2 (NTH 1 X))) (< (NTH 2 (NTH 1 X)) 256)
    (NATP (NTH 3 (NTH 1 X))) (< (NTH 3 (NTH 1 X)) 256)
    (NATP (NTH 4 (NTH 1 X))) (< (NTH 4 (NTH 1 X)) 256)
    (NATP (NTH 5 (NTH 1 X))) (< (NTH 5 (NTH 1 X)) 256)
    (NATP (NTH 6 (NTH 1 X))) (< (NTH 6 (NTH 1 X)) 256)
    (NATP (NTH 7 (NTH 1 X))) (< (NTH 7 (NTH 1 X)) 256)
    (NATP (NTH 8 (NTH 1 X))) (< (NTH 8 (NTH 1 X)) 256)
    (NATP (NTH 9 (NTH 1 X))) (< (NTH 9 (NTH 1 X)) 256)
    (NATP (NTH 10 (NTH 1 X))) (< (NTH 10 (NTH 1 X)) 256)
    (NATP (NTH 11 (NTH 1 X))) (< (NTH 11 (NTH 1 X)) 256)
    (NATP (NTH 12 (NTH 1 X))) (< (NTH 12 (NTH 1 X)) 256)
    (NATP (NTH 13 (NTH 1 X))) (< (NTH 13 (NTH 1 X)) 256)
    (NATP (NTH 14 (NTH 1 X))) (< (NTH 14 (NTH 1 X)) 256)
    (NATP (NTH 15 (NTH 1 X))) (< (NTH 15 (NTH 1 X)) 256)))

(DEFUND |ind_aes| (|tmp_2|)
  (IF (NOT (AND (|$ind_13_typep| |tmp_2|)))
    (LIST 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
    (|ind_encrypt_1|
      (LIST (NTH 0 |tmp_2|) (|ind_keySchedule_1| (NTH 1 |tmp_2|))))))

(DEFUND |ind_sea| (|tmp_1|)
  (IF (NOT (AND (|$ind_13_typep| |tmp_1|)))
    (LIST 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
    (|ind_decrypt_1|
      (LIST (NTH 0 |tmp_1|) (|ind_keySchedule_1| (NTH 1 |tmp_1|))))))
