(in-package "ACL2")

(local (include-book "../support/setbitn"))

;; Necessary defuns:

(defun natp (x)
  (declare (xargs :guard t))
  (and (integerp x)
       (<= 0 x)))

(defund bvecp (x k)
  (declare (xargs :guard (integerp k)))
  (and (integerp x)
       (<= 0 x)
       (< x (expt 2 k))))

(defund fl (x)
  (declare (xargs :guard (real/rationalp x)))
  (floor x 1))

(defund bits (x i j)
  (declare (xargs :guard (rationalp x)))
  (if (or (not (integerp i))
          (not (integerp j)))
      0
    (fl (/ (mod x (expt 2 (1+ i))) (expt 2 j)))))

(defund bitn (x n)
    (declare (xargs :guard (rationalp x)))
  (bits x n n))

(defund binary-cat (x m y n)
  (declare (xargs :guard (and (rationalp x)
                              (acl2-numberp m)
                              (rationalp y)
                              (acl2-numberp n))))
  (if (or (not (integerp m))
          (< m 0)
          (not (integerp n))
          (< n 0)
          )
      0
    (+ (* (expt 2 n) (bits x (+ -1 m) 0))
       (bits y (+ -1 n) 0))))

(defun formal-+ (x y)
  (declare (xargs :guard t))
  (if (and (acl2-numberp x) (acl2-numberp y))
      (+ x y)
    (list '+ x y)))

(defun cat-size-fn (x)
  (declare (xargs :guard (and (true-listp x)
                              (evenp (length x)))))
  (if (endp (rest (rest x)))
      (second x)
    (formal-+ (second x)
              (cat-size-fn (rest (rest x))))))

(defmacro cat-size (&rest x)
  (declare (xargs :guard (and (true-listp x)
                              (evenp (length x))
                              (>= (length x) 2))))
  (cat-size-fn x))

(defmacro cat (&rest x)
  (declare (xargs :guard (and (true-listp x) (evenp (length x)))))
  (cond ((endp x) ;special case 1
         `0)
        ((endp (rest (rest x))) ;special case 2
         `(bits ,(first x) ,(formal-+ -1 (second x)) 0))
        ((endp (rest (rest (rest (rest x))))) ;this is really the base case
         `(binary-cat ,@x))
        (t
         `(binary-cat ,(first x) 
                       ,(second x) 
                       (cat ,@(rest (rest x))) 
                       (cat-size ,@(rest (rest x)))))))

(add-macro-alias cat binary-cat)

(defund setbits (x w i j y)
  (declare (xargs :guard (and (rationalp x) (rationalp y)
                              (acl2-numberp i) (acl2-numberp j) (acl2-numberp w))))
  (cat (bits x (+ -1 w) (+ 1 i))
       (+ -1 w (- i))
       (cat (bits y (+ i (- j)) 0)
            (+ 1 i (- j))
            (bits x (+ -1 j) 0)
            j)
       (+ 1 i)))

;;
;; New stuff:
;;

(defund setbitn (x w n y)
  (declare (xargs :guard (and (rationalp x) (rationalp y)
                              (acl2-numberp n) (acl2-numberp w))))
  (setbits x w n n y))

(defthm setbitn-nonnegative-integer-type
  (and (integerp (setbitn x w n y))
       (<= 0 (setbitn x w n y)))
  :rule-classes (:type-prescription))

;this rule is no better than setbits-nonnegative-integer-type and might be worse:
(in-theory (disable (:type-prescription setbitn)))

(defthm setbitn-natp
  (natp (setbitn x w n y)))

;add setbitn-bvecp-simple?

(defthm setbitn-bvecp
  (implies (and (<= w k)
                (case-split (integerp k)))
           (bvecp (setbitn x w n y) k)))

(defthm setbitn-rewrite
  (implies (syntaxp (quotep n))
           (equal (setbitn x w n y)
                  (setbits x w n n y))))

;gen?
(defthm bitn-setbitn
  (implies (and (case-split (bvecp y 1))
                (case-split (< 0 w))
                (case-split (< n w))
                (case-split (< k w))
                (case-split (<= 0 k))
                (case-split (integerp w))
                (case-split (integerp n))
                (<= 0 n)
                (case-split (integerp k))
                )
           (equal (bitn (setbitn x w n y) k)
                  (if (equal n k)
                      y
                    (bitn x k)))))

(defthm setbitn-setbitn
  (implies (and (case-split (<= 0 n))
                (case-split (< n w))
                (case-split (integerp w))
                (case-split (integerp n))
                )
           (equal (setbitn (setbitn x w n y) w n y2)
                  (setbitn x w n y2))))

(defthm setbitn-does-nothing
  (implies (and (case-split (<= 0 n))
                (case-split (< n w))
                (case-split (integerp w))
                (case-split (integerp n))
                )
           (equal (setbitn x w n (bitn x n))
                  (bits x (+ -1 w) 0))))

