(in-package "ACL2")

;(include-book "lop3")
(include-book "add")

; kept one proof from breaking
;(in-theory (disable bitn-def))

; Seemingly needed for rel2 in v2-8 for top-13 (which remained unproved for at
; least about an hour), because of fix for handling free variables.  Probably
; needed for rel3 too.
(add-match-free-override :once (:linear expt-monotone-linear))

; Seemingly needed for rel2 (actually rem-bnd-3) in v2-8 for stick-lemma; at
; the least, speeds it up greatly.  Makes a bug difference here in top-13;
; didn't wait to see if that eventually proves without this.
(add-match-free-override :once (:linear mod-bnd-3))

(defun SIGM (a b c n)
  (if (= c 0)
      (comp1 (logxor a b) n)
    (logxor a b)))

(defun KAP (a b c)
  (if (= c 0)
      (* 2 (logior a b))
    (* 2 (logand a b))))

(defun TAU (a b c n)
  (comp1 (logxor (sigm a b c n) (kap a b c)) (1+ n)))

(local (in-theory (disable logxor logand logior)))

(defthm SIGM-BNDS
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n)))
	     (and (integerp (sigm a b c n))
		  (>= (sigm a b c n) 0)
		  (< (sigm a b c n) (expt 2 n))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable comp1)
           :use ((:instance logxor<2**n (x a) (y b))
			(:instance logxor-nat (i a) (j b))))))

(local (in-theory (disable LOGIOR-NAT-REWRITE LOGAND-NAT-REWRITE)))

(defthm KAP-BNDS
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n)))
	     (and (integerp (kap a b c))
		  (>= (kap a b c) 0)
		  (< (kap a b c) (expt 2 (1+ n)))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance or-dist-a (x a) (y b))
			(:instance and-dist-a (x a) (y b))
			(:instance logior-nat (i a) (j b))
			(:instance logand-nat (i a) (j b))))))

(defthm TAU-BNDS
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n)))
	     (and (integerp (tau a b c n))
		  (>= (tau a b c n) 0)
		  (< (tau a b c n) (expt 2 (1+ n)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable comp1)
                              '(sigm kap))
		  :use (sigm-bnds
			kap-bnds
			(:instance logxor<2**n (x (sigm a b c n)) (y (kap a b c)) (n (1+ n)))
			(:instance logxor-nat (i (sigm a b c n)) (j (kap a b c)))))))

(local (defthm top-1
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n))
		  (integerp k)
		  (>= k 0)
		  (<= k n)
		  (or (= c 0) (= c 1)))
	     (not (= (bitn (tau a b c n) k)
		     (bitn (logxor (sigm a b c n) (kap a b c)) k))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable comp1 sigm kap)
		  :use (sigm-bnds
			kap-bnds
			(:instance bitn-comp1-thm (x (logxor (sigm a b c n) (kap a b c))) (n (1+ n)))
			(:instance logxor<2**n (x (sigm a b c n)) (y (kap a b c)) (n (1+ n)))
			(:instance logxor-nat (i (sigm a b c n)) (j (kap a b c))))))))

(local (defthm top-2
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n))
		  (integerp k)
		  (>= k 0)
		  (<= k n)
		  (or (= c 0) (= c 1)))
	     (iff (= (bitn (logxor (sigm a b c n) (kap a b c)) k)
		     (bitn (sigm a b c n) k))
		  (= (bitn (kap a b c) k)
		     0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable comp1 sigm kap)
		  :use (sigm-bnds
			kap-bnds
			(:instance bitn-0-1 (x (sigm a b c n)) (n k))
			(:instance bitn-0-1 (x (kap a b c)) (n k))
			(:instance bitn-logxor (x (sigm a b c n)) (y (kap a b c)) (n k)))))))

(local (defthm top-3
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n))
		  (integerp k)
		  (>= k 0)
		  (<= k n)
		  (or (= c 0) (= c 1)))
	     (iff (= (bitn (tau a b c n) k)
		     (bitn (sigm a b c n) k))
		  (= (bitn (kap a b c) k)
		     1)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable comp1 tau sigm kap)
		  :use (top-1
			top-2
			(:instance bitn-0-1 (x (sigm a b c n)) (n k))
			(:instance bitn-0-1 (x (logxor (sigm a b c n) (kap a b c))) (n k))
			(:instance bitn-0-1 (x (kap a b c)) (n k))
			(:instance bitn-0-1 (x (tau a b c n)) (n k)))))))


(local (defun nat-induct (k)
  (if (and (integerp k) (>= k 0))
      (if (= k 0)
	  0
	(nat-induct (1- k)))
    0)))

(local (defthm top-4
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp b)
		  (>= b 0))
	     (= (bitn (kap a b c) 0)
		0))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bit+*k (x 0) (k (logior a b)) (m 1) (n 0))
			(:instance logior-nat (i a) (j b))
			(:instance bit+*k (x 0) (k (logand a b)) (m 1) (n 0))
			(:instance logand-nat (i a) (j b)))))))

(local (defthm top-5
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n))
		  (or (= c 0) (= c 1)))		  
	     (not (= (bitn (tau a b c n) 0)
		     (bitn (sigm a b c n) 0))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable comp1 tau sigm kap)
		  :use (top-4
			(:instance top-3 (k 0)))))))

(local (defthm top-6
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp b)
		  (>= b 0))
	     (= (bitn (+ a b) 0)
		(bitn (logxor a b) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable bitn-def)
                              '( logxor))
		  :use ((:instance mod012 (x a))
			(:instance mod012 (x b))
			(:instance bitn-logxor (x a) (y b) (n 0))
			(:instance mod+mod (n 2))
			(:instance mod+mod (n 2) (a (mod b 2)) (b a)))))))

(local (defthm top-7
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N)))
	     (IFF (= (bitn (+ A B) 0) 0)
		  (= (bitn (TAU A B 0 N) 0) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable bitn-def comp1 logxor)
		  :use (top-6
			(:instance top-5 (c 0))
			(:instance logxor-nat (i a) (j b))
			(:instance logxor<2**n (x a) (y b))
			(:instance bitn-comp1-thm (k 0) (x (logxor a b)))
			(:instance bitn-0-1 (x (tau a b 0 n)) (n 0))
			(:instance bitn-0-1 (x (sigm a b 0 n)) (n 0))
			(:instance bitn-0-1 (x (logxor a b)) (n 0)))))))

(local (defthm top-8
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N)))
	     (IFF (= (mod (+ A B) 2) 0)
		  (= (mod (TAU A B 0 N) 2) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable bitn-def)
                              '( tau))
		  :use (top-7
			(:instance tau-bnds (c 0)))))))

(local (in-theory (enable bitn-def)))

(local (defthm top-9
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp b)
		  (>= b 0))
	     (not (= (bitn (+ a b 1) 0)
		     (bitn (logxor a b) 0))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable logxor)
		  :use (top-6
			(:instance mod+1-2 (x (+ a b))))))))

(local (defthm top-10
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N)))
	     (IFF (= (bitn (+ A B 1) 0) 0)
		  (= (bitn (TAU A B 1 N) 0) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable bitn-def comp1 logxor)
		  :use (top-9
			(:instance top-5 (c 1))
			(:instance logxor-nat (i a) (j b))
			(:instance logxor<2**n (x a) (y b))
			(:instance bitn-0-1 (x (tau a b 1 n)) (n 0))
			(:instance bitn-0-1 (x (sigm a b 1 n)) (n 0))
			(:instance bitn-0-1 (x (+ a b 1)) (n 0)))))))

(local (defthm top-11
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N)))
	     (IFF (= (mod (+ A B 1) 2) 0)
		  (= (mod (TAU A B 1 N) 2) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable tau)
		  :use (top-10
			(:instance tau-bnds (c 1)))))))

(local (in-theory (disable bitn-def)))

(local (defthm top-12
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (OR (= C 0) (= C 1)))
	     (IFF (= (MOD (+ A B C) 2) 0)
		  (= (MOD (TAU A B C N) 2) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable tau)
		  :use (top-11 top-8)))))

#| dedundant
(defthm MOD-N-N+1
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (> n 0))
	     (iff (= (mod a (expt 2 (1+ n))) 0)
		  (and (= (mod a (expt 2 n)) 0)
		       (= (bitn a n) 0))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance mod-n+1)
			(:instance mod>=0 (m a) (n (expt 2 n)))
			(:instance bitn-0-1 (x a))))))
|#

(local (defthm top-13
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (IMPLIES (AND (INTEGERP N)
				(<= 0 N)
				(INTEGERP A)
				(<= 0 A)
				(< A (EXPT 2 N))
				(INTEGERP B)
				(<= 0 B)
				(< B (EXPT 2 N))
				(INTEGERP (+ -1 K))
				(<= 0 (+ -1 K))
				(< (+ -1 K) N)
				(OR (= C 0) (= C 1)))
			   (IFF (= (MOD (+ A B C) (EXPT 2 k))  0)
				(= (MOD (TAU A B C N) (EXPT 2 k)) 0)))
		  (not (and (= (MOD (+ A B C) (EXPT 2 k))  0)
			    (= (MOD (TAU A B C N) (EXPT 2 k)) 0)))
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N)
		  (OR (= C 0) (= C 1)))
	     (IFF (= (MOD (+ A B C) (EXPT 2 (+ 1 K))) 0)
		  (= (MOD (TAU A B C N) (EXPT 2 (+ 1 K)))
		     0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable tau)
		  :use (tau-bnds
			(:instance mod-n-n+1 (a (tau a b c n)) (n k))
			(:instance mod-n-n+1 (a (+ a b c)) (n k)))))))

(local (defthm top-14
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B C) (EXPT 2 k))  0)
		  (= (MOD (TAU A B C N) (EXPT 2 k)) 0)
		  (= (bitn (+ a b c) k) (bitn (tau a b c n) k))
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N)
		  (OR (= C 0) (= C 1)))
	     (IFF (= (MOD (+ A B C) (EXPT 2 (+ 1 K))) 0)
		  (= (MOD (TAU A B C N) (EXPT 2 (+ 1 K)))
		     0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable tau)
		  :use (tau-bnds
			(:instance mod-n-n+1 (a (tau a b c n)) (n k))
			(:instance mod-n-n+1 (a (+ a b c)) (n k)))))))

(local (defthm top-15
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp k)
		  (>= k 0))
	     (equal (fl (/ a (expt 2 k)))
		    (+ (* 2 (fl (/ a (expt 2 (1+ k)))))
		       (bitn a k))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bitn-def)
		  :use ((:instance mod-fl (m (fl (/ a (expt 2 k)))) (n 2))
			(:instance fl/int-rewrite (x (/ a (expt 2 k))) (n 2)))))))

(local (defthm hack-0
    (implies (equal a x)
	     (equal (/ a (expt 2 k))
		    (/ x (expt 2 k))))
  :rule-classes ()))

(local (defthm top-16-1
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp k)
		  (>= k 0))
	     (equal (/ a (expt 2 k))
		    (/ (+ (* (expt 2 k) (fl (/ a (expt 2 k))))
			  (mod a (expt 2 k)))
		       (expt 2 k))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance mod-fl (m a) (n (expt 2 k)))
			(:instance hack-0 
				   (x (+ (* (EXPT 2 K) (FL (* A (/ (EXPT 2 K)))))
					 (MOD A (EXPT 2 K))))))))))

(local (defthm top-16-2
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp k)
		  (>= k 0))
	     (equal (/ a (expt 2 k))
		    (+ (/ (* (expt 2 k) (fl (/ a (expt 2 k)))) (expt 2 k))
		       (/ (mod a (expt 2 k)) (expt 2 k)))))
  :rule-classes ()
  :hints (("Goal" :use (top-16-1)))))

(local (defthm top-16
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp k)
		  (>= k 0))
	     (equal (/ a (expt 2 k))
		    (+ (fl (/ a (expt 2 k)))
		       (/ (mod a (expt 2 k)) (expt 2 k)))))
  :rule-classes ()
  :hints (("Goal" :use (top-16-2)))))

(local (defthm hack1
    (implies (and (rationalp x)
		  (rationalp y)
		  (rationalp z)
		  (rationalp u)
		  (rationalp v)
		  (rationalp w)
		  (= x (+ y z))
		  (= u (+ x v)))
	     (= u (+ y z v)))
  :rule-classes ()))

(local (defthm top-17
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp k)
		  (>= k 0))
	     (= (/ a (expt 2 k))
		(+ (* 2 (fl (/ a (expt 2 (1+ k)))))
		   (bitn a k)
		   (/ (mod a (expt 2 k)) (expt 2 k)))))
  :rule-classes ()
  :hints (("Goal" :use (top-15
			top-16
			(:instance hack1
				   (x (fl (/ a (expt 2 k))))
				   (y (* 2 (fl (/ a (expt 2 (1+ k))))))
				   (z (bitn a k))
				   (u (/ a (expt 2 k)))
				   (v (/ (mod a (expt 2 k)) (expt 2 k)))
				   (w 0)))))))

(local (defthm hack-2
    (implies (and (rationalp a)
		  (rationalp a1)
		  (rationalp a2)
		  (rationalp b)
		  (rationalp b1)
		  (rationalp b2)
		  (rationalp k)
		  (rationalp c)
		  (> k 0)
		  (= (/ a k) (+ a1 (/ a2 k)))
		  (= (/ b k) (+ b1 (/ b2 k))))
	     (= (/ (+ a b c) k) (+ a1 b1 (/ (+ a2 b2 c) k))))
  :rule-classes ()))

(local (defthm top-18
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B C) (EXPT 2 k))  0)
		  (= (MOD (TAU A B C N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N)
		  (OR (= C 0) (= C 1)))
	     (= (/ (+ a b c) (expt 2 k))
		(+ (bitn a k)
		   (bitn b k)
		   (* 2 (fl (/ a (expt 2 (1+ k)))))
		   (* 2 (fl (/ b (expt 2 (1+ k)))))
		   (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
		      (expt 2 k)))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance top-17)
			(:instance top-17 (a b))
			(:instance hack-2
				   (a1 (+ (* 2 (fl (/ a (expt 2 (1+ k))))) (bitn a k)))
				   (a2 (mod a (expt 2 k)))
				   (b1 (+ (* 2 (fl (/ b (expt 2 (1+ k))))) (bitn b k)))
				   (b2 (mod b (expt 2 k)))
				   (k (expt 2 k))))))))

(local (defthm top-19
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B C) (EXPT 2 k))  0)
		  (= (MOD (TAU A B C N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N)
		  (OR (= C 0) (= C 1)))
	     (= (fl (/ (+ a b c) (expt 2 k)))
		(+ (bitn a k)
		   (bitn b k)
		   (* 2 (fl (/ a (expt 2 (1+ k)))))
		   (* 2 (fl (/ b (expt 2 (1+ k)))))
		   (fl (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
			  (expt 2 k))))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable fl+int-rewrite)
           :use ((:instance top-18)
			(:instance fl+int-rewrite
				   (x (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
					 (expt 2 k)))
				   (n (+ (bitn a k)
					 (bitn b k)
					 (* 2 (fl (/ a (expt 2 (1+ k)))))
					 (* 2 (fl (/ b (expt 2 (1+ k)))))))))))))

(local (defthm top-20
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B C) (EXPT 2 k))  0)
		  (= (MOD (TAU A B C N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N)
		  (OR (= C 0) (= C 1)))
	     (= (mod (+ (bitn a k)
			(bitn b k)
			(* 2 (fl (/ a (expt 2 (1+ k)))))
			(* 2 (fl (/ b (expt 2 (1+ k)))))
			(fl (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
			       (expt 2 k))))
		     2)
		(mod (+ (bitn a k)
			(bitn b k)
			(fl (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
			       (expt 2 k))))
		     2)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance mod+-thm
				   (m (+ (bitn a k)
					 (bitn b k)
					 (fl (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
						(expt 2 k)))))
				   (a (+ (fl (/ a (expt 2 (1+ k))))
					 (fl (/ b (expt 2 (1+ k))))))
				   (n 2))
			(:instance bitn-0-1 (x a) (n k))
			(:instance bitn-0-1 (x b) (n k))
			(:instance n<=fl-linear (n 0) (x (/ a (expt 2 (1+ k)))))
			(:instance n<=fl-linear (n 0) (x (/ b (expt 2 (1+ k)))))
			(:instance n<=fl-linear (n 0) (x (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
						     (expt 2 k))))
			(:instance mod>=0 (m a) (n (expt 2 k)))
			(:instance mod>=0 (m b) (n (expt 2 k))))))))

(local (defthm top-21
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B C) (EXPT 2 k))  0)
		  (= (MOD (TAU A B C N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N)
		  (OR (= C 0) (= C 1)))
	     (= (mod (fl (/ (+ a b c) (expt 2 k))) 2)
		(mod (+ (bitn a k)
			(bitn b k)
			(fl (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
			       (expt 2 k))))
		     2)))
  :rule-classes ()
  :hints (("Goal" :hands-off (mod bitn fl expt)
		  :use (top-19 top-20)))))

(local (defthm top-22
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B C) (EXPT 2 k))  0)
		  (= (MOD (TAU A B C N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N)
		  (OR (= C 0) (= C 1)))
	     (= (bitn (+ a b c) k)
		(mod (+ (bitn a k)
			(bitn b k)
			(fl (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
			       (expt 2 k))))
		     2)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bitn-def)
		  :use (top-21)))))

(local (defthm top-23
    (implies (and (integerp a)
		  (integerp b)
		  (integerp k)
		  (>= a 0)
		  (>= b 0)
		  (>= k 0))
	     (= (bitn (logxor a b) k)
		(mod (+ (bitn a k) (bitn b k)) 2)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bitn-logxor (x a) (y b) (n k))
			(:instance bitn-0-1 (x a) (n k))
			(:instance bitn-0-1 (x b) (n k)))))))

#| redundant
(defthm MOD-X-Y-X-2
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp y)
		  (>= y 0))
	     (iff (= (mod (+ x y) 2) (mod x 2))
		  (= (mod y 2) 0)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance mod012 (x y))
			(:instance mod+mod (a x) (b y) (n 2))
			(:instance mod+1-2)))))
|#

(local (defthm top-24
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B C) (EXPT 2 k))  0)
		  (= (MOD (TAU A B C N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N)
		  (OR (= C 0) (= C 1)))
	     (iff (= (bitn (+ a b c) k)
		     (mod (+ (bitn a k) (bitn b k)) 2))
		  (= (mod (fl (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
				 (expt 2 k)))
			  2)
		     0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable bitn-def)
           :use (top-22
			(:instance mod-x-y-x-2
				   (x (+ (bitn a k) (bitn b k)))
				   (y (fl (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
					     (expt 2 k)))))
			(:instance n<=fl-linear
				   (n 0)
				   (x (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
					 (expt 2 k))))
			(:instance mod>=0 (m a) (n (expt 2 k)))
			(:instance mod>=0 (m b) (n (expt 2 k))))))))

(local (defthm top-25
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B C) (EXPT 2 k))  0)
		  (= (MOD (TAU A B C N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N)
		  (OR (= C 0) (= C 1)))
	     (iff (= (bitn (+ a b c) k)
		     (bitn (logxor a b) k))
		  (= (mod (fl (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
				 (expt 2 k)))
			  2)
		     0)))
  :rule-classes ()
  :hints (("Goal" :use (top-24 top-23)))))

(local (defthm top-26
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp b) 
		  (>= b 0)
		  (integerp k)
		  (>= k 0)
		  (or (= c 0) (= c 1)))
	     (< (+ (mod a (expt 2 k))
		   (mod b (expt 2 k))
		   c)
		(expt 2 (1+ k))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance mod<n (m a) (n (expt 2 k)))
			(:instance mod<n (m b) (n (expt 2 k)))
			(:instance expo+ (m k) (n 1)))))))

(local (defthm top-27
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp b) 
		  (>= b 0)
		  (integerp k)
		  (>= k 0)
		  (or (= c 0) (= c 1)))
	     (< (/ (+ (mod a (expt 2 k))
		      (mod b (expt 2 k))
		      c)
		   (expt 2 k))
		2))
  :rule-classes ()
  :hints (("Goal" :use (top-26
			(:instance *-strongly-monotonic
				   (x (expt 2 (- k)))
				   (y (+ (mod a (expt 2 k))
					 (mod b (expt 2 k))
					 c))
				   (y+ (expt 2 (1+ k)))))))))

(local (defthm top-28
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp b) 
		  (>= b 0)
		  (integerp k)
		  (>= k 0)
		  (or (= c 0) (= c 1)))
	     (< (fl (/ (+ (mod a (expt 2 k))
			  (mod b (expt 2 k))
			  c)
		       (expt 2 k)))
		2))
  :rule-classes ()
  :hints (("Goal" :use (top-27
			(:instance fl-def-linear (x (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c) (expt 2 k)))))))))

(local (defthm top-29
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp b) 
		  (>= b 0)
		  (integerp k)
		  (>= k 0)
		  (or (= c 0) (= c 1)))
	     (>= (fl (/ (+ (mod a (expt 2 k))
			   (mod b (expt 2 k))
			   c)
			(expt 2 k)))
		 0))
  :rule-classes ()
  :hints (("Goal" :use ((:instance n<=fl-linear
				   (n 0) 
				   (x (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c) (expt 2 k))))
			(:instance mod>=0 (m a) (n (expt 2 k)))
			(:instance mod>=0 (m b) (n (expt 2 k))))))))

(local (defthm top-30
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp b) 
		  (>= b 0)
		  (integerp k)
		  (>= k 0)
		  (or (= c 0) (= c 1)))
	     (= (mod (fl (/ (+ (mod a (expt 2 k))
			       (mod b (expt 2 k))
			       c)
			    (expt 2 k)))
		     2)
		(fl (/ (+ (mod a (expt 2 k))
			  (mod b (expt 2 k))
			  c)
		       (expt 2 k)))))
  :rule-classes ()
  :hints (("Goal" :use (top-28
			top-29
			(:instance mod<
				   (m (fl (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c) (expt 2 k))))
				   (n 2)))))))

(local (defthm top-31
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B C) (EXPT 2 k))  0)
		  (= (MOD (TAU A B C N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N)
		  (OR (= C 0) (= C 1)))
	     (iff (= (bitn (+ a b c) k)
		     (bitn (logxor a b) k))
		  (= (fl (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
			    (expt 2 k)))
		     0)))
  :rule-classes ()
  :hints (("Goal" :use (top-25 top-30)))))

(local (defthm top-32
    (implies (and (rationalp x)
		  (>= (fl x) 0))
	     (iff (= (fl x) 0) (< x 1)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance fl-unique (n 0))
			(:instance fl-def-linear))))))

(local (defthm top-33
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B C) (EXPT 2 k))  0)
		  (= (MOD (TAU A B C N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N)
		  (OR (= C 0) (= C 1)))
	     (iff (= (bitn (+ a b c) k)
		     (bitn (logxor a b) k))
		  (< (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
			(expt 2 k))
		     1)))
  :rule-classes ()
  :hints (("Goal" :use (top-31 
			top-29
			(:instance top-32 (x (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c) (expt 2 k)))))))))

(local (defthm top-34
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B C) (EXPT 2 k))  0)
		  (= (MOD (TAU A B C N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N)
		  (OR (= C 0) (= C 1)))
	     (iff (= (bitn (+ a b c) k)
		     (bitn (logxor a b) k))
		  (< (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
		     (expt 2 k))))
  :rule-classes ()
  :hints (("Goal" :use (top-33
			(:instance *-strongly-monotonic
				   (x (expt 2 (- k)))
				   (y (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c))
				   (y+ (expt 2 k)))
			(:instance *-strongly-monotonic
				   (x (expt 2 k))
				   (y (/ (+ (mod a (expt 2 k)) (mod b (expt 2 k)) c)
					 (expt 2 k)))
				   (y+ 1)))))))
#|
(defthm BITN-N+K
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp n)
		  (>= n 0)
		  (integerp k)
		  (>= k 0))
	     (= (bitn (* x (expt 2 k)) (+ n k))
		(bitn x n)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable bitn-def)
		  :use ((:instance expo+ (m k))))))
|#


(local (defthm top-35
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n))
		  (integerp k)
		  (> k 0)
		  (<= k n))
	     (iff (= (bitn (kap a b 0) k) 0)
		  (and (= (bitn a (1- k)) 0)
		       (= (bitn b (1- k)) 0))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bitn-n+k (k 1) (n (1- k)) (x (logior a b)))
			(:instance bitn-0-1 (x a) (n (1- k)))
			(:instance bitn-0-1 (x b) (n (1- k)))
			(:instance logior-nat (i a) (j b))
			(:instance bit-dist-b (x a) (y b) (n (1- k))))))))

(local (defthm top-36
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp k)
		  (> k 0))
	     (iff (= (bitn a (1- k)) 0)
		  (< (mod a (expt 2 k)) (expt 2 (1- k)))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bit-mod (x a) (n k) (k (1- k)))
			(:instance mod>=0 (m a) (n (expt 2 k)))
			(:instance mod<n (m a) (n (expt 2 k)))
			(:instance bit-expo-a (x (mod a (expt 2 k))) (n (1- k)))
			(:instance bit-expo-b (x (mod a (expt 2 k))) (n (1- k))))))))

(local (defthm top-37
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n))
		  (integerp k)
		  (> k 0)
		  (<= k n)
		  (= (bitn (kap a b 0) k) 0))
	     (< (+ (mod a (expt 2 k))
		   (mod b (expt 2 k)))
		(expt 2 k)))
  :rule-classes ()
  :hints (("Goal" :use (top-35
			top-36
			(:instance top-36 (a b)))))))

(local (defthm top-38
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n))
		  (integerp k)
		  (> k 0)
		  (<= k n)
		  (not (= (bitn (kap a b 0) k) 0)))
	     (>= (+ (mod a (expt 2 k))
		    (mod b (expt 2 k)))
		 (expt 2 (1- k))))
  :rule-classes ()
  :hints (("Goal" :use (top-35
			top-36
			(:instance top-36 (a b))
			(:instance mod>=0 (m a) (n (expt 2 k)))
			(:instance mod>=0 (m b) (n (expt 2 k))))))))

(local (defthm top-39
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (= (mod (+ a b) (expt 2 k)) 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n))
		  (integerp k)
		  (> k 0)
		  (<= k n)
		  (not (= (bitn (kap a b 0) k) 0)))
	     (>= (+ (mod a (expt 2 k))
		    (mod b (expt 2 k)))
		 (expt 2 k)))
  :rule-classes ()
  :hints (("Goal" :use (top-38
			(:instance mod+mod (n (expt 2 k)))
			(:instance mod>=0 (m a) (n (expt 2 k)))
			(:instance mod>=0 (m b) (n (expt 2 k)))
			(:instance mod+mod (a (mod b (expt 2 k))) (b a) (n (expt 2 k)))
			(:instance mod< (m (+ (mod a (expt 2 k)) (mod b (expt 2 k)))) (n (expt 2 k))))))))

(local (defthm top-40
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (= (mod (+ a b) (expt 2 k)) 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n))
		  (integerp k)
		  (> k 0)
		  (<= k n))
	     (iff (= (bitn (kap a b 0) k) 0)
		  (< (+ (mod a (expt 2 k))
			(mod b (expt 2 k)))
		     (expt 2 k))))
  :rule-classes ()
  :hints (("Goal" :use (top-39 top-37)))))

(local (defthm top-41
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B) (EXPT 2 k))  0)
		  (= (MOD (TAU A B 0 N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N))
	     (iff (= (bitn (+ a b) k)
		     (bitn (logxor a b) k))
		  (= (bitn (kap a b 0) k)
		     0)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance top-34 (c 0)) top-40)))))

(local (defthm top-42
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B) (EXPT 2 k))  0)
		  (= (MOD (TAU A B 0 N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N))
	     (= (bitn (+ a b) k) (bitn (tau a b 0 n) k)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable comp1 tau)
		  :use (top-41
			(:instance top-3 (c 0))
			(:instance bitn-0-1 (x (kap a b 0)) (n k))
			(:instance bitn-0-1 (x (logxor a b)) (n k))
			(:instance bitn-0-1 (x (sigm a b 0 n)) (n k))
			(:instance bitn-0-1 (x (tau a b 0 n)) (n k))
			(:instance bitn-0-1 (x (+ a b)) (n k))
			(:instance bitn-comp1-thm (x (logxor a b)))
			(:instance logxor<2**n (x a) (y b))
			(:instance logxor-nat (i a) (j b)))))))

#| redundant
(defthm MOD-M=N
    (implies (and (integerp m)
		  (> m 0)
		  (integerp n)
		  (> n 0)
		  (< m (* 2 n))
		  (= (mod m n) 0))
	     (= m n))
  :rule-classes ()
  :hints (("Goal" :use ((:instance mod<)
			(:instance mod< (m (- m n)))
			(:instance mod+-thm (m (- m n)) (a 1))))))
|#

(local (defthm top-43
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B 1) (EXPT 2 k))  0)
		  (= (MOD (TAU A B 1 N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N))
	     (= (+ (mod a (expt 2 k))
		   (mod b (expt 2 k))
		   1)
		(expt 2 k)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable tau)
		  :use ((:instance top-26 (c 1))
			(:instance mod-m=n
				   (m (+ (mod a (expt 2 k)) (mod b (expt 2 k)) 1))
				   (n (expt 2 k)))
			(:instance mod>=0 (n (expt 2 k)) (m a))
			(:instance mod>=0 (n (expt 2 k)) (m b))
			(:instance mod+mod (n (expt 2 k)) (a (+ (mod a (expt 2 k)) 1)))
			(:instance mod+mod (n (expt 2 k)) (a (+ b 1)) (b a)))))))

(local (defthm top-44
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B 1) (EXPT 2 k))  0)
		  (= (MOD (TAU A B 1 N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N))
	     (not (= (bitn (+ a b 1) k)
		     (bitn (logxor a b) k))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable tau)
		  :use (top-43
			(:instance top-34 (c 1)))))))

(local (defthm top-45
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n))
		  (integerp k)
		  (> k 0)
		  (<= k n))
	     (iff (= (bitn (kap a b 1) k) 1)
		  (and (= (bitn a (1- k)) 1)
		       (= (bitn b (1- k)) 1))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bitn-n+k (k 1) (n (1- k)) (x (logand a b)))
			(:instance bitn-0-1 (x a) (n (1- k)))
			(:instance bitn-0-1 (x b) (n (1- k)))
			(:instance logand-nat (i a) (j b))
			(:instance bit-dist-a (x a) (y b) (n (1- k))))))))

(local (defthm top-46
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n))
		  (integerp k)
		  (> k 0)
		  (<= k n)
		  (= (bitn (kap a b 1) k) 1))
	     (>= (+ (mod a (expt 2 k))
		    (mod b (expt 2 k)))
		 (expt 2 k)))
  :rule-classes ()
  :hints (("Goal" :use (top-45
			top-36
			(:instance top-36 (a b)))))))

(local (defthm top-47
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B 1) (EXPT 2 k))  0)
		  (= (MOD (TAU A B 1 N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N))
	     (= (bitn (kap a b 1) k) 0))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable tau)
		  :use (top-46
			top-43
			(:instance bitn-0-1 (x (kap a b 1)) (n k)))))))

(local (defthm top-48
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B 1) (EXPT 2 k))  0)
		  (= (MOD (TAU A B 1 N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N))
	     (= (bitn (+ a b 1) k) (bitn (tau a b 1 n) k)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable tau)
		  :use (top-47
			top-44
			(:instance top-3 (c 1))
			(:instance bitn-0-1 (x (logxor a b)) (n k))
			(:instance bitn-0-1 (x (sigm a b 1 n)) (n k))
			(:instance bitn-0-1 (x (tau a b 1 n)) (n k))
			(:instance bitn-0-1 (x (+ a b 1)) (n k)))))))

(local (defthm top-49
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (= (MOD (+ A B C) (EXPT 2 k))  0)
		  (= (MOD (TAU A B C N) (EXPT 2 k)) 0)
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N)
		  (OR (= C 0) (= C 1)))
	     (= (bitn (+ a b c) k) (bitn (tau a b c n) k)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable tau)
		  :use (top-48 top-42)))))

(local (defthm top-50
    (IMPLIES (AND (INTEGERP K) 
		  (< 0 K)
		  (IMPLIES (AND (INTEGERP N)
				(<= 0 N)
				(INTEGERP A)
				(<= 0 A)
				(< A (EXPT 2 N))
				(INTEGERP B)
				(<= 0 B)
				(< B (EXPT 2 N))
				(INTEGERP (+ -1 K))
				(<= 0 (+ -1 K))
				(< (+ -1 K) N)
				(OR (= C 0) (= C 1)))
			   (IFF (= (MOD (+ A B C) (EXPT 2 k))  0)
				(= (MOD (TAU A B C N) (EXPT 2 k)) 0)))
		  (INTEGERP N)
		  (<= 0 N)
		  (INTEGERP A)
		  (<= 0 A)
		  (< A (EXPT 2 N))
		  (INTEGERP B)
		  (<= 0 B)
		  (< B (EXPT 2 N))
		  (INTEGERP K)
		  (<= 0 K)
		  (< K N)
		  (OR (= C 0) (= C 1)))
	     (IFF (= (MOD (+ A B C) (EXPT 2 (+ 1 K))) 0)
		  (= (MOD (TAU A B C N) (EXPT 2 (+ 1 K)))
		     0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable tau)
		  :use (top-13 top-14 top-49)))))

(defthm STICK-LEMMA
    (implies (and (integerp n)
		  (>= n 0)
		  (integerp a)
		  (>= a 0)
		  (< a (expt 2 n))
		  (integerp b)
		  (>= b 0)
		  (< b (expt 2 n))
		  (integerp k)
		  (>= k 0)
		  (< k n)
		  (or (= c 0) (= c 1)))
	     (iff (= (mod (+ a b c) (expt 2 (1+ k))) 0)
		  (= (mod (tau a b c n) (expt 2 (1+ k))) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable tau)
		  :induct (nat-induct k))
	  ("Subgoal *1/2" :in-theory (disable tau)
			  :use (top-50))
	  ("Subgoal *1/1" :use (top-12))))




