(in-package "ACL2")
;(include-book "include-book-macros")

(include-book "ground-zero")
;(include-book "defs")

(include-book "bvecp")
(include-book "expt")
(include-book "expt2")
(include-book "ash")
(include-book "expo")
(include-book "expo2")
(include-book "arith2")
(include-book "float")


(defun encode (x n)
  (if (zp n) 
      0
    (if (= x (ash 1 n))
        n
      (encode x (1- n)))))
(in-theory (disable encode))

(defthm encode-nonnegative-integer-type
  (and (integerp (encode x n))
       (<= 0 (encode x n)))
  :hints (("Goal" :in-theory (enable encode))))

;this rule is no better than encode-nonnegative-integer-type and might be worse:
(in-theory (disable (:type-prescription encode)))

(defthm encode-natp
  (natp (encode x n)))

;move
(defthm expo-lower-bound-2
  (implies (and (case-split (rationalp x))
                (case-split (<= 0 x))
                (case-split (not (= x 0)))
                )
           (<= (expt 2 (expo x)) x))
  :rule-classes :linear
)

(defthm bvecp-encode-helper
  (implies (and (case-split (integerp n))
                (case-split (<= 0 n))
                )
           (BVECP (ENCODE x n) (+ 1 (expo n)))) ;The +1 is necessary
  :hints (("Subgoal *1/5" :use (:instance EXPT-MONOTONE-linear-eric
                                          (i (+ 1 (EXPO (+ -1 N)))) 
                                          (j (+ 1 (EXPO N))))
           :in-theory (set-difference-theories
                       (enable encode bvecp power2p ash-rewrite)
                       '(
                         expt-compare
                         )))
          ("Goal"
           :in-theory (set-difference-theories
                       (enable encode bvecp power2p ash-rewrite)
                       '(
                         expt-compare
                         )))
          ))

(defthm bvecp-encode
  (implies (and (<= (+ 1 (expo n)) m)
                (case-split (integerp m))
                )
           (BVECP (ENCODE x n) m))
  :hints (("Goal" :in-theory (disable bvecp-encode-helper)
           :expand (ENCODE X N)
           :use  (bvecp-encode-helper))))
    

; may not need this now
(defthm encode-reduce-n
  (implies (and (integerp n)
                (<= 0 n)
                (bvecp x n))
           (equal (encode x n)
                  (encode x (+ -1 n))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable encode bvecp power2p ash-rewrite )
                              '(
                                expt-compare
                                )))))


