(in-package "ACL2")

;this book contains very basic expt stuff (i couldn't include expt.lisp in basic.lisp because of a circular dependency)

(include-book "power2p")
(include-book "negative-syntaxp")
(local (include-book "predicate"))
(local (include-book "fp2"))
(local (include-book "numerator"))
(local (include-book "denominator"))
(include-book "fl2") ;remove
(local (include-book "arith2"))

(in-theory (disable expt))

(encapsulate 
 ()
 (local (include-book "../../../arithmetic/top"))
 (defthm a16
   (equal (expt (* a b) i)
          (* (expt a i) (expt b i)))
   :hints
   (("Goal" :in-theory (enable distributivity-of-expt-over-*))))

;gen
;split off the non-integer case
 (defthm expt-split
   (implies (and (integerp i1)
                 (integerp i2)
                 (case-split (acl2-numberp r)) ;(integerp r)
                 (case-split (not (equal r 0)))
                 )
            (equal (expt r (+ i1 i2))
                   (* (expt r i1)
                      (expt r i2))))
   :hints (("Goal" :in-theory (enable expt)))
   )
 )

(defthm expt-2-positive-rational-type
   (and (rationalp (expt 2 i))
        (< 0 (expt 2 i)))
   :hints (("Goal" :in-theory (enable expt) ))
   :rule-classes ((:type-prescription :typed-term (expt 2 i))))


(in-theory (disable expt-split))
