<?php
/*******************************************************************************
** Basic Analysis and Security Engine (BASE)
** Copyright (C) 2004 BASE Project Team
** Copyright (C) 2000 Carnegie Mellon University
**
** (see the file 'base_main.php' for license details)
**
** Project Leads: Kevin Johnson <kjohnson@secureideas.net>
**                Sean Muller <samwise_diver@users.sourceforge.net>
** Built upon work by Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
**
** Purpose: English language file
**      To translate into another language, copy this file and
**          translate each variable into your chosen language.
**          Leave any variable not translated so that the system will have
**          something to display.
********************************************************************************
** Authors:
********************************************************************************
** Kevin Johnson <kjohnson@secureideas.net>
** Joel Esler <joelesler@users.sourceforge.net>
** Czech tranlation by: Michal Mertl <mime@traveller.cz>
********************************************************************************
*/

//locale
DEFINE('_LOCALESTR1', 'eng_ENG.ISO8859-1'); //NEW
DEFINE('_LOCALESTR2', 'eng_ENG.utf-8'); //NEW
DEFINE('_LOCALESTR3', 'english'); //NEW
DEFINE('_STRFTIMEFORMAT','%a %B %d, %Y %H:%M:%S'); //NEW - see strftime() sintax

//common phrases
DEFINE('_CHARSET','iso-8859-2');
DEFINE('_TITLE','Basic Analysis and Security Engine (BASE) '.$BASE_installID);
DEFINE('_FRMLOGIN','Login:');
DEFINE('_FRMPWD','Heslo:');
DEFINE('_SOURCE','Zdroj');
DEFINE('_SOURCENAME','Jmno zdoje');
DEFINE('_DEST','Cl');
DEFINE('_DESTNAME','Jmno cle');
DEFINE('_SORD','Zdroj n. cl');
DEFINE('_EDIT','Upravit');
DEFINE('_DELETE','Smazat');
DEFINE('_ID','ID');
DEFINE('_NAME','Jmno');
DEFINE('_INTERFACE','Rozhran');
DEFINE('_FILTER','Filtr');
DEFINE('_DESC','Popis');
DEFINE('_LOGIN','Login');
DEFINE('_ROLEID','ID role');
DEFINE('_ENABLED','Enabled');
DEFINE('_SUCCESS','Successful');
DEFINE('_SENSOR','Senzor');
DEFINE('_SENSORS','Sensors'); //NEW
DEFINE('_SIGNATURE','Podpis');
DEFINE('_TIMESTAMP','asov znaka');
DEFINE('_NBSOURCEADDR','Zdrojov&nbsp;adresa');
DEFINE('_NBDESTADDR','Clov&nbsp;adresa');
DEFINE('_NBLAYER4','Protokol 4. vrstvy');
DEFINE('_PRIORITY','Priorita');
DEFINE('_EVENTTYPE','typ udlosti');
DEFINE('_JANUARY','Leden');
DEFINE('_FEBRUARY','nor');
DEFINE('_MARCH','Bezen');
DEFINE('_APRIL','Duben');
DEFINE('_MAY','Kvten');
DEFINE('_JUNE','erven');
DEFINE('_JULY','ervenec');
DEFINE('_AUGUST','Srpen');
DEFINE('_SEPTEMBER','Z');
DEFINE('_OCTOBER','jen');
DEFINE('_NOVEMBER','Listopad');
DEFINE('_DECEMBER','Prosinec');
DEFINE('_LAST','Posledn');
DEFINE('_FIRST','First'); //NEW
DEFINE('_TOTAL','Total'); //NEW
DEFINE('_ALERT','Alarm');
DEFINE('_ADDRESS','Adresa');
DEFINE('_UNKNOWN','neznm');
DEFINE('_AND','AND'); //NEW
DEFINE('_OR','OR'); //NEW
DEFINE('_IS','is'); //NEW
DEFINE('_ON','on'); //NEW
DEFINE('_IN','in'); //NEW
DEFINE('_ANY','any'); //NEW
DEFINE('_NONE','none'); //NEW
DEFINE('_HOUR','Hour'); //NEW
DEFINE('_DAY','Day'); //NEW
DEFINE('_MONTH','Month'); //NEW
DEFINE('_YEAR','Year'); //NEW
DEFINE('_ALERTGROUP','Alert Group'); //NEW
DEFINE('_ALERTTIME','Alert Time'); //NEW
DEFINE('_CONTAINS','contains'); //NEW
DEFINE('_DOESNTCONTAIN','does not contain'); //NEW
DEFINE('_SOURCEPORT','source port'); //NEW
DEFINE('_DESTPORT','dest port'); //NEW
DEFINE('_HAS','has'); //NEW
DEFINE('_HASNOT','has not'); //NEW
DEFINE('_PORT','Port'); //NEW
DEFINE('_FLAGS','Flags'); //NEW
DEFINE('_MISC','Misc'); //NEW
DEFINE('_BACK','Back'); //NEW
DEFINE('_DISPYEAR','{ year }'); //NEW
DEFINE('_DISPMONTH','{ month }'); //NEW
DEFINE('_DISPHOUR','{ hour }'); //NEW
DEFINE('_DISPDAY','{ day }'); //NEW
DEFINE('_DISPTIME','{ time }'); //NEW
DEFINE('_ADDADDRESS','ADD Addr'); //NEW
DEFINE('_ADDIPFIELD','ADD IP Field'); //NEW
DEFINE('_ADDTIME','ADD TIME'); //NEW
DEFINE('_ADDTCPPORT','ADD TCP Port'); //NEW
DEFINE('_ADDTCPFIELD','ADD TCP Field'); //NEW
DEFINE('_ADDUDPPORT','ADD UDP Port'); //NEW
DEFINE('_ADDUDPFIELD','ADD UDP Field'); //NEW
DEFINE('_ADDICMPFIELD','ADD ICMP Field'); //NEW
DEFINE('_ADDPAYLOAD','ADD Payload'); //NEW
DEFINE('_MOSTFREQALERTS','Most Frequent Alerts'); //NEW
DEFINE('_MOSTFREQPORTS','Most Frequent Ports'); //NEW
DEFINE('_MOSTFREQADDRS','Most Frequent IP addresses'); //NEW
DEFINE('_LASTALERTS','Last Alerts'); //NEW
DEFINE('_LASTPORTS','Last Ports'); //NEW
DEFINE('_LASTTCP','Last TCP Alerts'); //NEW
DEFINE('_LASTUDP','Last UDP Alerts'); //NEW
DEFINE('_LASTICMP','Last ICMP Alerts'); //NEW
DEFINE('_QUERYDB','Query DB'); //NEW
DEFINE('_QUERYDBP','Query+DB'); //NEW - Equals to _QUERYDB where spaces are '+'s. 
                                //Should be something like: DEFINE('_QUERYDBP',str_replace(" ", "+", _QUERYDB));
DEFINE('_SELECTED','Selected'); //NEW
DEFINE('_ALLONSCREEN','ALL on Screen'); //NEW
DEFINE('_ENTIREQUERY','Entire Query'); //NEW
DEFINE('_OPTIONS','Options'); //NEW
DEFINE('_LENGTH','length'); //NEW
DEFINE('_CODE','code'); //NEW
DEFINE('_DATA','data'); //NEW
DEFINE('_TYPE','type'); //NEW
DEFINE('_NEXT','Next'); //NEW
DEFINE('_PREVIOUS','Previous'); //NEW

//Menu items
DEFINE('_HOME','Dom');
DEFINE('_SEARCH','Hledat');
DEFINE('_AGMAINT','Sprva skupin alarm');
DEFINE('_USERPREF','Uivatelsk volby');
DEFINE('_CACHE','Ke a stav');
DEFINE('_ADMIN','Administrace');
DEFINE('_GALERTD','Vytvoit graf alarm');
DEFINE('_GALERTDT','Vytvoit graf asu detekce alarm');
DEFINE('_USERMAN','Sprva uivatel');
DEFINE('_LISTU','Seznam uivatel');
DEFINE('_CREATEU','Vytvoit uivatele');
DEFINE('_ROLEMAN','Sprva rol');
DEFINE('_LISTR','Seznam rol');
DEFINE('_CREATER','Vytvoit roli');
DEFINE('_LISTALL','Vypsat ve');
DEFINE('_CREATE','Vytvo');
DEFINE('_VIEW','Zobraz');
DEFINE('_CLEAR','Vyisti');
DEFINE('_LISTGROUPS','Seznam skupin');
DEFINE('_CREATEGROUPS','Vytvo skupinu');
DEFINE('_VIEWGROUPS','Zobraz skupinu');
DEFINE('_EDITGROUPS','Edituj skupinu');
DEFINE('_DELETEGROUPS','Sma skupinu');
DEFINE('_CLEARGROUPS','Vyisti skupinu');
DEFINE('_CHNGPWD','Zmnit heslo');
DEFINE('_DISPLAYU','Zobraz uivatele');

//base_footer.php
DEFINE('_FOOTER',' (by <A class="largemenuitem" href="mailto:base@secureideas.net">Kevin Johnson</A> and the <A class="largemenuitem" href="http://sourceforge.net/project/memberlist.php?group_id=103348">BASE Project Team</A><BR>Built on ACID by Roman Danyliw )');

//index.php --Log in Page
DEFINE('_LOGINERROR','Uivatel neexistuje nebo jste zadali patn heslo!<br>Zkuste prosm znovu.');

// base_main.php
DEFINE('_MOSTRECENT','Poslednch ');
DEFINE('_MOSTFREQUENT','Nejastjch ');
DEFINE('_ALERTS',' alarm:');
DEFINE('_ADDRESSES',' adres:');
DEFINE('_ANYPROTO','jakkoliv<br>protokol');
DEFINE('_UNI','uniktn');
DEFINE('_LISTING','vpis');
DEFINE('_TALERTS','Dnen alarmy: ');
DEFINE('_SOURCEIP','Source IP'); //NEW
DEFINE('_DESTIP','Destination IP'); //NEW
DEFINE('_L24ALERTS','Alarmy za poslednch 24 hodin: ');
DEFINE('_L72ALERTS','Alarmy za poslednch 72 hodin: ');
DEFINE('_UNIALERTS','uniktnch alarm');
DEFINE('_LSOURCEPORTS','Posledn zdrojov porty: ');
DEFINE('_LDESTPORTS','Posledn clov porty: ');
DEFINE('_FREGSOURCEP','Nejastj zdrojov porty: ');
DEFINE('_FREGDESTP','Nejastj clov porty: ');
DEFINE('_QUERIED','Dotzno ');
DEFINE('_DATABASE','Databze:');
DEFINE('_SCHEMAV','Verze schmatu:');
DEFINE('_TIMEWIN','asov rozmez:');
DEFINE('_NOALERTSDETECT','dn alarmy dezjitny');
DEFINE('_USEALERTDB','Use Alert Database'); //NEW
DEFINE('_USEARCHIDB','Use Archive Database'); //NEW
DEFINE('_TRAFFICPROBPRO','Traffic Profile by Protocol'); //NEW

//base_auth.inc.php
DEFINE('_ADDEDSF','spn pidn');
DEFINE('_NOPWDCHANGE','Nelze zmnit heslo: ');
DEFINE('_NOUSER','Uivatel neexistuje!');
DEFINE('_OLDPWD','Aktuln heslo nen sprvn!');
DEFINE('_PWDCANT','Nelze zmnit heslo: ');
DEFINE('_PWDDONE','Heslo bylo zmnno.');
DEFINE('_ROLEEXIST','Role existuje');
DEFINE('_ROLEIDEXIST','ID role existuje');
DEFINE('_ROLEADDED','Role pidna spn');

//base_roleadmin.php
DEFINE('_ROLEADMIN','Sprva rol BASE');
DEFINE('_FRMROLEID','ID role:');
DEFINE('_FRMROLENAME','Jmno role:');
DEFINE('_FRMROLEDESC','Popis:');
DEFINE('_UPDATEROLE','Update Role'); //NEW

//base_useradmin.php
DEFINE('_USERADMIN','Sprva uivatel BASE');
DEFINE('_FRMFULLNAME','Cel jmno:');
DEFINE('_FRMROLE','Role:');
DEFINE('_FRMUID','ID uivatele:');
DEFINE('_SUBMITQUERY','Submit Query'); //NEW
DEFINE('_UPDATEUSER','Update User'); //NEW

//admin/index.php
DEFINE('_BASEADMIN','Administrace BASE');
DEFINE('_BASEADMINTEXT','Zvolte prosm operaci nalevo.');

//base_action.inc.php
DEFINE('_NOACTION','Nebyla specifikovna operace');
DEFINE('_INVALIDACT',' je neplatn operace');
DEFINE('_ERRNOAG','Nemohu pidat alarmy; nebyla specifikovna skupina');
DEFINE('_ERRNOEMAIL','Nemohu zaslat alarmy potou; nebyla specifikovna emailov adresa');
DEFINE('_ACTION','Operace');
DEFINE('_CONTEXT','kontext');
DEFINE('_ADDAGID','Pidat do skupiny (podle ID)');
DEFINE('_ADDAG','Pidat do nov vytvoen skupiny'); // not used
DEFINE('_ADDAGNAME','Pidat do skupiny (podle jmna)');
DEFINE('_CREATEAG','Pidat do nov vytvoen skupiny');
DEFINE('_CLEARAG','Vymazat se skupiny');
DEFINE('_DELETEALERT','Smazat');
DEFINE('_EMAILALERTSFULL','Zaslat emailem (detailn)');
DEFINE('_EMAILALERTSSUMM','Zaslat emailem (shrnut)');
DEFINE('_EMAILALERTSCSV','Zaslat emailem (csv)');
DEFINE('_ARCHIVEALERTSCOPY','Archivovat (vytvoit kopii)');
DEFINE('_ARCHIVEALERTSMOVE','Archivovat (pesunout)');
DEFINE('_IGNORED','Ignorovno');
DEFINE('_DUPALERTS',' duplicitn alarm(y)');
DEFINE('_ALERTSPARA',' alarm(y)');
DEFINE('_NOALERTSSELECT','dn alarmy nebyly vybrny nebo');
DEFINE('_NOTSUCCESSFUL','nebyla spn');
DEFINE('_ERRUNKAGID','Zadno neznm ID skupiny (skupina pravdpodobn neexistuje)');
DEFINE('_ERRREMOVEFAIL','Selhalo odstrann nov skupiny');
DEFINE('_GENBASE','Vytvoeno BASE');
DEFINE('_ERRNOEMAILEXP','Chyba pi exportovn: Nemohu poslat alarmy');
DEFINE('_ERRNOEMAILPHP','Zkontrolujte konfiguraci emailu PHP.');
DEFINE('_ERRDELALERT','Chyba pi mazn alarmu');
DEFINE('_ERRARCHIVE','Chyba pi archivaci:');
DEFINE('_ERRMAILNORECP','Chyba pi zasln emailem: Nebyl zadn pjemce');

//base_cache.inc.php
DEFINE('_ADDED','Pidno ');
DEFINE('_HOSTNAMESDNS',' jmen do IP DNS vyrovnvac pamti');
DEFINE('_HOSTNAMESWHOIS',' jmen do Whois vyrovnvac pamti');
DEFINE('_ERRCACHENULL','Chyba pi aktualizaci vyrovnvac pamti: nalezena NULL dka event?');
DEFINE('_ERRCACHEERROR','Chyba pi aktualizaci vyrovnvac pamti:');
DEFINE('_ERRCACHEUPDATE','Nemohu aktualizovat vyrovnvac pam');
DEFINE('_ALERTSCACHE',' alarm do vyrovnvac pamti');

//base_db.inc.php
DEFINE('_ERRSQLTRACE','Nemohu otevt soubor pro trasovn SQL');
DEFINE('_ERRSQLCONNECT','Chyba pi pipojovn databze:');
DEFINE('_ERRSQLCONNECTINFO','<P>Zkontrolujte promnn pro pipojovn se do databze v souboru <I>base_conf.php</I> 
              <PRE>
               = $alert_dbname   : jmno databze 
               = $alert_host     : hostitel
               = $alert_port     : port
               = $alert_user     : uivatelsk jmno
               = $alert_password : heslo
              </PRE>
              <P>');
DEFINE('_ERRSQLPCONNECT','Chyba pi pipojovn databze:');
DEFINE('_ERRSQLDB','Databzov chyba:');
DEFINE('_DBALCHECK','Kontraoluje knihovnu pro prci s databz v');
DEFINE('_ERRSQLDBALLOAD1','<P><B>Chyba pi natn knihovny pro prci s databz: </B> od ');
DEFINE('_ERRSQLDBALLOAD2','<P>Zkontrolujte promnnou pro uren cesty ke knihovn pro prci s databz <CODE>$DBlib_path</CODE> v souboru <CODE>base_conf.php</CODE>
            <P>Knihovnu pro prci s databz ADODB sthnte z
            <A HREF="http://adodb.sourceforge.net/">http://adodb.sourceforge.net/</A>');
DEFINE('_ERRSQLDBTYPE','Specifikovn neplatn typ databze');
DEFINE('_ERRSQLDBTYPEINFO1','Promnn <CODE>\$DBtype</CODE> v souboru <CODE>base_conf.php</CODE> byla patn nastavena na ');
DEFINE('_ERRSQLDBTYPEINFO2','Podporovny jsou pouze nsledujc databzov systmy: <PRE>
                MySQL         : \'mysql\'
                PostgreSQL    : \'postgres\'
                MS SQL Server : \'mssql\'
                MS SQL Server : \'mssql\'
                Oracle        : \'oci8\'
             </PRE>');

//base_log_error.inc.php
DEFINE('_ERRBASEFATAL','Kritick chyba BASE:');

//base_log_timing.inc.php
DEFINE('_LOADEDIN','Nateno za');
DEFINE('_SECONDS','vtein');

//base_net.inc.php
DEFINE('_ERRRESOLVEADDRESS','Nemohu peloit adresu');

//base_output_query.inc.php
DEFINE('_QUERYRESULTSHEADER','Zhlav vsledk dotazu'); //not used

//base_signature.inc.php
DEFINE('_ERRSIGNAMEUNK','neznm SigName');
DEFINE('_ERRSIGPROIRITYUNK','neznm SigPriority');
DEFINE('_UNCLASS','nezaazeno');

//base_state_citems.inc.php
DEFINE('_DENCODED','data zakdvna jako');
DEFINE('_NODENCODED','(dn konverze dat, pedpokldm poadavek ve vchozm formtu databze)');
DEFINE('_SHORTJAN','Jan'); //NEW
DEFINE('_SHORTFEB','Feb'); //NEW
DEFINE('_SHORTMAR','Mar'); //NEW
DEFINE('_SHORTAPR','Apr'); //NEW
DEFINE('_SHORTMAY','May'); //NEW
DEFINE('_SHORTJUN','Jun'); //NEW
DEFINE('_SHORTJLY','Jly'); //NEW
DEFINE('_SHORTAUG','Aug'); //NEW
DEFINE('_SHORTSEP','Sep'); //NEW
DEFINE('_SHORTOCT','Oct'); //NEW
DEFINE('_SHORTNOV','Nov'); //NEW
DEFINE('_SHORTDEC','Dec'); //NEW
DEFINE('_DISPSIG','{ signature }'); //NEW
DEFINE('_DISPANYCLASS','{ any Classification }'); //NEW
DEFINE('_DISPANYPRIO','{ any Priority }'); //NEW
DEFINE('_DISPANYSENSOR','{ any Sensor }'); //NEW
DEFINE('_DISPADDRESS','{ adress }'); //NEW
DEFINE('_DISPFIELD','{ field }'); //NEW
DEFINE('_DISPPORT','{ port }'); //NEW
DEFINE('_DISPENCODING','{ encoding }'); //NEW
DEFINE('_DISPCONVERT2','{ Convert To }'); //NEW
DEFINE('_DISPANYAG','{ any Alert Group }'); //NEW
DEFINE('_DISPPAYLOAD','{ payload }'); //NEW
DEFINE('_DISPFLAGS','{ flags }'); //NEW
DEFINE('_SIGEXACTLY','exactly'); //NEW
DEFINE('_SIGROUGHLY','roughly'); //NEW
DEFINE('_SIGCLASS','Signature Classification'); //NEW
DEFINE('_SIGPRIO','Signature Priority'); //NEW
DEFINE('_SHORTSOURCE','Source'); //NEW
DEFINE('_SHORTDEST','Dest'); //NEW
DEFINE('_SHORTSOURCEORDEST','Src or Dest'); //NEW
DEFINE('_NOLAYER4','no layer4'); //NEW
DEFINE('_INPUTCRTENC','Input Criteria Encoding Type'); //NEW
DEFINE('_CONVERT2WS','Convert To (when searching)'); //NEW

//base_state_common.inc.php
DEFINE('_PHPERRORCSESSION','PHP ERROR: A custom (user) PHP session have been detected. However, BASE has not been set to explicitly use this custom handler. Set <CODE>use_user_session=1</CODE> in <CODE>base_conf.php</CODE>');
DEFINE('_PHPERRORCSESSIONCODE','PHP ERROR: A custom (user) PHP session hander has been configured, but the supplied hander code specified in <CODE>user_session_path</CODE> is invalid.');
DEFINE('_PHPERRORCSESSIONVAR','PHP ERROR: A custom (user) PHP session handler has been configured, but the implementation of this handler has not been specified in BASE.  If a custom session handler is desired, set the <CODE>user_session_path</CODE> variable in <CODE>base_conf.php</CODE>.');
DEFINE('_PHPSESSREG','Sezen zaregistrovno');

//base_state_criteria.inc.php
DEFINE('_REMOVE','Odstranit');
DEFINE('_FROMCRIT','z kritri');
DEFINE('_ERRCRITELEM','Neplatn elemt kritria');

//base_state_query.inc.php
DEFINE('_VALIDCANNED','Platn zkladn dotaz');
DEFINE('_DISPLAYING','Zobrazuji');
DEFINE('_DISPLAYINGTOTAL','Zobrazuji alarmy %d-%d z %d celkem');
DEFINE('_NOALERTS','dn alarmy nenalezeny.');
DEFINE('_QUERYRESULTS','Vsledky dotazu');
DEFINE('_QUERYSTATE','Stav dotazu');
DEFINE('_DISPACTION','{ action }'); //NEW

//base_ag_common.php
DEFINE('_ERRAGNAMESEARCH','Jmenovanou skupinu nelze nalzt. Zkuste to znovu.');
DEFINE('_ERRAGNAMEEXIST','Zadan skupina neexistuje.');
DEFINE('_ERRAGIDSEARCH','Skupinu urenou ID nelze nalzt. Zkuste to znovu.');
DEFINE('_ERRAGLOOKUP','Chyba pi vyhledvn skupiny dle ID');
DEFINE('_ERRAGINSERT','Chyba pi vkldn nov skupiny');

//base_ag_main.php
DEFINE('_AGMAINTTITLE','Sprva skupin');
DEFINE('_ERRAGUPDATE','Chyba pi aktualizaci skupiny');
DEFINE('_ERRAGPACKETLIST','Chyba pi mazn obsahu skupiny:');
DEFINE('_ERRAGDELETE','Chyba pi mazn skupiny');
DEFINE('_AGDELETE','smazna spn');
DEFINE('_AGDELETEINFO','informace smazna');
DEFINE('_ERRAGSEARCHINV','Zadan vyhledvac kritrium je neplatn. Zkuste to znovu.');
DEFINE('_ERRAGSEARCHNOTFOUND','dn skupiny s tmto kritriem nenalezena.');
DEFINE('_NOALERTGOUPS','Nejsou definovny dn skupiny');
DEFINE('_NUMALERTS','poet alarm');
DEFINE('_ACTIONS','Akce');
DEFINE('_NOTASSIGN','jet nepiazeno');
DEFINE('_SAVECHANGES','Save Changes'); //NEW
DEFINE('_CONFIRMDELETE','Confirm Delete'); //NEW
DEFINE('_CONFIRMCLEAR','Confirm Clear'); //NEW

//base_common.php
DEFINE('_PORTSCAN','Provoz skenovn port');

//base_db_common.php
DEFINE('_ERRDBINDEXCREATE','Nemohu vytvoit index pro');
DEFINE('_DBINDEXCREATE','spn vytvoen index pro');
DEFINE('_ERRSNORTVER','Me se jednat o star verzi. Podporovny jsou pouze databze vytvoen Snort 1.7-beta0 nebo novjm');
DEFINE('_ERRSNORTVER1','Zkladn databze');
DEFINE('_ERRSNORTVER2','se zd nekompletn nebo neplatn');
DEFINE('_ERRDBSTRUCT1','Verze databze je sprvn, ale neobsahuje');
DEFINE('_ERRDBSTRUCT2','BASE tabulky. Pouijte <A HREF="base_db_setup.php">Inicializan strnku</A> pro nastaven a optimalizaci databze.');
DEFINE('_ERRPHPERROR','Chyba PHP');
DEFINE('_ERRPHPERROR1','Nekompatibiln verze');
DEFINE('_ERRVERSION','Verze');
DEFINE('_ERRPHPERROR2','PHP je pli star. Provete prosm aktualizaci na verzi 4.0.4 nebo pozdj');
DEFINE('_ERRPHPMYSQLSUP','<B>PHP podpora nen kompletn</B>: <FONT>podpora pro prci s MySQL 
               databz nen soust instalace.
               Prosm peinstalujte PHP s potebnou knihovnou (<CODE>--with-mysql</CODE>)</FONT>');
DEFINE('_ERRPHPPOSTGRESSUP','<B>PHP podpora nen kompletn</B>: <FONT>podpora pro prci s PostgreSQL
               databz nen soust instalace.
               Prosm peinstalujte PHP s potebnou knihovnou (<CODE>--with-pgsql</CODE>)</FONT>');
DEFINE('_ERRPHPMSSQLSUP','<B>PHP podpora nen kompletn</B>: <FONT>podpora pro prci s MS SQL
               databz nen soust instalace.
               Prosm peinstalujte PHP s potebnou knihovnou (<CODE>--enable-mssql</CODE>)</FONT>');
DEFINE('_ERRPHPORACLESUP','<B>PHP podpora nen kompletn</B>: <FONT>podpora pro prci s Oracle
               databz nen soust instalace.
               Prosm peinstalujte PHP s potebnou knihovnou (<CODE>--with-oci8</CODE>)</FONT>');

//base_graph_form.php
DEFINE('_CHARTTITLE','Nadpis grafu:');
DEFINE('_CHARTTYPE','Chart Type:'); //NEW
DEFINE('_CHARTTYPES','{ chart type }'); //NEW
DEFINE('_CHARTPERIOD','Chart Period:'); //NEW
DEFINE('_PERIODNO','no period'); //NEW
DEFINE('_PERIODWEEK','7 (a week)'); //NEW
DEFINE('_PERIODDAY','24 (whole day)'); //NEW
DEFINE('_PERIOD168','168 (24x7)'); //NEW
DEFINE('_CHARTSIZE','Size: (width x height)'); //NEW
DEFINE('_PLOTMARGINS','Plot Margins: (left x right x top x bottom)'); //NEW
DEFINE('_PLOTTYPE','Plot type:'); //NEW
DEFINE('_TYPEBAR','bar'); //NEW
DEFINE('_TYPELINE','line'); //NEW
DEFINE('_TYPEPIE','pie'); //NEW
DEFINE('_CHARTHOUR','{hora}'); //NEW
DEFINE('_CHARTDAY','{dia}'); //NEW
DEFINE('_CHARTMONTH','{mês}'); //NEW
DEFINE('_GRAPHALERTS','Graph Alerts'); //NEW
DEFINE('_AXISCONTROLS','X / Y AXIS CONTROLS'); //NEW
DEFINE('_CHRTTYPEHOUR','as (hodiny) proti potu alarm');
DEFINE('_CHRTTYPEDAY','as (dny) proti potu alarm');
DEFINE('_CHRTTYPEWEEK','as (tdny) proti potu alarm');
DEFINE('_CHRTTYPEMONTH','as (msce) proti potu alarm');
DEFINE('_CHRTTYPEYEAR','as (roky) proti potu alarm');
DEFINE('_CHRTTYPESRCIP','Zdrojov IP adresa proti potu alarm');
DEFINE('_CHRTTYPEDSTIP','Clov IP adresa proti potu alarm');
DEFINE('_CHRTTYPEDSTUDP','Clov UDP port proti potu alarm');
DEFINE('_CHRTTYPESRCUDP','Zdrojov UDP port proti potu alarm');
DEFINE('_CHRTTYPEDSTPORT','Clov TCP port proti potu alarm');
DEFINE('_CHRTTYPESRCPORT','Zdrojov TCP port proti potu alarm');
DEFINE('_CHRTTYPESIG','Klasifikace podpis proti potu alarm');
DEFINE('_CHRTTYPESENSOR','Senzor proti potu alarm');
DEFINE('_CHRTBEGIN','Zatek grafu:');
DEFINE('_CHRTEND','Konec grafu:');
DEFINE('_CHRTDS','Zdroj dat:');
DEFINE('_CHRTX','Osa X');
DEFINE('_CHRTY','Osa Y');
DEFINE('_CHRTMINTRESH','Minimln hodnota');
DEFINE('_CHRTROTAXISLABEL','Otoit popisky os o 90 stup');
DEFINE('_CHRTSHOWX','Zobraz rastr pro osu X');
DEFINE('_CHRTDISPLABELX','Zobraz popis osy X kadch');
DEFINE('_CHRTDATAPOINTS','vzork dat');
DEFINE('_CHRTYLOG','Osa Y logaritmick');
DEFINE('_CHRTYGRID','Zobraz rastr pro osu Y');

//base_graph_main.php
DEFINE('_CHRTTITLE','Graf BASE');
DEFINE('_ERRCHRTNOTYPE','Nebyl uren typ grafu');
DEFINE('_ERRNOAGSPEC','Nebyla urena skupiny. Pouvm vechny alarmy.');
DEFINE('_CHRTDATAIMPORT','Zanm natat data'); 
DEFINE('_CHRTTIMEVNUMBER','as port proti potu alarm');
DEFINE('_CHRTTIME','as');
DEFINE('_CHRTALERTOCCUR','Vskyty alarm');
DEFINE('_CHRTSIPNUMBER','Zdrojov IP adresa proti potu alarm');
DEFINE('_CHRTSIP','Zdrojov IP adresa');
DEFINE('_CHRTDIPALERTS','Clov IP adresa proti potu alarm');
DEFINE('_CHRTDIP','Clov IP adresa');
DEFINE('_CHRTUDPPORTNUMBER','UDP port (cl) port proti potu alarm');
DEFINE('_CHRTDUDPPORT','Clov UDP port');
DEFINE('_CHRTSUDPPORTNUMBER','UDP port (zdroj) port proti potu alarm');
DEFINE('_CHRTSUDPPORT','Zdrojov UDP port');
DEFINE('_CHRTPORTDESTNUMBER','TCP port (cl) port proti potu alarm');
DEFINE('_CHRTPORTDEST','Clov TCP port');
DEFINE('_CHRTPORTSRCNUMBER','TCP port (zdroj) port proti potu alarm');
DEFINE('_CHRTPORTSRC','Zdrojov TCP port');
DEFINE('_CHRTSIGNUMBER','Klasifikace podpis proti potu alarm');
DEFINE('_CHRTCLASS','Klasifikace');
DEFINE('_CHRTSENSORNUMBER','Senzor port proti potu alarm');
DEFINE('_CHRTHANDLEPERIOD','Rozhodn obdob (pokud je teba)');
DEFINE('_CHRTDUMP','Vypisuji data ... (zobrazuji jen kad');
DEFINE('_CHRTDRAW','Kreslm graf');
DEFINE('_ERRCHRTNODATAPOINTS','Pro vykreslen nejsou k dispozici dn data');
DEFINE('_GRAPHALERTDATA','Graph Alert Data'); //NEW

//base_maintenance.php
DEFINE('_MAINTTITLE','drba');
DEFINE('_MNTPHP','PHP popis:');
DEFINE('_MNTCLIENT','CLIENT:');
DEFINE('_MNTSERVER','SERVER:');
DEFINE('_MNTSERVERHW','SERVER HW:');
DEFINE('_MNTPHPVER','PHP VERZE:');
DEFINE('_MNTPHPAPI','PHP API:');
DEFINE('_MNTPHPLOGLVL','rove hlen PHP:');
DEFINE('_MNTPHPMODS','Nahran moduly:');
DEFINE('_MNTDBTYPE','Typ databze:');
DEFINE('_MNTDBALV','Verze podprn databzov knihovny:');
DEFINE('_MNTDBALERTNAME','Jmno ALERT databze:');
DEFINE('_MNTDBARCHNAME','Jmno ARCHIVE databze:');
DEFINE('_MNTAIC','Vyrovnvac pam alarm:');
DEFINE('_MNTAICTE','Celkov poet udlost:');
DEFINE('_MNTAICCE','Udlosti ve vyrovnvac pamti:');
DEFINE('_MNTIPAC','Vyrovnvac pam IP address');
DEFINE('_MNTIPACUSIP','Uniktn zdrojov IP:');
DEFINE('_MNTIPACDNSC','DNS ve vyrovnvac pamti:');
DEFINE('_MNTIPACWC','Whois ve vyrovnvac pamti:');
DEFINE('_MNTIPACUDIP','Uniktn clov IP:');

//base_qry_alert.php
DEFINE('_QAINVPAIR','Neplatn pr (sid,cid)');
DEFINE('_QAALERTDELET','Alarm smazn');
DEFINE('_QATRIGGERSIG','Detekovan podpis alarmu');
DEFINE('_QANORMALD','Normal Display'); //NEW
DEFINE('_QAPLAIND','Plain Display'); //NEW
DEFINE('_QANOPAYLOAD','Fast logging used so payload was discarded'); //NEW

//base_qry_common.php
DEFINE('_QCSIG','podpis');
DEFINE('_QCIPADDR','IP adresy');
DEFINE('_QCIPFIELDS','IP pole');
DEFINE('_QCTCPPORTS','TCP porty');
DEFINE('_QCTCPFLAGS','TCP vlajky');
DEFINE('_QCTCPFIELD','TCP pole');
DEFINE('_QCUDPPORTS','UDP porty');
DEFINE('_QCUDPFIELDS','UDP pole');
DEFINE('_QCICMPFIELDS','ICMP poel');
DEFINE('_QCDATA','Data');
DEFINE('_QCERRCRITWARN','Varovn vyhledvacch kritri:');
DEFINE('_QCERRVALUE','Hodnota');
DEFINE('_QCERRFIELD','Pole');
DEFINE('_QCERROPER','Opertor');
DEFINE('_QCERRDATETIME','Hodnota datum/as');
DEFINE('_QCERRPAYLOAD','Hodnota obsahu');
DEFINE('_QCERRIP','IP adresa');
DEFINE('_QCERRIPTYPE','IP adresa typu');
DEFINE('_QCERRSPECFIELD','bylo zadno pole protokolu, ale nebyla urena hodnota.');
DEFINE('_QCERRSPECVALUE','bylo vybrno, ale nebyla urena hodnota.');
DEFINE('_QCERRBOOLEAN','Vce pol pro uren protokolu bylo zadno, ale nebyl mezi nimi zadn logick opertor (AND, OR).');
DEFINE('_QCERRDATEVALUE','bylo zvoleno, e se m vyhledvat podle data/asu, ale nebyla urena hodnota.');
DEFINE('_QCERRINVHOUR','(Neplatn hodina) dn kritrium pro uren data/asu neodpovd urenmu asu.');
DEFINE('_QCERRDATECRIT','bylo zvoleno, e se m vyhledvat podle data/asu, ale nebyla urena hodnota.');
DEFINE('_QCERROPERSELECT','bylo vloeno, ale nebyl zvolen dn opertor.');
DEFINE('_QCERRDATEBOOL','Vce kritri datum/as bylo zadno bez uren logickho opertoru (AND, OR) mezi nimi.');
DEFINE('_QCERRPAYCRITOPER','byl uren obsah, kter se m vyhledvat, ale nebylo zvoleno, zda m bt obsaen nebo ne.');
DEFINE('_QCERRPAYCRITVALUE','bylo ureno, e se m vyhledvat podle obsahu, ale nebyla urena hodnota.');
DEFINE('_QCERRPAYBOOL','Vce kritri obsahu bylo zadno bez urent logickho opertoru (AND, OR) mezi nimi.');
DEFINE('_QCMETACRIT','Meta kritria');
DEFINE('_QCIPCRIT','IP kritria');
DEFINE('_QCPAYCRIT','Obsahov kritria');
DEFINE('_QCTCPCRIT','TCP kritria');
DEFINE('_QCUDPCRIT','UDP kritria');
DEFINE('_QCICMPCRIT','ICMP kritria');
DEFINE('_QCLAYER4CRIT','Layer 4 Criteria'); //NEW
DEFINE('_QCERRINVIPCRIT','Neplatn kritrium IP adresy');
DEFINE('_QCERRCRITADDRESSTYPE','byla zvolena jako kritrium, ale nebylo ureno, zda se jedn o zdrojovou nebo clovou adresu.');
DEFINE('_QCERRCRITIPADDRESSNONE','ukazujc, e IP adresa m bt kritriem, ale nebyla urena hodnota.');
DEFINE('_QCERRCRITIPADDRESSNONE1','bylo vybrno (v #');
DEFINE('_QCERRCRITIPIPBOOL','Vce kritri pro IP adresy bylo zadno bez uren logickho opertoru (AND, OR) mezi nimi.');

//base_qry_form.php
DEFINE('_QFRMSORTORDER','Smr tdn');
DEFINE('_QFRMSORTNONE','none'); //NEW
DEFINE('_QFRMTIMEA','as (vzestupn)');
DEFINE('_QFRMTIMED','as (sestupn)');
DEFINE('_QFRMSIG','podpis');
DEFINE('_QFRMSIP','zdrojov IP adresa');
DEFINE('_QFRMDIP','clov IP adresa');

//base_qry_sqlcalls.php
DEFINE('_QSCSUMM','Souhrn statistiky');
DEFINE('_QSCTIMEPROF','Profil v ase');
DEFINE('_QSCOFALERTS','z alarm');

//base_stat_alerts.php
DEFINE('_ALERTTITLE','Vpis alarm');

//base_stat_common.php
DEFINE('_SCCATEGORIES','Kategorie:');
DEFINE('_SCSENSORTOTAL','Senzory/Celkem:');
DEFINE('_SCTOTALNUMALERTS','Celkov poet alarm:');
DEFINE('_SCSRCIP','Zdrojovch IP adres:');
DEFINE('_SCDSTIP','Clovch IP adres:');
DEFINE('_SCUNILINKS','Uniktnch IP spoj');
DEFINE('_SCSRCPORTS','Zdrojovch port: ');
DEFINE('_SCDSTPORTS','Clovch port: ');
DEFINE('_SCSENSORS','Senzor');
DEFINE('_SCCLASS','Klasifikace');
DEFINE('_SCUNIADDRESS','Uniktnch adres: ');
DEFINE('_SCSOURCE','Zdroj');
DEFINE('_SCDEST','Cl');
DEFINE('_SCPORT','Port');

//base_stat_ipaddr.php
DEFINE('_PSEVENTERR','PORTSCAN EVENT ERROR: ');
DEFINE('_PSEVENTERRNOFILE','No file was specified in the \$portscan_file variable.');
DEFINE('_PSEVENTERROPENFILE','Unable to open Portscan event file');
DEFINE('_PSDATETIME','Date/Time');
DEFINE('_PSSRCIP','Source IP');
DEFINE('_PSDSTIP','Destination IP');
DEFINE('_PSSRCPORT','Source Port');
DEFINE('_PSDSTPORT','Destination Port');
DEFINE('_PSTCPFLAGS','TCP Flags');
DEFINE('_PSTOTALOCC','Total<BR> Occurrences');
DEFINE('_PSNUMSENSORS','Num of Sensors');
DEFINE('_PSFIRSTOCC','First<BR> Occurrence');
DEFINE('_PSLASTOCC','Last<BR> Occurrence');
DEFINE('_PSUNIALERTS','Unique Alerts');
DEFINE('_PSPORTSCANEVE','Portscan Events');
DEFINE('_PSREGWHOIS','Registry lookup (whois) in');
DEFINE('_PSNODNS','no DNS resolution attempted');
DEFINE('_PSNUMSENSORSBR','Num of <BR>Sensors');
DEFINE('_PSOCCASSRC','Occurances <BR>as Src.');
DEFINE('_PSOCCASDST','Occurances <BR>as Dest.');
DEFINE('_PSWHOISINFO','Whois Information');
DEFINE('_PSTOTALHOSTS','Total Hosts Scanned'); //NEW
DEFINE('_PSDETECTAMONG','%d unique alerts detected among %d alerts on %s'); //NEW
DEFINE('_PSALLALERTSAS','all alerts with %s/%s as'); //NEW
DEFINE('_PSSHOW','show'); //NEW
DEFINE('_PSEXTERNAL','external'); //NEW

//base_stat_iplink.php
DEFINE('_SIPLTITLE','IP spoje');
DEFINE('_SIPLSOURCEFGDN','Zdrojov FQDN');
DEFINE('_SIPLDESTFGDN','Clov FQDN');
DEFINE('_SIPLDIRECTION','Smr');
DEFINE('_SIPLPROTO','Protokol');
DEFINE('_SIPLUNIDSTPORTS','Uniktnch clovch port');
DEFINE('_SIPLUNIEVENTS','Uniktnch alarm');
DEFINE('_SIPLTOTALEVENTS','Celkem alarm');

//base_stat_ports.php
DEFINE('_UNIQ','Uniktn');
DEFINE('_DSTPS','clov porty');
DEFINE('_SRCPS','zdrojov porty');
DEFINE('_OCCURRENCES','Occurrences'); //NEW

//base_stat_sensor.php
DEFINE('SPSENSORLIST','Vpis senzor');

//base_stat_time.php
DEFINE('_BSTTITLE','Time Profile of Alerts');
DEFINE('_BSTTIMECRIT','Time Criteria');
DEFINE('_BSTERRPROFILECRIT','<FONT><B>No profiling criteria was specified!</B>  Click on "hour", "day", or "month" to choose the granularity of the aggregate statistics.</FONT>');
DEFINE('_BSTERRTIMETYPE','<FONT><B>The type of time parameter which will be passed was not specified!</B>  Choose either "on", to specify a single date, or "between" to specify an interval.</FONT>');
DEFINE('_BSTERRNOYEAR','<FONT><B>No Year parameter was specified!</B></FONT>');
DEFINE('_BSTERRNOMONTH','<FONT><B>No Month parameter was specified!</B></FONT>');
DEFINE('_BSTERRNODAY','<FONT><B>No Day parameter was specified!</B></FONT>');
DEFINE('_BSTPROFILEBY','Profile by'); //NEW
DEFINE('_TIMEON','on'); //NEW
DEFINE('_TIMEBETWEEN','between'); //NEW
DEFINE('_PROFILEALERT','Profile Alert'); //NEW

//base_stat_uaddr.php
DEFINE('_UNISADD','Uniktn zdrojov IP adresy');
DEFINE('_SUASRCIP','Zdrojov IP adresa');
DEFINE('_SUAERRCRITADDUNK','chyba v kritriu: neznm typ adresy -- pedpokldm clovou');
DEFINE('_UNIDADD','Uniktn clov IP adresy');
DEFINE('_SUADSTIP','Clov IP adresa');
DEFINE('_SUAUNIALERTS','Uniktnch alarm');
DEFINE('_SUASRCADD','Zdrojovch adres');
DEFINE('_SUADSTADD','Clovch adres');

//base_user.php
DEFINE('_BASEUSERTITLE','Uivatelsk pedvolby BASE');
DEFINE('_BASEUSERERRPWD','Heslo nesm bt przn nebo heslo nesouhlas!');
DEFINE('_BASEUSEROLDPWD','Star heslo:');
DEFINE('_BASEUSERNEWPWD','Nov heslo:');
DEFINE('_BASEUSERNEWPWDAGAIN','Nov heslo znovu:');

DEFINE('_LOGOUT','Odhlsit');
?>
